/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.OffsetNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.TraverseNoParseNodeVisitor;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;

public class OffsetCompiler {
    private static final ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();
    public static final PDatum OFFSET_DATUM = new PDatum(){

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public PDataType getDataType() {
            return PInteger.INSTANCE;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public SortOrder getSortOrder() {
            return SortOrder.getDefault();
        }
    };

    private OffsetCompiler() {
    }

    public static Integer compile(StatementContext context, FilterableStatement statement) throws SQLException {
        OffsetNode offsetNode = statement.getOffset();
        if (offsetNode == null) {
            return null;
        }
        OffsetParseNodeVisitor visitor = new OffsetParseNodeVisitor(context);
        offsetNode.getOffsetParseNode().accept(visitor);
        return visitor.getOffset();
    }

    private static class OffsetParseNodeVisitor
    extends TraverseNoParseNodeVisitor<Void> {
        private final StatementContext context;
        private Integer offset;

        public OffsetParseNodeVisitor(StatementContext context) {
            this.context = context;
        }

        public Integer getOffset() {
            return this.offset;
        }

        @Override
        public Void visit(LiteralParseNode node) throws SQLException {
            Integer offset;
            Object offsetValue = node.getValue();
            if (offsetValue != null && (offset = (Integer)OFFSET_DATUM.getDataType().toObject(offsetValue, node.getType())) >= 0) {
                this.offset = offset;
            }
            return null;
        }

        @Override
        public Void visit(BindParseNode node) throws SQLException {
            if (this.context == null) {
                return null;
            }
            Object value = this.context.getBindManager().getBindValue(node);
            this.context.getBindManager().addParamMetaData(node, OFFSET_DATUM);
            this.visit(NODE_FACTORY.literal(value, OFFSET_DATUM.getDataType()));
            return null;
        }
    }
}

