/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.ExpressionProjector;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.BaseTerminalExpression;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.ProjectedColumnExpression;
import org.apache.phoenix.expression.SingleCellColumnExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.expression.visitor.ProjectedColumnExpressionVisitor;
import org.apache.phoenix.expression.visitor.ReplaceArrayFunctionExpressionVisitor;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.FamilyWildcardParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.SequenceValueParseNode;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableWildcardParseNode;
import org.apache.phoenix.parse.WildcardParseNode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ArgumentTypeMismatchException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.LocalIndexDataColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;

public class ProjectionCompiler {
    private static final Expression NULL_EXPRESSION = LiteralExpression.newConstant(null);

    private ProjectionCompiler() {
    }

    private static void projectColumnFamily(PTable table, Scan scan, byte[] family) {
        scan.addFamily(family);
    }

    public static RowProjector compile(StatementContext context, SelectStatement statement, GroupByCompiler.GroupBy groupBy) throws SQLException {
        return ProjectionCompiler.compile(context, statement, groupBy, Collections.emptyList(), NULL_EXPRESSION);
    }

    private static int getMinPKOffset(PTable table, PName tenantId) {
        int posOffset;
        int n = posOffset = table.getBucketNum() == null ? 0 : 1;
        if (table.isMultiTenant() && tenantId != null) {
            ++posOffset;
        }
        if (table.getViewIndexId() != null) {
            ++posOffset;
        }
        return posOffset;
    }

    private static void projectAllTableColumns(StatementContext context, TableRef tableRef, boolean resolveColumn, List<Expression> projectedExpressions, List<ExpressionProjector> projectedColumns, List<? extends PDatum> targetColumns) throws SQLException {
        ColumnResolver resolver = context.getResolver();
        PTable table = tableRef.getTable();
        int projectedOffset = projectedExpressions.size();
        int posOffset = table.getBucketNum() == null ? 0 : 1;
        int minPKOffset = ProjectionCompiler.getMinPKOffset(table, context.getConnection().getTenantId());
        int j = posOffset;
        for (int i = posOffset; i < table.getColumns().size(); ++i) {
            PColumn column = table.getColumns().get(i);
            if (SchemaUtil.isPKColumn(column) && j++ < minPKOffset) {
                ++posOffset;
                continue;
            }
            ColumnRef ref = new ColumnRef(tableRef, i);
            String colName = ref.getColumn().getName().getString();
            String tableAlias = tableRef.getTableAlias();
            if (resolveColumn) {
                try {
                    String schemaName;
                    ref = tableAlias != null ? resolver.resolveColumn(null, tableAlias, colName) : resolver.resolveColumn((schemaName = table.getSchemaName().getString()).length() == 0 ? null : schemaName, table.getTableName().getString(), colName);
                }
                catch (AmbiguousColumnException e) {
                    if (column.getFamilyName() != null) {
                        ref = resolver.resolveColumn(tableAlias != null ? tableAlias : table.getTableName().getString(), column.getFamilyName().getString(), colName);
                    }
                    throw e;
                }
            }
            Expression expression = ref.newColumnExpression();
            expression = ProjectionCompiler.coerceIfNecessary(i - posOffset + projectedOffset, targetColumns, expression);
            ImmutableBytesWritable ptr = context.getTempPtr();
            if (IndexUtil.getViewConstantValue(column, ptr)) {
                expression = LiteralExpression.newConstant(column.getDataType().toObject(ptr), expression.getDataType());
            }
            projectedExpressions.add(expression);
            boolean isCaseSensitive = !SchemaUtil.normalizeIdentifier(colName).equals(colName);
            projectedColumns.add(new ExpressionProjector(colName, tableRef.getTableAlias() == null ? table.getName().getString() : tableRef.getTableAlias(), expression, isCaseSensitive));
        }
    }

    private static void projectAllIndexColumns(StatementContext context, TableRef tableRef, boolean resolveColumn, List<Expression> projectedExpressions, List<ExpressionProjector> projectedColumns, List<? extends PDatum> targetColumns) throws SQLException {
        ColumnResolver resolver = context.getResolver();
        PTable index = tableRef.getTable();
        int projectedOffset = projectedExpressions.size();
        PhoenixConnection conn = context.getConnection();
        PName tenantId = conn.getTenantId();
        String tableName = index.getParentName().getString();
        PTable dataTable = null;
        try {
            dataTable = conn.getTable(new PTableKey(tenantId, tableName));
        }
        catch (TableNotFoundException e) {
            if (tenantId != null) {
                dataTable = conn.getTable(new PTableKey(null, tableName));
            }
            throw e;
        }
        int tableOffset = dataTable.getBucketNum() == null ? 0 : 1;
        int minTablePKOffset = ProjectionCompiler.getMinPKOffset(dataTable, tenantId);
        int minIndexPKOffset = ProjectionCompiler.getMinPKOffset(index, tenantId);
        if (index.getIndexType() != PTable.IndexType.LOCAL && index.getColumns().size() - minIndexPKOffset != dataTable.getColumns().size() - minTablePKOffset) {
            String schemaNameStr = dataTable.getSchemaName() == null ? null : dataTable.getSchemaName().getString();
            String tableNameStr = dataTable.getTableName() == null ? null : dataTable.getTableName().getString();
            throw new ColumnNotFoundException(schemaNameStr, tableNameStr, null, WildcardParseNode.INSTANCE.toString());
        }
        int j = tableOffset;
        for (int i = tableOffset; i < dataTable.getColumns().size(); ++i) {
            PColumn column = dataTable.getColumns().get(i);
            if (SchemaUtil.isPKColumn(column) && j++ < minTablePKOffset) {
                ++tableOffset;
                continue;
            }
            PColumn tableColumn = dataTable.getColumns().get(i);
            String indexColName = IndexUtil.getIndexColumnName(tableColumn);
            PColumn indexColumn = null;
            ColumnRef ref = null;
            try {
                indexColumn = index.getColumnForColumnName(indexColName);
                ref = new ColumnRef(tableRef, indexColumn.getPosition());
            }
            catch (ColumnNotFoundException e) {
                if (index.getIndexType() == PTable.IndexType.LOCAL) {
                    try {
                        ref = new LocalIndexDataColumnRef(context, indexColName);
                        indexColumn = ref.getColumn();
                    }
                    catch (ColumnFamilyNotFoundException c) {
                        throw e;
                    }
                }
                throw e;
            }
            String colName = tableColumn.getName().getString();
            String tableAlias = tableRef.getTableAlias();
            if (resolveColumn) {
                try {
                    String schemaName;
                    ref = tableAlias != null ? resolver.resolveColumn(null, tableAlias, indexColName) : resolver.resolveColumn((schemaName = index.getSchemaName().getString()).length() == 0 ? null : schemaName, index.getTableName().getString(), indexColName);
                }
                catch (AmbiguousColumnException e) {
                    if (indexColumn.getFamilyName() != null) {
                        ref = resolver.resolveColumn(tableAlias != null ? tableAlias : index.getTableName().getString(), indexColumn.getFamilyName().getString(), indexColName);
                    }
                    throw e;
                }
            }
            Expression expression = ref.newColumnExpression();
            expression = ProjectionCompiler.coerceIfNecessary(i - tableOffset + projectedOffset, targetColumns, expression);
            projectedExpressions.add(expression);
            boolean isCaseSensitive = !SchemaUtil.normalizeIdentifier(colName).equals(colName);
            ExpressionProjector projector = new ExpressionProjector(colName, tableRef.getTableAlias() == null ? dataTable.getName().getString() : tableRef.getTableAlias(), expression, isCaseSensitive);
            projectedColumns.add(projector);
        }
    }

    private static void projectTableColumnFamily(StatementContext context, String cfName, TableRef tableRef, boolean resolveColumn, List<Expression> projectedExpressions, List<ExpressionProjector> projectedColumns) throws SQLException {
        PTable table = tableRef.getTable();
        PColumnFamily pfamily = table.getColumnFamily(cfName);
        for (PColumn column : pfamily.getColumns()) {
            ColumnRef ref = new ColumnRef(tableRef, column.getPosition());
            if (resolveColumn) {
                ref = context.getResolver().resolveColumn(table.getTableName().getString(), cfName, column.getName().getString());
            }
            Expression expression = ref.newColumnExpression();
            projectedExpressions.add(expression);
            String colName = column.getName().toString();
            boolean isCaseSensitive = !SchemaUtil.normalizeIdentifier(colName).equals(colName);
            projectedColumns.add(new ExpressionProjector(colName, tableRef.getTableAlias() == null ? table.getName().getString() : tableRef.getTableAlias(), expression, isCaseSensitive));
        }
    }

    private static void projectIndexColumnFamily(StatementContext context, String cfName, TableRef tableRef, boolean resolveColumn, List<Expression> projectedExpressions, List<ExpressionProjector> projectedColumns) throws SQLException {
        PTable index = tableRef.getTable();
        PhoenixConnection conn = context.getConnection();
        String tableName = index.getParentName().getString();
        PTable table = conn.getTable(new PTableKey(conn.getTenantId(), tableName));
        PColumnFamily pfamily = table.getColumnFamily(cfName);
        for (PColumn column : pfamily.getColumns()) {
            String indexColName = IndexUtil.getIndexColumnName(column);
            PColumn indexColumn = null;
            ColumnRef ref = null;
            String indexColumnFamily = null;
            try {
                indexColumn = index.getColumnForColumnName(indexColName);
                ref = new ColumnRef(tableRef, indexColumn.getPosition());
                indexColumnFamily = indexColumn.getFamilyName() == null ? null : indexColumn.getFamilyName().getString();
            }
            catch (ColumnNotFoundException e) {
                if (index.getIndexType() == PTable.IndexType.LOCAL) {
                    try {
                        ref = new LocalIndexDataColumnRef(context, indexColName);
                        indexColumn = ref.getColumn();
                        indexColumnFamily = indexColumn.getFamilyName() == null ? null : (index.getIndexType() == PTable.IndexType.LOCAL ? IndexUtil.getLocalIndexColumnFamily(indexColumn.getFamilyName().getString()) : indexColumn.getFamilyName().getString());
                    }
                    catch (ColumnFamilyNotFoundException c) {
                        throw e;
                    }
                }
                throw e;
            }
            if (resolveColumn) {
                ref = context.getResolver().resolveColumn(index.getTableName().getString(), indexColumnFamily, indexColName);
            }
            Expression expression = ref.newColumnExpression();
            projectedExpressions.add(expression);
            String colName = column.getName().toString();
            boolean isCaseSensitive = !SchemaUtil.normalizeIdentifier(colName).equals(colName);
            projectedColumns.add(new ExpressionProjector(colName, tableRef.getTableAlias() == null ? table.getName().getString() : tableRef.getTableAlias(), expression, isCaseSensitive));
        }
    }

    private static Expression coerceIfNecessary(int index, List<? extends PDatum> targetColumns, Expression expression) throws SQLException {
        PDatum targetColumn;
        if (index < targetColumns.size() && (targetColumn = targetColumns.get(index)).getDataType() != expression.getDataType()) {
            PDataType targetType = targetColumn.getDataType();
            if (expression.getDataType() != null && !expression.getDataType().isCastableTo(targetType)) {
                throw new ArgumentTypeMismatchException(targetType, expression.getDataType(), "column: " + targetColumn);
            }
            expression = CoerceExpression.create(expression, targetType, targetColumn.getSortOrder(), targetColumn.getMaxLength());
        }
        return expression;
    }

    /*
     * WARNING - void declaration
     */
    public static RowProjector compile(StatementContext context, SelectStatement statement, GroupByCompiler.GroupBy groupBy, List<? extends PDatum> targetColumns, Expression where) throws SQLException {
        void var24_38;
        ArrayList<KeyValueColumnExpression> arrayKVRefs = new ArrayList<KeyValueColumnExpression>();
        ArrayList arrayProjectedColumnRefs = new ArrayList();
        ArrayList<Expression> arrayKVFuncs = new ArrayList<Expression>();
        ArrayList arrayOldFuncs = new ArrayList();
        HashMap arrayExpressionCounts = new HashMap();
        List<AliasedNode> aliasedNodes = statement.getSelect();
        SelectClauseVisitor selectVisitor = new SelectClauseVisitor(context, groupBy, arrayKVRefs, arrayKVFuncs, arrayExpressionCounts, arrayProjectedColumnRefs, arrayOldFuncs, statement);
        ArrayList<ExpressionProjector> projectedColumns = new ArrayList<ExpressionProjector>();
        ColumnResolver resolver = context.getResolver();
        TableRef tableRef = context.getCurrentTable();
        PTable table = tableRef.getTable();
        boolean resolveColumn = !tableRef.equals(resolver.getTables().get(0));
        boolean isWildcard = false;
        Scan scan = context.getScan();
        int index = 0;
        ArrayList projectedExpressions = Lists.newArrayListWithExpectedSize((int)aliasedNodes.size());
        ArrayList projectedFamilies = Lists.newArrayListWithExpectedSize((int)aliasedNodes.size());
        for (AliasedNode aliasedNode : aliasedNodes) {
            ParseNode parseNode = aliasedNode.getNode();
            if (parseNode instanceof WildcardParseNode) {
                if (statement.isAggregate()) {
                    ExpressionCompiler.throwNonAggExpressionInAggException(parseNode.toString());
                }
                if (tableRef == TableRef.EMPTY_TABLE_REF) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_TABLE_SPECIFIED_FOR_WILDCARD_SELECT).build().buildException();
                }
                isWildcard = true;
                if (tableRef.getTable().getType() == PTableType.INDEX && ((WildcardParseNode)parseNode).isRewrite()) {
                    ProjectionCompiler.projectAllIndexColumns(context, tableRef, resolveColumn, projectedExpressions, projectedColumns, targetColumns);
                } else {
                    ProjectionCompiler.projectAllTableColumns(context, tableRef, resolveColumn, projectedExpressions, projectedColumns, targetColumns);
                }
            } else if (parseNode instanceof TableWildcardParseNode) {
                TableName tName = ((TableWildcardParseNode)parseNode).getTableName();
                TableRef tRef = resolver.resolveTable(tName.getSchemaName(), tName.getTableName());
                if (tRef.equals(tableRef)) {
                    isWildcard = true;
                }
                if (tRef.getTable().getType() == PTableType.INDEX && ((TableWildcardParseNode)parseNode).isRewrite()) {
                    ProjectionCompiler.projectAllIndexColumns(context, tRef, true, projectedExpressions, projectedColumns, targetColumns);
                } else {
                    ProjectionCompiler.projectAllTableColumns(context, tRef, true, projectedExpressions, projectedColumns, targetColumns);
                }
            } else if (parseNode instanceof FamilyWildcardParseNode) {
                if (tableRef == TableRef.EMPTY_TABLE_REF) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_TABLE_SPECIFIED_FOR_WILDCARD_SELECT).build().buildException();
                }
                String cfName = ((FamilyWildcardParseNode)parseNode).getName();
                projectedFamilies.add(Bytes.toBytes((String)cfName));
                if (tableRef.getTable().getType() == PTableType.INDEX && ((FamilyWildcardParseNode)parseNode).isRewrite()) {
                    ProjectionCompiler.projectIndexColumnFamily(context, cfName, tableRef, resolveColumn, projectedExpressions, projectedColumns);
                } else {
                    ProjectionCompiler.projectTableColumnFamily(context, cfName, tableRef, resolveColumn, projectedExpressions, projectedColumns);
                }
            } else {
                String name;
                String columnAlias;
                Expression expression = parseNode.accept(selectVisitor);
                projectedExpressions.add(expression);
                expression = ProjectionCompiler.coerceIfNecessary(index, targetColumns, expression);
                if (parseNode instanceof BindParseNode) {
                    context.getBindManager().addParamMetaData((BindParseNode)parseNode, expression);
                }
                if (!parseNode.isStateless() && !selectVisitor.isAggregate() && statement.isAggregate()) {
                    ExpressionCompiler.throwNonAggExpressionInAggException(expression.toString());
                }
                String string = columnAlias = aliasedNode.getAlias() != null ? aliasedNode.getAlias() : SchemaUtil.normalizeIdentifier(aliasedNode.getNode().getAlias());
                boolean isCaseSensitive = aliasedNode.getAlias() != null ? aliasedNode.isCaseSensitve() : (columnAlias != null ? SchemaUtil.isCaseSensitive(aliasedNode.getNode().getAlias()) : selectVisitor.isCaseSensitive);
                String string2 = name = columnAlias == null ? expression.toString() : columnAlias;
                projectedColumns.add(new ExpressionProjector(name, tableRef.getTableAlias() == null ? (table.getName() == null ? "" : table.getName().getString()) : tableRef.getTableAlias(), expression, isCaseSensitive));
            }
            selectVisitor.reset();
            ++index;
        }
        for (int i = arrayProjectedColumnRefs.size() - 1; i >= 0; --i) {
            Expression expression = (Expression)arrayProjectedColumnRefs.get(i);
            Integer n = (Integer)arrayExpressionCounts.get(expression);
            if (n == 0) continue;
            arrayKVRefs.remove(i);
            arrayKVFuncs.remove(i);
            arrayOldFuncs.remove(i);
        }
        if (arrayKVFuncs.size() > 0 && arrayKVRefs.size() > 0) {
            ProjectionCompiler.serailizeArrayIndexInformationAndSetInScan(context, arrayKVFuncs, arrayKVRefs);
            KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
            for (Expression expression : arrayKVRefs) {
                builder.addField(expression);
            }
            KeyValueSchema kvSchema = builder.build();
            ValueBitSet valueBitSet = ValueBitSet.newInstance(kvSchema);
            builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
            for (Expression expression : arrayKVFuncs) {
                builder.addField(expression);
            }
            KeyValueSchema arrayIndexesSchema = builder.build();
            HashMap<Expression, Expression> replacementMap = new HashMap<Expression, Expression>();
            for (int i = 0; i < arrayOldFuncs.size(); ++i) {
                Expression function = (Expression)arrayKVFuncs.get(i);
                replacementMap.put((Expression)arrayOldFuncs.get(i), new ArrayIndexExpression(i, function.getDataType(), valueBitSet, arrayIndexesSchema));
            }
            ReplaceArrayFunctionExpressionVisitor visitor = new ReplaceArrayFunctionExpressionVisitor(replacementMap);
            for (int i = 0; i < projectedColumns.size(); ++i) {
                ExpressionProjector projector = (ExpressionProjector)projectedColumns.get(i);
                projectedColumns.set(i, new ExpressionProjector(projector.getName(), tableRef.getTableAlias() == null ? (table.getName() == null ? "" : table.getName().getString()) : tableRef.getTableAlias(), projector.getExpression().accept(visitor), projector.isCaseSensitive()));
            }
        }
        boolean isProjectEmptyKeyValue = false;
        if (isWildcard) {
            ProjectionCompiler.projectAllColumnFamilies(table, scan);
        } else {
            isProjectEmptyKeyValue = where == null || LiteralExpression.isTrue(where) || where.requiresFinalEvaluation();
            for (byte[] byArray : projectedFamilies) {
                ProjectionCompiler.projectColumnFamily(table, scan, byArray);
            }
        }
        int estimatedKeySize = table.getRowKeySchema().getEstimatedValueLength();
        boolean bl = false;
        for (Map.Entry entry : scan.getFamilyMap().entrySet()) {
            try {
                PColumnFamily family = table.getColumnFamily((byte[])entry.getKey());
                if (entry.getValue() == null) {
                    for (PColumn column : family.getColumns()) {
                        Integer maxLength = column.getMaxLength();
                        int byteSize = column.getDataType().isFixedWidth() ? (maxLength == null ? column.getDataType().getByteSize() : maxLength) : 10;
                        var24_38 += 64 + estimatedKeySize + byteSize;
                    }
                    continue;
                }
                for (byte[] cq : (NavigableSet)entry.getValue()) {
                    PColumn column = family.getPColumnForColumnQualifier(cq);
                    Integer maxLength = column.getMaxLength();
                    int byteSize = column.getDataType().isFixedWidth() ? (maxLength == null ? column.getDataType().getByteSize() : maxLength) : 10;
                    var24_38 += 64 + estimatedKeySize + byteSize;
                }
            }
            catch (ColumnFamilyNotFoundException columnFamilyNotFoundException) {
            }
        }
        return new RowProjector(projectedColumns, Math.max(estimatedKeySize, (int)var24_38), isProjectEmptyKeyValue, resolver.hasUDFs(), isWildcard);
    }

    private static void projectAllColumnFamilies(PTable table, Scan scan) {
        scan.getFamilyMap().clear();
        for (PColumnFamily family : table.getColumnFamilies()) {
            scan.addFamily(family.getName().getBytes());
        }
    }

    private static void serailizeArrayIndexInformationAndSetInScan(StatementContext context, List<Expression> arrayKVFuncs, List<KeyValueColumnExpression> arrayKVRefs) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(stream);
            WritableUtils.writeVInt((DataOutput)output, (int)arrayKVRefs.size());
            for (Expression expression : arrayKVRefs) {
                expression.write(output);
            }
            WritableUtils.writeVInt((DataOutput)output, (int)arrayKVFuncs.size());
            for (Expression expression : arrayKVFuncs) {
                expression.write(output);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        context.getScan().setAttribute("_SpecificArrayIndex", stream.toByteArray());
    }

    private static class SelectClauseVisitor
    extends ExpressionCompiler {
        private boolean isCaseSensitive;
        private int elementCount;
        private List<KeyValueColumnExpression> arrayKVRefs;
        private List<Expression> arrayKVFuncs;
        private List<Expression> arrayOldFuncs;
        private List<ProjectedColumnExpression> arrayProjectedColumnRefs;
        private Map<Expression, Integer> arrayExpressionCounts;
        private SelectStatement statement;

        private SelectClauseVisitor(StatementContext context, GroupByCompiler.GroupBy groupBy, List<KeyValueColumnExpression> arrayKVRefs, List<Expression> arrayKVFuncs, Map<Expression, Integer> arrayExpressionCounts, List<ProjectedColumnExpression> arrayProjectedColumnRefs, List<Expression> arrayOldFuncs, SelectStatement statement) {
            super(context, groupBy);
            this.arrayKVRefs = arrayKVRefs;
            this.arrayKVFuncs = arrayKVFuncs;
            this.arrayOldFuncs = arrayOldFuncs;
            this.arrayExpressionCounts = arrayExpressionCounts;
            this.arrayProjectedColumnRefs = arrayProjectedColumnRefs;
            this.statement = statement;
            this.reset();
        }

        @Override
        public void reset() {
            super.reset();
            this.elementCount = 0;
            this.isCaseSensitive = true;
        }

        @Override
        protected ColumnRef resolveColumn(ColumnParseNode node) throws SQLException {
            ColumnRef ref = super.resolveColumn(node);
            this.isCaseSensitive = this.isCaseSensitive && node.isCaseSensitive();
            return ref;
        }

        @Override
        public Expression visit(ColumnParseNode node) throws SQLException {
            Expression expression = super.visit(node);
            if (expression.getDataType().isArrayType()) {
                Integer count = this.arrayExpressionCounts.get(expression);
                this.arrayExpressionCounts.put(expression, count != null ? count + 1 : 1);
            }
            return expression;
        }

        @Override
        public void addElement(List<Expression> l, Expression element) {
            ++this.elementCount;
            this.isCaseSensitive &= this.elementCount == 1;
            super.addElement(l, element);
        }

        @Override
        public Expression visit(SequenceValueParseNode node) throws SQLException {
            if (this.aggregateFunction != null) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_USE_OF_NEXT_VALUE_FOR).setSchemaName(node.getTableName().getSchemaName()).setTableName(node.getTableName().getTableName()).build().buildException();
            }
            return this.context.getSequenceManager().newSequenceReference(node);
        }

        @Override
        public Expression visitLeave(FunctionParseNode node, List<Expression> children) throws SQLException {
            if (!this.statement.isAggregate() && "ARRAY_ELEM".equals(node.getName()) && children.get(0) instanceof ProjectedColumnExpression) {
                final ArrayList indexKVs = Lists.newArrayList();
                final ArrayList indexProjectedColumns = Lists.newArrayList();
                final ArrayList<Expression> copyOfChildren = new ArrayList<Expression>(children);
                children.get(0).accept(new ProjectedColumnExpressionVisitor(){

                    @Override
                    public Void visit(ProjectedColumnExpression expression) {
                        if (expression.getDataType().isArrayType()) {
                            indexProjectedColumns.add(expression);
                            PColumn col = expression.getColumn();
                            PTable table = SelectClauseVisitor.this.context.getCurrentTable().getTable();
                            KeyValueColumnExpression keyValueColumnExpression = table.getImmutableStorageScheme() != PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN ? new SingleCellColumnExpression(col, col.getName().getString(), table.getEncodingScheme()) : new KeyValueColumnExpression(col);
                            indexKVs.add(keyValueColumnExpression);
                            copyOfChildren.set(0, keyValueColumnExpression);
                            Integer count = (Integer)SelectClauseVisitor.this.arrayExpressionCounts.get(expression);
                            SelectClauseVisitor.this.arrayExpressionCounts.put(expression, count != null ? count - 1 : -1);
                        }
                        return null;
                    }
                });
                Object func = super.visitLeave(node, (List)children);
                if (!indexKVs.isEmpty()) {
                    this.arrayKVRefs.addAll(indexKVs);
                    this.arrayProjectedColumnRefs.addAll(indexProjectedColumns);
                    Object funcModified = super.visitLeave(node, (List)copyOfChildren);
                    this.arrayKVFuncs.add((Expression)funcModified);
                    this.arrayOldFuncs.add((Expression)func);
                }
                return func;
            }
            return super.visitLeave(node, (List)children);
        }
    }

    static class ArrayIndexExpression
    extends BaseTerminalExpression {
        private final int position;
        private final PDataType type;
        private final ValueBitSet arrayIndexesBitSet;
        private final KeyValueSchema arrayIndexesSchema;

        public ArrayIndexExpression(int position, PDataType type, ValueBitSet arrayIndexesBitSet, KeyValueSchema arrayIndexesSchema) {
            this.position = position;
            this.type = type;
            this.arrayIndexesBitSet = arrayIndexesBitSet;
            this.arrayIndexesSchema = arrayIndexesSchema;
        }

        @Override
        public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
            if (!tuple.getValue(QueryConstants.ARRAY_VALUE_COLUMN_FAMILY, QueryConstants.ARRAY_VALUE_COLUMN_QUALIFIER, ptr)) {
                return false;
            }
            int maxOffset = ptr.getOffset() + ptr.getLength();
            this.arrayIndexesBitSet.or(ptr);
            this.arrayIndexesSchema.iterator(ptr, this.position, this.arrayIndexesBitSet);
            Boolean hasValue = this.arrayIndexesSchema.next(ptr, this.position, maxOffset, this.arrayIndexesBitSet);
            this.arrayIndexesBitSet.clear();
            if (hasValue == null) {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            }
            return true;
        }

        @Override
        public PDataType getDataType() {
            return this.type;
        }

        @Override
        public <T> T accept(ExpressionVisitor<T> visitor) {
            return null;
        }
    }
}

