/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.Sequence;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.SequenceUtil;
import org.apache.phoenix.util.ServerUtil;

public class SequenceRegionObserver
extends BaseRegionObserver {
    public static final String OPERATION_ATTRIB = "SEQUENCE_OPERATION";
    public static final String MAX_TIMERANGE_ATTRIB = "MAX_TIMERANGE";
    public static final String CURRENT_VALUE_ATTRIB = "CURRENT_VALUE";
    public static final String NUM_TO_ALLOCATE = "NUM_TO_ALLOCATE";
    private static final byte[] SUCCESS_VALUE = PInteger.INSTANCE.toBytes(0);

    private static Result getErrorResult(byte[] row, long timestamp, int errorCode) {
        byte[] errorCodeBuf = new byte[PInteger.INSTANCE.getByteSize().intValue()];
        PInteger.INSTANCE.getCodec().encodeInt(errorCode, errorCodeBuf, 0);
        return Result.create(Collections.singletonList(KeyValueUtil.newKeyValue(row, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, timestamp, errorCodeBuf)));
    }

    private static void acquireLock(Region region, byte[] key, List<Region.RowLock> locks) throws IOException {
        Region.RowLock rowLock = region.getRowLock(key, true);
        if (rowLock == null) {
            throw new IOException("Failed to acquire lock on " + Bytes.toStringBinary((byte[])key));
        }
        locks.add(rowLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment) throws IOException {
        env = (RegionCoprocessorEnvironment)e.getEnvironment();
        e.bypass();
        e.complete();
        region = env.getRegion();
        row = increment.getRow();
        locks = Lists.newArrayList();
        tr = increment.getTimeRange();
        region.startRegionOperation();
        try {
            block34: {
                block33: {
                    block32: {
                        block31: {
                            block35: {
                                block30: {
                                    SequenceRegionObserver.acquireLock(region, row, locks);
                                    try {
                                        maxTimestamp = tr.getMax();
                                        validateOnly = true;
                                        get = new Get(row);
                                        get.setTimeRange(tr.getMin(), tr.getMax());
                                        for (Result entry : increment.getFamilyCellMap().entrySet()) {
                                            cf = (byte[])entry.getKey();
                                            for (Cell cq : (List)entry.getValue()) {
                                                value = Bytes.toLong((byte[])cq.getValueArray(), (int)cq.getValueOffset());
                                                get.addColumn(cf, CellUtil.cloneQualifier((Cell)cq));
                                                cellTimestamp = cq.getTimestamp();
                                                if (cellTimestamp > 0L && cellTimestamp < maxTimestamp) {
                                                    maxTimestamp = cellTimestamp;
                                                    get.setTimeRange(0L, maxTimestamp);
                                                }
                                                validateOnly &= (long)Sequence.ValueOp.VALIDATE_SEQUENCE.ordinal() == value;
                                            }
                                        }
                                        result = region.get(get);
                                        if (!result.isEmpty()) break block30;
                                        entry = SequenceRegionObserver.getErrorResult(row, maxTimestamp, SQLExceptionCode.SEQUENCE_UNDEFINED.getErrorCode());
                                    }
                                    catch (Throwable var42_46) {
                                        try {
                                            region.releaseRowLocks((List)locks);
                                            throw var42_46;
                                        }
                                        catch (Throwable t) {
                                            ServerUtil.throwIOException("Increment of sequence " + Bytes.toStringBinary((byte[])row), t);
                                            var9_47 = null;
                                            return var9_47;
                                        }
                                    }
                                    region.releaseRowLocks((List)locks);
                                    return entry;
                                }
                                currentValueKV = Sequence.getCurrentValueKV(result);
                                incrementByKV = Sequence.getIncrementByKV(result);
                                cacheSizeKV = Sequence.getCacheSizeKV(result);
                                currentValue = PLong.INSTANCE.getCodec().decodeLong(currentValueKV.getValueArray(), currentValueKV.getValueOffset(), SortOrder.getDefault());
                                incrementBy = PLong.INSTANCE.getCodec().decodeLong(incrementByKV.getValueArray(), incrementByKV.getValueOffset(), SortOrder.getDefault());
                                cacheSize = PLong.INSTANCE.getCodec().decodeLong(cacheSizeKV.getValueArray(), cacheSizeKV.getValueOffset(), SortOrder.getDefault());
                                timestamp = currentValueKV.getTimestamp();
                                put = new Put(row, timestamp);
                                numIncrementKVs = ((List)increment.getFamilyCellMap().get(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES)).size();
                                cells = Sequence.getCells(result, numIncrementKVs);
                                if (numIncrementKVs == Sequence.NUM_SEQUENCE_KEY_VALUES) break block35;
                                newCurrentValueKV = this.createKeyValue(row, PhoenixDatabaseMetaData.CURRENT_VALUE_BYTES, currentValue += incrementBy * cacheSize, timestamp);
                                put.add((Cell)newCurrentValueKV);
                                Sequence.replaceCurrentValueKV(cells, newCurrentValueKV);
                                ** GOTO lbl139
                            }
                            cycleKV = Sequence.getCycleKV(result);
                            limitReachedKV = Sequence.getLimitReachedKV(result);
                            minValueKV = Sequence.getMinValueKV(result);
                            maxValueKV = Sequence.getMaxValueKV(result);
                            v0 = increasingSeq = incrementBy > 0L;
                            if (limitReachedKV == null) {
                                limitReached = false;
                                newLimitReachedKV = this.createKeyValue(row, PhoenixDatabaseMetaData.LIMIT_REACHED_FLAG_BYTES, limitReached, timestamp);
                                put.add((Cell)newLimitReachedKV);
                                Sequence.replaceLimitReachedKV(cells, newLimitReachedKV);
                            } else {
                                limitReached = (Boolean)PBoolean.INSTANCE.toObject(limitReachedKV.getValueArray(), limitReachedKV.getValueOffset(), limitReachedKV.getValueLength());
                            }
                            if (minValueKV == null) {
                                minValue = -9223372036854775808L;
                                newMinValueKV = this.createKeyValue(row, PhoenixDatabaseMetaData.MIN_VALUE_BYTES, minValue, timestamp);
                                put.add((Cell)newMinValueKV);
                                Sequence.replaceMinValueKV(cells, newMinValueKV);
                            } else {
                                minValue = PLong.INSTANCE.getCodec().decodeLong(minValueKV.getValueArray(), minValueKV.getValueOffset(), SortOrder.getDefault());
                            }
                            if (maxValueKV == null) {
                                maxValue = 0x7FFFFFFFFFFFFFFFL;
                                newMaxValueKV = this.createKeyValue(row, PhoenixDatabaseMetaData.MAX_VALUE_BYTES, maxValue, timestamp);
                                put.add((Cell)newMaxValueKV);
                                Sequence.replaceMaxValueKV(cells, newMaxValueKV);
                            } else {
                                maxValue = PLong.INSTANCE.getCodec().decodeLong(maxValueKV.getValueArray(), maxValueKV.getValueOffset(), SortOrder.getDefault());
                            }
                            if (cycleKV == null) {
                                cycle = false;
                                newCycleKV = this.createKeyValue(row, PhoenixDatabaseMetaData.CYCLE_FLAG_BYTES, cycle, timestamp);
                                put.add((Cell)newCycleKV);
                                Sequence.replaceCycleValueKV(cells, newCycleKV);
                            } else {
                                cycle = (Boolean)PBoolean.INSTANCE.toObject(cycleKV.getValueArray(), cycleKV.getValueOffset(), cycleKV.getValueLength());
                            }
                            numSlotsToAllocate = this.calculateNumSlotsToAllocate(increment);
                            if (!cycle || SequenceUtil.isCycleAllowed(numSlotsToAllocate)) break block31;
                            var40_40 = SequenceRegionObserver.getErrorResult(row, maxTimestamp, SQLExceptionCode.NUM_SEQ_TO_ALLOCATE_NOT_SUPPORTED.getErrorCode());
                            region.releaseRowLocks((List)locks);
                            return var40_40;
                        }
                        if (!SequenceUtil.isBulkAllocation(numSlotsToAllocate) || !SequenceUtil.checkIfLimitReached(currentValue, minValue, maxValue, incrementBy, cacheSize, numSlotsToAllocate)) break block32;
                        var40_41 = SequenceRegionObserver.getErrorResult(row, maxTimestamp, SequenceUtil.getLimitReachedErrorCode(increasingSeq).getErrorCode());
                        region.releaseRowLocks((List)locks);
                        return var40_41;
                    }
                    if (!validateOnly) break block33;
                    var40_42 = result;
                    region.releaseRowLocks((List)locks);
                    return var40_42;
                }
                if (!limitReached) break block34;
                if (cycle) {
                    currentValue = increasingSeq != false ? minValue : maxValue;
                    break block34;
                }
                var40_43 = SequenceRegionObserver.getErrorResult(row, maxTimestamp, SequenceUtil.getLimitReachedErrorCode(increasingSeq).getErrorCode());
                region.releaseRowLocks((List)locks);
                return var40_43;
            }
            limitReached = SequenceUtil.checkIfLimitReached(currentValue, minValue, maxValue, incrementBy, cacheSize, numSlotsToAllocate);
            newCurrentValueKV = this.createKeyValue(row, PhoenixDatabaseMetaData.CURRENT_VALUE_BYTES, currentValue += incrementBy * (SequenceUtil.isBulkAllocation(numSlotsToAllocate) != false ? numSlotsToAllocate : cacheSize), timestamp);
            Sequence.replaceCurrentValueKV(cells, newCurrentValueKV);
            put.add((Cell)newCurrentValueKV);
            newLimitReachedKV = this.createKeyValue(row, PhoenixDatabaseMetaData.LIMIT_REACHED_FLAG_BYTES, limitReached, timestamp);
            put.add((Cell)newLimitReachedKV);
lbl139:
            // 2 sources

            mutations = new Mutation[]{put};
            region.batchMutate(mutations, 0L, 0L);
            var28_27 = Result.create(cells);
            region.releaseRowLocks((List)locks);
            return var28_27;
        }
        finally {
            region.closeRegionOperation();
        }
    }

    KeyValue createKeyValue(byte[] key, byte[] cqBytes, long value, long timestamp) {
        byte[] valueBuffer = new byte[PLong.INSTANCE.getByteSize().intValue()];
        PLong.INSTANCE.getCodec().encodeLong(value, valueBuffer, 0);
        return KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, cqBytes, timestamp, valueBuffer);
    }

    private KeyValue createKeyValue(byte[] key, byte[] cqBytes, boolean value, long timestamp) throws IOException {
        return KeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, cqBytes, timestamp, value ? PDataType.TRUE_BYTES : PDataType.FALSE_BYTES);
    }

    /*
     * Exception decompiling
     */
    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> e, Append append) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 11[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long calculateNumSlotsToAllocate(Increment increment) {
        long numToAllocate = 1L;
        byte[] numToAllocateBytes = increment.getAttribute(NUM_TO_ALLOCATE);
        if (numToAllocateBytes != null) {
            numToAllocate = Bytes.toLong((byte[])numToAllocateBytes);
        }
        return numToAllocate;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$phoenix$schema$Sequence$MetaOp;

        static {
            $SwitchMap$org$apache$phoenix$schema$Sequence$MetaOp = new int[Sequence.MetaOp.values().length];
            try {
                1.$SwitchMap$org$apache$phoenix$schema$Sequence$MetaOp[Sequence.MetaOp.RETURN_SEQUENCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$phoenix$schema$Sequence$MetaOp[Sequence.MetaOp.DROP_SEQUENCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$phoenix$schema$Sequence$MetaOp[Sequence.MetaOp.CREATE_SEQUENCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

