/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.exception;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.SchemaUtil;

public class DataExceedsCapacityException
extends IllegalDataException {
    private static final long serialVersionUID = 1L;

    public DataExceedsCapacityException(String message) {
        super(new SQLExceptionInfo.Builder(SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY).setMessage(message).build().buildException());
    }

    public DataExceedsCapacityException(PDataType type, Integer precision, Integer scale, String columnName, ImmutableBytesWritable value) {
        super(new SQLExceptionInfo.Builder(SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY).setMessage((columnName == null ? "" : columnName + " ") + DataExceedsCapacityException.getTypeDisplayString(type, precision, scale, value)).build().buildException());
    }

    public DataExceedsCapacityException(PDataType type, Integer precision, Integer scale) {
        this(type, precision, scale, null, null);
    }

    private static String getTypeDisplayString(PDataType type, Integer precision, Integer scale, ImmutableBytesWritable value) {
        return type.toString() + "(" + precision + (scale == null ? "" : "," + scale) + ")" + (value == null || value.getLength() == 0 ? "" : " value=" + SchemaUtil.toString(type, value));
    }
}

