/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.util.List;
import org.apache.phoenix.expression.ArithmeticExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;

public abstract class DivideExpression
extends ArithmeticExpression {
    private Integer maxLength;
    private Integer scale;

    public DivideExpression() {
    }

    public DivideExpression(List<Expression> children) {
        super(children);
        Expression firstChild = children.get(0);
        this.maxLength = this.getPrecision(firstChild);
        this.scale = this.getScale(firstChild);
        for (int i = 1; i < children.size(); ++i) {
            Expression childExpr = children.get(i);
            this.maxLength = DivideExpression.getPrecision(this.maxLength, this.getPrecision(childExpr), this.scale, this.getScale(childExpr));
            this.scale = DivideExpression.getScale(this.maxLength, this.getPrecision(childExpr), this.scale, this.getScale(childExpr));
        }
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    @Override
    public String getOperatorString() {
        return " / ";
    }

    private static Integer getPrecision(Integer lp, Integer rp, Integer ls, Integer rs) {
        if (ls == null || rs == null) {
            return 38;
        }
        int val = DivideExpression.getScale(lp, rp, ls, rs) + lp - ls + rp;
        return Math.min(38, val);
    }

    private static Integer getScale(Integer lp, Integer rp, Integer ls, Integer rs) {
        if (ls == null || rs == null) {
            return null;
        }
        int val = Math.max(38 - lp + ls - rs, 0);
        return Math.min(38, val);
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }
}

