/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.ArithmeticExpression;
import org.apache.phoenix.expression.DivideExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDouble;

public class DoubleDivideExpression
extends DivideExpression {
    public DoubleDivideExpression() {
    }

    public DoubleDivideExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        double result = 0.0;
        for (int i = 0; i < this.children.size(); ++i) {
            Expression child = (Expression)this.children.get(i);
            if (!child.evaluate(tuple, ptr)) {
                return false;
            }
            if (ptr.getLength() == 0) {
                return true;
            }
            double childvalue = child.getDataType().getCodec().decodeDouble(ptr, child.getSortOrder());
            if (!Double.isNaN(childvalue) && childvalue != Double.NEGATIVE_INFINITY && childvalue != Double.POSITIVE_INFINITY) {
                if (i == 0) {
                    result = childvalue;
                    continue;
                }
                result /= childvalue;
                continue;
            }
            return false;
        }
        byte[] resultPtr = new byte[this.getDataType().getByteSize().intValue()];
        this.getDataType().getCodec().encodeDouble(result, resultPtr, 0);
        ptr.set(resultPtr);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDouble.INSTANCE;
    }

    @Override
    public ArithmeticExpression clone(List<Expression> children) {
        return new DoubleDivideExpression(children);
    }
}

