/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.Determinism;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.SchemaUtil;

public class ProjectedColumnExpression
extends ColumnExpression {
    private KeyValueSchema schema;
    private ValueBitSet bitSet;
    private int position;
    private String displayName;
    private final Collection<PColumn> columns;
    private PColumn column;

    public ProjectedColumnExpression() {
        this.columns = Collections.emptyList();
    }

    public ProjectedColumnExpression(PColumn column, PTable table, String displayName) {
        this(column, table.getColumns(), column.getPosition() - table.getPKColumns().size(), displayName);
    }

    public ProjectedColumnExpression(PColumn column, Collection<PColumn> columns, int position, String displayName) {
        super(column);
        this.column = column;
        this.columns = columns;
        this.position = position;
        this.displayName = displayName;
    }

    public static KeyValueSchema buildSchema(Collection<PColumn> columns) {
        KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
        for (PColumn column : columns) {
            if (SchemaUtil.isPKColumn(column)) continue;
            builder.addField(column);
        }
        return builder.build();
    }

    public KeyValueSchema getSchema() {
        if (this.schema == null) {
            this.schema = ProjectedColumnExpression.buildSchema(this.columns);
            this.bitSet = ValueBitSet.newInstance(this.schema);
        }
        return this.schema;
    }

    public int getPosition() {
        return this.position;
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.position;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectedColumnExpression other = (ProjectedColumnExpression)obj;
        return this.position == other.position;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        try {
            KeyValueSchema schema = this.getSchema();
            TupleProjector.decodeProjectedValue(tuple, ptr);
            this.bitSet.clear();
            this.bitSet.or(ptr);
            int maxOffset = ptr.getOffset() + ptr.getLength() - this.bitSet.getEstimatedLength();
            schema.iterator(ptr, this.position, this.bitSet);
            Boolean hasValue = schema.next(ptr, this.position, maxOffset, this.bitSet);
            if (hasValue == null || !hasValue.booleanValue()) {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.schema = new KeyValueSchema();
        this.schema.readFields(input);
        this.bitSet = ValueBitSet.newInstance(this.schema);
        this.position = input.readInt();
        this.displayName = input.readUTF();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        this.getSchema().write(output);
        output.writeInt(this.position);
        output.writeUTF(this.displayName);
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public PColumn getColumn() {
        return this.column;
    }

    @Override
    public Determinism getDeterminism() {
        return Determinism.PER_INVOCATION;
    }

    public ProjectedColumnExpression clone() {
        return new ProjectedColumnExpression(this.column, this.columns, this.position, this.displayName);
    }
}

