/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.aggregator.DistinctValueWithCountClientAggregator;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;

public abstract class BaseStddevAggregator
extends DistinctValueWithCountClientAggregator {
    protected Expression stdDevColExp;

    public BaseStddevAggregator(List<Expression> exps, SortOrder sortOrder) {
        super(sortOrder);
        this.stdDevColExp = exps.get(0);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.cachedResult == null) {
            double ssd = this.sumSquaredDeviation();
            double result = Math.sqrt(ssd / (double)this.getDataPointsCount());
            this.cachedResult = new BigDecimal(result);
        }
        if (this.buffer == null) {
            this.initBuffer();
        }
        this.buffer = PDecimal.INSTANCE.toBytes(this.cachedResult);
        ptr.set(this.buffer);
        return true;
    }

    protected abstract long getDataPointsCount();

    private double sumSquaredDeviation() {
        double m = this.mean();
        double result = 0.0;
        for (Map.Entry entry : this.valueVsCount.entrySet()) {
            double colValue = (Double)PDouble.INSTANCE.toObject((ImmutableBytesWritable)entry.getKey(), this.stdDevColExp.getDataType());
            double delta = colValue - m;
            result += delta * delta * (double)((Integer)entry.getValue()).intValue();
        }
        return result;
    }

    private double mean() {
        double sum = 0.0;
        for (Map.Entry entry : this.valueVsCount.entrySet()) {
            double colValue = (Double)PDouble.INSTANCE.toObject((ImmutableBytesWritable)entry.getKey(), this.stdDevColExp.getDataType());
            sum += colValue * (double)((Integer)entry.getValue()).intValue();
        }
        return sum / (double)this.totalCount;
    }

    @Override
    protected PDataType getResultDataType() {
        return PDecimal.INSTANCE;
    }
}

