/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ArrayModifierFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PBinaryArray;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinaryArray;

@FunctionParseNode.BuiltInFunction(name="ARRAY_CAT", args={@FunctionParseNode.Argument(allowedTypes={PBinaryArray.class, PVarbinaryArray.class}), @FunctionParseNode.Argument(allowedTypes={PBinaryArray.class, PVarbinaryArray.class})})
public class ArrayConcatFunction
extends ArrayModifierFunction {
    public static final String NAME = "ARRAY_CAT";

    public ArrayConcatFunction() {
    }

    public ArrayConcatFunction(List<Expression> children) throws TypeMismatchException {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!this.getLHSExpr().evaluate(tuple, ptr)) {
            return false;
        }
        boolean isLHSRowKeyOrderOptimized = PArrayDataType.isRowKeyOrderOptimized(this.getLHSExpr().getDataType(), this.getLHSExpr().getSortOrder(), ptr);
        SortOrder sortOrder = this.getRHSExpr().getSortOrder();
        int actualLengthOfArray1 = Math.abs(PArrayDataType.getArrayLength(ptr, this.getLHSBaseType(), this.getLHSExpr().getMaxLength()));
        int lengthArray1 = ptr.getLength();
        int offsetArray1 = ptr.getOffset();
        byte[] array1Bytes = ptr.get();
        if (!this.getRHSExpr().evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            ptr.set(array1Bytes, offsetArray1, lengthArray1);
            return true;
        }
        this.checkSizeCompatibility(ptr, sortOrder, this.getLHSExpr(), this.getLHSExpr().getDataType(), this.getRHSExpr(), this.getRHSExpr().getDataType());
        this.getLHSExpr().getDataType().coerceBytes(ptr, null, this.getRHSExpr().getDataType(), this.getRHSExpr().getMaxLength(), this.getRHSExpr().getScale(), this.getRHSExpr().getSortOrder(), this.getLHSExpr().getMaxLength(), this.getLHSExpr().getScale(), this.getLHSExpr().getSortOrder(), isLHSRowKeyOrderOptimized);
        if (lengthArray1 == 0) {
            return true;
        }
        return this.modifierFunction(ptr, lengthArray1, offsetArray1, array1Bytes, this.getLHSBaseType(), actualLengthOfArray1, this.getMaxLength(), this.getLHSExpr());
    }

    @Override
    protected boolean modifierFunction(ImmutableBytesWritable ptr, int len, int offset, byte[] array1Bytes, PDataType baseDataType, int actualLengthOfArray1, Integer maxLength, Expression array1Exp) {
        int actualLengthOfArray2 = Math.abs(PArrayDataType.getArrayLength(ptr, baseDataType, array1Exp.getMaxLength()));
        return PArrayDataType.concatArrays(ptr, len, offset, array1Bytes, baseDataType, actualLengthOfArray1, actualLengthOfArray2);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

