/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ArrayModifierFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PBinaryArray;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarbinaryArray;

@FunctionParseNode.BuiltInFunction(name="ARRAY_PREPEND", args={@FunctionParseNode.Argument(allowedTypes={PVarbinary.class}), @FunctionParseNode.Argument(allowedTypes={PBinaryArray.class, PVarbinaryArray.class})})
public class ArrayPrependFunction
extends ArrayModifierFunction {
    public static final String NAME = "ARRAY_PREPEND";

    public ArrayPrependFunction() {
    }

    public ArrayPrependFunction(List<Expression> children) throws TypeMismatchException {
        super(children);
    }

    @Override
    protected boolean modifierFunction(ImmutableBytesWritable ptr, int len, int offset, byte[] arrayBytes, PDataType baseDataType, int arrayLength, Integer maxLength, Expression arrayExp) {
        return PArrayDataType.prependItemToArray(ptr, len, offset, arrayBytes, baseDataType, arrayLength, this.getMaxLength(), arrayExp.getSortOrder());
    }

    @Override
    public String getName() {
        return NAME;
    }
}

