/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.cache.JodaTimezoneCache;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PVarchar;
import org.joda.time.DateTimeZone;

@FunctionParseNode.BuiltInFunction(name="CONVERT_TZ", args={@FunctionParseNode.Argument(allowedTypes={PTimestamp.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class})})
public class ConvertTimezoneFunction
extends ScalarFunction {
    public static final String NAME = "CONVERT_TZ";

    public ConvertTimezoneFunction() {
    }

    public ConvertTimezoneFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!((Expression)this.children.get(0)).evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        long date = PDate.INSTANCE.getCodec().decodeLong(ptr, ((Expression)this.children.get(0)).getSortOrder());
        if (!((Expression)this.children.get(1)).evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        DateTimeZone timezoneFrom = JodaTimezoneCache.getInstance(ptr);
        if (!((Expression)this.children.get(2)).evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        DateTimeZone timezoneTo = JodaTimezoneCache.getInstance(ptr);
        long convertedDate = date - (long)timezoneFrom.getOffset(date) + (long)timezoneTo.getOffset(date);
        byte[] outBytes = new byte[8];
        PDate.INSTANCE.getCodec().encodeLong(convertedDate, outBytes, 0);
        ptr.set(outBytes);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDate.INSTANCE;
    }
}

