/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.DateScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PTimestamp;
import org.joda.time.DateTime;

@FunctionParseNode.BuiltInFunction(name="DAYOFYEAR", args={@FunctionParseNode.Argument(allowedTypes={PTimestamp.class})})
public class DayOfYearFunction
extends DateScalarFunction {
    public static final String NAME = "DAYOFYEAR";

    public DayOfYearFunction() {
    }

    public DayOfYearFunction(List<Expression> children) {
        super(children);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression arg = this.getChildren().get(0);
        if (!arg.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        long dateTime = this.inputCodec.decodeLong(ptr, arg.getSortOrder());
        DateTime jodaDT = new DateTime(dateTime);
        int day = jodaDT.getDayOfYear();
        PDataType returnDataType = this.getDataType();
        byte[] byteValue = new byte[returnDataType.getByteSize().intValue()];
        returnDataType.getCodec().encodeInt(day, byteValue, 0);
        ptr.set(byteValue);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PInteger.INSTANCE;
    }
}

