/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;

@FunctionParseNode.BuiltInFunction(name="INSTR", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class})})
public class InstrFunction
extends ScalarFunction {
    public static final String NAME = "INSTR";
    private String strToSearch = null;

    public InstrFunction() {
    }

    public InstrFunction(List<Expression> children) {
        super(children);
        this.init();
    }

    private void init() {
        Object strToSearchValue;
        Expression strToSearchExpression = this.getChildren().get(1);
        if (strToSearchExpression instanceof LiteralExpression && (strToSearchValue = ((LiteralExpression)strToSearchExpression).getValue()) != null) {
            this.strToSearch = strToSearchValue.toString();
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression child = this.getChildren().get(0);
        if (!child.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        if (this.strToSearch == null) {
            int position = 0;
            ptr.set(PInteger.INSTANCE.toBytes(position));
            return true;
        }
        String sourceStr = (String)PVarchar.INSTANCE.toObject(ptr, this.getChildren().get(0).getSortOrder());
        int position = sourceStr.indexOf(this.strToSearch) + 1;
        ptr.set(PInteger.INSTANCE.toBytes(position));
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PInteger.INSTANCE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.init();
    }
}

