/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.schema.types.PVarcharArray;

@FunctionParseNode.BuiltInFunction(name="STRING_TO_ARRAY", args={@FunctionParseNode.Argument(allowedTypes={PVarchar.class, PChar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class, PChar.class}), @FunctionParseNode.Argument(allowedTypes={PVarchar.class, PChar.class}, defaultValue="null")})
public class StringToArrayFunction
extends ScalarFunction {
    public static final String NAME = "STRING_TO_ARRAY";

    public StringToArrayFunction() {
    }

    public StringToArrayFunction(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression delimiterExpr = (Expression)this.children.get(1);
        if (!delimiterExpr.evaluate(tuple, ptr)) {
            return false;
        }
        String delimiter = ptr.getLength() == 0 ? "" : (String)delimiterExpr.getDataType().toObject(ptr, delimiterExpr.getSortOrder(), delimiterExpr.getMaxLength(), delimiterExpr.getScale());
        Expression stringExpr = (Expression)this.children.get(0);
        if (!stringExpr.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        String string = (String)stringExpr.getDataType().toObject(ptr, stringExpr.getSortOrder(), stringExpr.getMaxLength(), stringExpr.getScale());
        Expression nullExpr = (Expression)this.children.get(2);
        String nullString = null;
        if (nullExpr.evaluate(tuple, ptr) && ptr.getLength() != 0) {
            nullString = (String)nullExpr.getDataType().toObject(ptr, nullExpr.getSortOrder(), nullExpr.getMaxLength(), nullExpr.getScale());
        }
        return PArrayDataType.stringToArray(ptr, string, delimiter, nullString, this.getSortOrder());
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Integer getMaxLength() {
        return null;
    }

    @Override
    public PDataType getDataType() {
        return PVarcharArray.INSTANCE;
    }

    @Override
    public SortOrder getSortOrder() {
        return ((Expression)this.children.get(0)).getSortOrder();
    }
}

