/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.util.regex;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.util.regex.AbstractBasePattern;
import org.apache.phoenix.expression.util.regex.AbstractBaseSplitter;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataTypeEncoder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.StringUtil;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Syntax;

public class JONIPattern
extends AbstractBasePattern
implements AbstractBaseSplitter {
    private final Regex pattern;
    private final String patternString;

    public JONIPattern(String patternString) {
        this(patternString, 0);
    }

    public JONIPattern(String patternString, int flags) {
        this(patternString, flags, (Encoding)UTF8Encoding.INSTANCE);
    }

    public JONIPattern(String patternString, int flags, Encoding coding) {
        this.patternString = patternString;
        if (patternString != null) {
            byte[] bytes = patternString.getBytes();
            this.pattern = new Regex(bytes, 0, bytes.length, flags, coding, Syntax.Java);
        } else {
            this.pattern = null;
        }
    }

    @Override
    public void matches(ImmutableBytesWritable srcPtr) {
        Preconditions.checkNotNull((Object)srcPtr);
        boolean ret = this.matches(srcPtr.get(), srcPtr.getOffset(), srcPtr.getLength());
        srcPtr.set(ret ? PDataType.TRUE_BYTES : PDataType.FALSE_BYTES);
    }

    private boolean matches(byte[] bytes, int offset, int len) {
        int range = offset + len;
        Matcher matcher = this.pattern.matcher(bytes, offset, range);
        int ret = matcher.match(offset, range, 0);
        return len == ret;
    }

    @Override
    public String pattern() {
        return this.patternString;
    }

    @Override
    public void replaceAll(ImmutableBytesWritable srcPtr, byte[] rStrBytes, int rStrOffset, int rStrLen) {
        Preconditions.checkNotNull((Object)srcPtr);
        Preconditions.checkNotNull((Object)rStrBytes);
        byte[] replacedBytes = this.replaceAll(srcPtr.get(), srcPtr.getOffset(), srcPtr.getLength(), rStrBytes, rStrOffset, rStrLen);
        srcPtr.set(replacedBytes);
    }

    private byte[] replaceAll(byte[] srcBytes, int srcOffset, int srcLen, byte[] replaceBytes, int replaceOffset, int replaceLen) {
        int nextCur;
        int srcRange = srcOffset + srcLen;
        Matcher matcher = this.pattern.matcher(srcBytes, 0, srcRange);
        int cur = srcOffset;
        class PairInt {
            public int begin;
            public int end;

            public PairInt(int begin, int end) {
                this.begin = begin;
                this.end = end;
            }
        }
        LinkedList<PairInt> searchResults = new LinkedList<PairInt>();
        int totalBytesNeeded = 0;
        while ((nextCur = matcher.search(cur, srcRange, 0)) >= 0) {
            searchResults.add(new PairInt(matcher.getBegin(), matcher.getEnd()));
            totalBytesNeeded += nextCur - cur + replaceLen;
            cur = matcher.getEnd();
        }
        byte[] ret = new byte[totalBytesNeeded += srcRange - cur];
        int curPosInSrc = srcOffset;
        int curPosInRet = 0;
        for (PairInt pair : searchResults) {
            System.arraycopy(srcBytes, curPosInSrc, ret, curPosInRet, pair.begin - curPosInSrc);
            System.arraycopy(replaceBytes, replaceOffset, ret, curPosInRet += pair.begin - curPosInSrc, replaceLen);
            curPosInRet += replaceLen;
            curPosInSrc = pair.end;
        }
        System.arraycopy(srcBytes, curPosInSrc, ret, curPosInRet, srcRange - curPosInSrc);
        return ret;
    }

    @Override
    public void substr(ImmutableBytesWritable ptr, int offsetInStr) {
        Preconditions.checkNotNull((Object)ptr);
        int offsetInBytes = StringUtil.calculateUTF8Offset(ptr.get(), ptr.getOffset(), ptr.getLength(), SortOrder.ASC, offsetInStr);
        if (offsetInBytes < 0) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
        } else {
            this.substr(ptr.get(), offsetInBytes, ptr.getOffset() + ptr.getLength(), ptr);
        }
    }

    private boolean substr(byte[] srcBytes, int offset, int range, ImmutableBytesWritable outPtr) {
        boolean ret;
        Matcher matcher = this.pattern.matcher(srcBytes, 0, range);
        boolean bl = ret = matcher.search(offset, range, 0) >= 0;
        if (ret) {
            int len = matcher.getEnd() - matcher.getBegin();
            outPtr.set(srcBytes, matcher.getBegin(), len);
        } else {
            outPtr.set(ByteUtil.EMPTY_BYTE_ARRAY);
        }
        return ret;
    }

    @Override
    public boolean split(ImmutableBytesWritable srcPtr) {
        return this.split(srcPtr.get(), srcPtr.getOffset(), srcPtr.getLength(), srcPtr);
    }

    private boolean split(byte[] srcBytes, int srcOffset, int srcLen, ImmutableBytesWritable outPtr) {
        PArrayDataTypeEncoder builder;
        block4: {
            SortOrder sortOrder = SortOrder.ASC;
            builder = new PArrayDataTypeEncoder(PVarchar.INSTANCE, sortOrder);
            int srcRange = srcOffset + srcLen;
            Matcher matcher = this.pattern.matcher(srcBytes, 0, srcRange);
            int cur = srcOffset;
            do {
                int nextCur;
                if ((nextCur = matcher.search(cur, srcRange, 0)) < 0) {
                    builder.appendValue(srcBytes, cur, srcRange - cur);
                    break block4;
                }
                if (cur == matcher.getBegin()) {
                    builder.appendValue(srcBytes, cur, 0);
                }
                if (cur >= matcher.getBegin()) continue;
                builder.appendValue(srcBytes, cur, matcher.getBegin() - cur);
            } while ((cur = matcher.getEnd()) != srcRange);
            builder.appendValue(srcBytes, cur, 0);
        }
        byte[] bytes = builder.encode();
        if (bytes == null) {
            return false;
        }
        outPtr.set(bytes);
        return true;
    }
}

