/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index;

import java.util.List;
import org.apache.hadoop.hbase.regionserver.IncreasingToUpperBoundRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;

public class IndexRegionSplitPolicy
extends IncreasingToUpperBoundRegionSplitPolicy {
    protected boolean skipStoreFileRangeCheck(String familyName) {
        return familyName.startsWith("L#");
    }

    protected byte[] getSplitPoint() {
        byte[] splitPoint;
        byte[] oldSplitPoint = super.getSplitPoint();
        if (oldSplitPoint == null) {
            return null;
        }
        List stores = this.region.getStores();
        byte[] splitPointFromLargestStore = null;
        long largestStoreSize = 0L;
        boolean isLocalIndexKey = false;
        for (Store s : stores) {
            if (!s.getFamily().getNameAsString().startsWith("L#")) continue;
            splitPoint = s.getSplitPoint();
            if (oldSplitPoint == null || splitPoint == null || Bytes.compareTo((byte[])oldSplitPoint, (byte[])splitPoint) != 0) continue;
            isLocalIndexKey = true;
        }
        if (!isLocalIndexKey) {
            return oldSplitPoint;
        }
        for (Store s : stores) {
            if (s.getFamily().getNameAsString().startsWith("L#")) continue;
            splitPoint = s.getSplitPoint();
            long storeSize = s.getSize();
            if (splitPoint == null || largestStoreSize >= storeSize) continue;
            splitPointFromLargestStore = splitPoint;
            largestStoreSize = storeSize;
        }
        return splitPointFromLargestStore;
    }
}

