/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.CoveredColumns;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.covered.IndexUpdate;
import org.apache.phoenix.hbase.index.covered.KeyValueStore;
import org.apache.phoenix.hbase.index.covered.TableState;
import org.apache.phoenix.hbase.index.covered.data.IndexMemStore;
import org.apache.phoenix.hbase.index.covered.data.LocalHBaseState;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.covered.update.ColumnTracker;
import org.apache.phoenix.hbase.index.covered.update.IndexedColumnGroup;
import org.apache.phoenix.hbase.index.scanner.ScannerBuilder;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;

public class LocalTableState
implements TableState {
    private long ts;
    private RegionCoprocessorEnvironment env;
    private KeyValueStore memstore;
    private LocalHBaseState table;
    private Mutation update;
    private Set<ColumnTracker> trackedColumns = new HashSet<ColumnTracker>();
    private ScannerBuilder scannerBuilder;
    private List<KeyValue> kvs = new ArrayList<KeyValue>();
    private List<? extends IndexedColumnGroup> hints;
    private CoveredColumns columnSet;

    public LocalTableState(RegionCoprocessorEnvironment environment, LocalHBaseState table, Mutation update) {
        this.env = environment;
        this.table = table;
        this.update = update;
        this.memstore = new IndexMemStore();
        this.scannerBuilder = new ScannerBuilder(this.memstore, update);
        this.columnSet = new CoveredColumns();
    }

    public void addPendingUpdates(KeyValue ... kvs) {
        if (kvs == null) {
            return;
        }
        this.addPendingUpdates(Arrays.asList(kvs));
    }

    public void addPendingUpdates(List<KeyValue> kvs) {
        if (kvs == null) {
            return;
        }
        this.setPendingUpdates(kvs);
        this.addUpdate(kvs);
    }

    private void addUpdate(List<KeyValue> list) {
        this.addUpdate(list, true);
    }

    private void addUpdate(List<KeyValue> list, boolean overwrite) {
        if (list == null) {
            return;
        }
        for (KeyValue kv : list) {
            this.memstore.add(kv, overwrite);
        }
    }

    private void addUpdateCells(List<Cell> list, boolean overwrite) {
        if (list == null) {
            return;
        }
        for (Cell c : list) {
            this.memstore.add(this.maybeCopyCell(c), overwrite);
        }
    }

    private KeyValue maybeCopyCell(Cell c) {
        if (c == null) {
            return null;
        }
        if (c instanceof KeyValue) {
            return (KeyValue)c;
        }
        return KeyValueUtil.copyToNewKeyValue((Cell)c);
    }

    @Override
    public RegionCoprocessorEnvironment getEnvironment() {
        return this.env;
    }

    @Override
    public long getCurrentTimestamp() {
        return this.ts;
    }

    public void setCurrentTimestamp(long timestamp) {
        this.ts = timestamp;
    }

    public void resetTrackedColumns() {
        this.trackedColumns.clear();
    }

    public Set<ColumnTracker> getTrackedColumns() {
        return this.trackedColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<ScannerBuilder.CoveredDeleteScanner, IndexUpdate> getIndexedColumnsTableState(Collection<? extends ColumnReference> indexedColumns, boolean ignoreNewerMutations, boolean returnNullScannerIfRowNotFound, IndexMetaData indexMetaData) throws IOException {
        this.ensureLocalStateInitialized(indexedColumns, ignoreNewerMutations, indexMetaData);
        ColumnTracker tracker = new ColumnTracker(indexedColumns);
        Set<ColumnTracker> set = this.trackedColumns;
        synchronized (set) {
            if (!this.trackedColumns.contains(tracker)) {
                this.trackedColumns.add(tracker);
            }
        }
        ScannerBuilder.CoveredDeleteScanner scanner = this.scannerBuilder.buildIndexedColumnScanner(indexedColumns, tracker, this.ts, returnNullScannerIfRowNotFound);
        return new Pair((Object)scanner, (Object)new IndexUpdate(tracker));
    }

    private synchronized void ensureLocalStateInitialized(Collection<? extends ColumnReference> columns, boolean ignoreNewerMutations, IndexMetaData indexMetaData) throws IOException {
        Collection<? extends ColumnReference> toCover = this.columnSet.findNonCoveredColumns(columns);
        if (toCover.isEmpty()) {
            return;
        }
        if (!indexMetaData.isImmutableRows()) {
            this.addUpdateCells(this.table.getCurrentRowState(this.update, toCover, ignoreNewerMutations).listCells(), false);
        }
        for (ColumnReference columnReference : toCover) {
            this.columnSet.addColumn(columnReference);
        }
    }

    @Override
    public Map<String, byte[]> getUpdateAttributes() {
        return this.update.getAttributesMap();
    }

    @Override
    public byte[] getCurrentRowKey() {
        return this.update.getRow();
    }

    public void setHints(List<? extends IndexedColumnGroup> hints) {
        this.hints = hints;
    }

    @Override
    public List<? extends IndexedColumnGroup> getIndexColumnHints() {
        return this.hints;
    }

    @Override
    public Collection<KeyValue> getPendingUpdate() {
        return this.kvs;
    }

    public void setPendingUpdates(Collection<KeyValue> update) {
        this.kvs.clear();
        this.kvs.addAll(update);
    }

    public void applyPendingUpdates() {
        this.addUpdate(this.kvs);
    }

    public void rollback(Collection<KeyValue> values) {
        for (KeyValue kv : values) {
            this.memstore.rollback(kv);
        }
    }

    @Override
    public Pair<ValueGetter, IndexUpdate> getIndexUpdateState(Collection<? extends ColumnReference> indexedColumns, boolean ignoreNewerMutations, boolean returnNullScannerIfRowNotFound, IndexMetaData indexMetaData) throws IOException {
        Pair<ScannerBuilder.CoveredDeleteScanner, IndexUpdate> pair = this.getIndexedColumnsTableState(indexedColumns, ignoreNewerMutations, returnNullScannerIfRowNotFound, indexMetaData);
        ValueGetter valueGetter = IndexManagementUtil.createGetterFromScanner((ScannerBuilder.CoveredDeleteScanner)pair.getFirst(), this.getCurrentRowKey());
        return new Pair((Object)valueGetter, pair.getSecond());
    }
}

