/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class ApplyAndFilterDeletesFilter
extends FilterBase {
    private boolean done = false;
    List<ImmutableBytesPtr> families;
    private final DeleteTracker coveringDelete = new DeleteTracker();
    private Hinter currentHint;
    private DeleteColumnHinter columnHint = new DeleteColumnHinter();
    private DeleteFamilyHinter familyHint = new DeleteFamilyHinter();

    public ApplyAndFilterDeletesFilter(Set<ImmutableBytesPtr> families) {
        this.families = new ArrayList<ImmutableBytesPtr>(families);
        Collections.sort(this.families);
    }

    public DeleteTracker getDeleteTracker() {
        return this.coveringDelete;
    }

    private ImmutableBytesPtr getNextFamily(ImmutableBytesPtr family) {
        int index = Collections.binarySearch(this.families, family);
        index = index < 0 ? -index - 1 : ++index;
        if (index >= this.families.size()) {
            return null;
        }
        return this.families.get(index);
    }

    public void reset() {
        this.coveringDelete.reset();
        this.done = false;
    }

    public Cell getNextCellHint(Cell peeked) {
        return this.currentHint.getHint(KeyValueUtil.ensureKeyValue((Cell)peeked));
    }

    public Filter.ReturnCode filterKeyValue(Cell next) {
        if (this.done) {
            return Filter.ReturnCode.SKIP;
        }
        KeyValue nextKV = KeyValueUtil.ensureKeyValue((Cell)next);
        switch (KeyValue.Type.codeToType((byte)next.getTypeByte())) {
            case DeleteFamily: {
                this.coveringDelete.reset();
                this.coveringDelete.deleteFamily = nextKV;
                return Filter.ReturnCode.SKIP;
            }
            case DeleteColumn: {
                this.coveringDelete.pointDelete = null;
                this.coveringDelete.deleteColumn = nextKV;
                return Filter.ReturnCode.SKIP;
            }
            case Delete: {
                this.coveringDelete.pointDelete = nextKV;
                return Filter.ReturnCode.SKIP;
            }
        }
        if (this.coveringDelete.empty()) {
            return Filter.ReturnCode.INCLUDE;
        }
        if (this.coveringDelete.matchesFamily(nextKV)) {
            this.currentHint = this.familyHint;
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        if (this.coveringDelete.matchesColumn(nextKV)) {
            this.currentHint = this.columnHint;
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        if (this.coveringDelete.matchesPoint(nextKV)) {
            return Filter.ReturnCode.SKIP;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    public static class DeleteTracker {
        public KeyValue deleteFamily;
        public KeyValue deleteColumn;
        public KeyValue pointDelete;

        public void reset() {
            this.deleteFamily = null;
            this.deleteColumn = null;
            this.pointDelete = null;
        }

        public boolean matchesFamily(KeyValue next) {
            if (this.deleteFamily == null) {
                return false;
            }
            if (CellUtil.matchingFamily((Cell)this.deleteFamily, (Cell)next)) {
                if (this.deleteFamily.getTimestamp() >= next.getTimestamp()) {
                    return true;
                }
            } else {
                this.deleteFamily = null;
            }
            return false;
        }

        public boolean matchesColumn(KeyValue next) {
            if (this.deleteColumn == null) {
                return false;
            }
            if (CellUtil.matchingFamily((Cell)this.deleteColumn, (Cell)next) && CellUtil.matchingQualifier((Cell)this.deleteColumn, (Cell)next)) {
                if (this.deleteColumn.getTimestamp() >= next.getTimestamp()) {
                    return true;
                }
            } else {
                this.deleteColumn = null;
            }
            return false;
        }

        public boolean matchesPoint(KeyValue next) {
            if (this.pointDelete != null && CellUtil.matchingFamily((Cell)this.pointDelete, (Cell)next) && CellUtil.matchingQualifier((Cell)this.pointDelete, (Cell)next)) {
                if (this.pointDelete.getTimestamp() == next.getTimestamp()) {
                    return true;
                }
                this.pointDelete = null;
            }
            return false;
        }

        public boolean empty() {
            return this.deleteFamily == null && this.deleteColumn == null && this.pointDelete == null;
        }
    }

    class DeleteColumnHinter
    implements Hinter {
        DeleteColumnHinter() {
        }

        @Override
        public KeyValue getHint(KeyValue kv) {
            return KeyValueUtil.createLastOnRow((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])kv.getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength(), (byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength());
        }
    }

    class DeleteFamilyHinter
    implements Hinter {
        DeleteFamilyHinter() {
        }

        @Override
        public KeyValue getHint(KeyValue peeked) {
            ImmutableBytesPtr nextFamily = ApplyAndFilterDeletesFilter.this.getNextFamily(new ImmutableBytesPtr(peeked.getBuffer(), peeked.getFamilyOffset(), peeked.getFamilyLength()));
            if (nextFamily == null) {
                ApplyAndFilterDeletesFilter.this.done = true;
                return KeyValue.LOWESTKEY;
            }
            return KeyValue.createFirstOnRow((byte[])peeked.getRow(), (byte[])nextFamily.copyBytesIfNecessary(), (byte[])HConstants.EMPTY_BYTE_ARRAY);
        }
    }

    static interface Hinter {
        public KeyValue getHint(KeyValue var1);
    }
}

