/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.scanner;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.phoenix.hbase.index.covered.KeyValueStore;
import org.apache.phoenix.hbase.index.scanner.ReseekableScanner;

public class FilteredKeyValueScanner
implements ReseekableScanner {
    private ReseekableScanner delegate;
    private Filter filter;

    public FilteredKeyValueScanner(Filter filter, KeyValueStore store) {
        this(filter, store.getScanner());
    }

    private FilteredKeyValueScanner(Filter filter, ReseekableScanner delegate) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public Cell peek() throws IOException {
        return this.delegate.peek();
    }

    @Override
    public Cell next() throws IOException {
        this.seekToNextUnfilteredKeyValue();
        return this.delegate.next();
    }

    @Override
    public boolean seek(Cell key) throws IOException {
        if (this.filter.filterAllRemaining()) {
            return false;
        }
        if (!this.delegate.seek(key)) {
            return false;
        }
        return this.seekToNextUnfilteredKeyValue();
    }

    private boolean seekToNextUnfilteredKeyValue() throws IOException {
        Cell peeked;
        while ((peeked = this.delegate.peek()) != null) {
            Filter.ReturnCode code = this.filter.filterKeyValue(peeked);
            switch (code) {
                case INCLUDE: 
                case INCLUDE_AND_NEXT_COL: {
                    return true;
                }
                case SKIP: 
                case NEXT_COL: 
                case NEXT_ROW: {
                    this.delegate.next();
                    break;
                }
                case SEEK_NEXT_USING_HINT: {
                    this.delegate.seek((Cell)KeyValueUtil.ensureKeyValue((Cell)this.filter.getNextCellHint(peeked)));
                }
            }
        }
        return false;
    }

    @Override
    public boolean reseek(Cell key) throws IOException {
        this.delegate.reseek(key);
        return this.seekToNextUnfilteredKeyValue();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

