/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class IndexedKeyValue
extends KeyValue {
    public static final byte[] COLUMN_QUALIFIER = Bytes.toBytes((String)"INDEXEDKEYVALUE_FAKED_COLUMN");
    private ImmutableBytesPtr indexTableName;
    private Mutation mutation;
    private boolean batchFinished = false;
    private int hashCode;

    private static int calcHashCode(ImmutableBytesPtr indexTableName, Mutation mutation) {
        int prime = 31;
        int result = 1;
        result = 31 * result + indexTableName.hashCode();
        result = 31 * result + Arrays.hashCode(mutation.getRow());
        return result;
    }

    public IndexedKeyValue() {
    }

    public IndexedKeyValue(byte[] bs, Mutation mutation) {
        this.indexTableName = new ImmutableBytesPtr(bs);
        this.mutation = mutation;
        this.hashCode = IndexedKeyValue.calcHashCode(this.indexTableName, mutation);
    }

    public byte[] getIndexTable() {
        return this.indexTableName.get();
    }

    public Mutation getMutation() {
        return this.mutation;
    }

    public byte[] getFamily() {
        return WALEdit.METAFAMILY;
    }

    public byte[] getFamilyArray() {
        return WALEdit.METAFAMILY;
    }

    public int getFamilyOffset() {
        return 0;
    }

    public byte getFamilyLength() {
        return (byte)WALEdit.METAFAMILY.length;
    }

    public byte[] getQualifierArray() {
        return COLUMN_QUALIFIER;
    }

    public int getQualifierOffset() {
        return 0;
    }

    public int getQualifierLength() {
        return COLUMN_QUALIFIER.length;
    }

    public String toString() {
        return "IndexWrite:\n\ttable: " + (Object)((Object)this.indexTableName) + "\n\tmutation:" + this.mutation;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        IndexedKeyValue other = (IndexedKeyValue)((Object)obj);
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (!other.indexTableName.equals((Object)this.indexTableName)) {
            return false;
        }
        byte[] current = this.getMutationBytes();
        byte[] otherMutation = other.getMutationBytes();
        return Bytes.equals((byte[])current, (byte[])otherMutation);
    }

    private byte[] getMutationBytes() {
        try {
            ClientProtos.MutationProto m = this.toMutationProto(this.mutation);
            return m.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to get bytes for mutation!", e);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    void writeData(DataOutput out) throws IOException {
        Bytes.writeByteArray((DataOutput)out, (byte[])this.indexTableName.get());
        ClientProtos.MutationProto m = this.toMutationProto(this.mutation);
        Bytes.writeByteArray((DataOutput)out, (byte[])m.toByteArray());
    }

    public void readFields(DataInput in) throws IOException {
        this.indexTableName = new ImmutableBytesPtr(Bytes.readByteArray((DataInput)in));
        byte[] mutationData = Bytes.readByteArray((DataInput)in);
        ClientProtos.MutationProto mProto = ClientProtos.MutationProto.parseFrom((byte[])mutationData);
        this.mutation = ProtobufUtil.toMutation((ClientProtos.MutationProto)mProto);
        this.hashCode = IndexedKeyValue.calcHashCode(this.indexTableName, this.mutation);
    }

    public boolean getBatchFinished() {
        return this.batchFinished;
    }

    public void markBatchFinished() {
        this.batchFinished = true;
    }

    protected ClientProtos.MutationProto toMutationProto(Mutation mutation) throws IOException {
        ClientProtos.MutationProto m = null;
        if (mutation instanceof Put) {
            m = ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)mutation);
        } else if (mutation instanceof Delete) {
            m = ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.DELETE, (Mutation)mutation);
        } else {
            throw new IOException("Put/Delete mutations only supported");
        }
        return m;
    }
}

