/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.phoenix.hbase.index.wal.IndexedKeyValue;

public class KeyValueCodec {
    public static final int INDEX_TYPE_LENGTH_MARKER = -1;

    public static List<KeyValue> readKeyValues(DataInput in) throws IOException {
        int size = in.readInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(size);
        for (int i = 0; i < size; ++i) {
            kvs.add(KeyValueCodec.readKeyValue(in));
        }
        return kvs;
    }

    public static KeyValue readKeyValue(DataInput in) throws IOException {
        int length = in.readInt();
        if (length == -1) {
            IndexedKeyValue kv = new IndexedKeyValue();
            kv.readFields(in);
            return kv;
        }
        return KeyValue.create((int)length, (DataInput)in);
    }

    public static void write(DataOutput out, KeyValue kv) throws IOException {
        if (kv instanceof IndexedKeyValue) {
            out.writeInt(-1);
            ((IndexedKeyValue)kv).writeData(out);
        } else {
            KeyValue.write((KeyValue)kv, (DataOutput)out);
        }
    }
}

