/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.hbase.index.exception.SingleIndexWriteFailureException;
import org.apache.phoenix.hbase.index.parallel.EarlyExitFailure;
import org.apache.phoenix.hbase.index.parallel.QuickFailingTaskRunner;
import org.apache.phoenix.hbase.index.parallel.Task;
import org.apache.phoenix.hbase.index.parallel.TaskBatch;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolBuilder;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolManager;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.hbase.index.write.IndexCommitter;
import org.apache.phoenix.hbase.index.write.IndexWriter;
import org.apache.phoenix.hbase.index.write.IndexWriterUtils;
import org.apache.phoenix.util.IndexUtil;

public class ParallelWriterIndexCommitter
implements IndexCommitter {
    public static final String NUM_CONCURRENT_INDEX_WRITER_THREADS_CONF_KEY = "index.writer.threads.max";
    private static final int DEFAULT_CONCURRENT_INDEX_WRITER_THREADS = 128;
    public static final String INDEX_WRITER_KEEP_ALIVE_TIME_CONF_KEY = "index.writer.threads.keepalivetime";
    private static final Log LOG = LogFactory.getLog(ParallelWriterIndexCommitter.class);
    private HTableFactory factory;
    private Stoppable stopped;
    private QuickFailingTaskRunner pool;
    private KeyValueBuilder kvBuilder;
    private RegionCoprocessorEnvironment env;

    public ParallelWriterIndexCommitter() {
    }

    public ParallelWriterIndexCommitter(String hbaseVersion) {
        this.kvBuilder = KeyValueBuilder.get(hbaseVersion);
    }

    @Override
    public void setup(IndexWriter parent, RegionCoprocessorEnvironment env, String name) {
        this.env = env;
        Configuration conf = env.getConfiguration();
        this.setup(IndexWriterUtils.getDefaultDelegateHTableFactory((CoprocessorEnvironment)env), ThreadPoolManager.getExecutor(new ThreadPoolBuilder(name, conf).setMaxThread(NUM_CONCURRENT_INDEX_WRITER_THREADS_CONF_KEY, 128).setCoreTimeout(INDEX_WRITER_KEEP_ALIVE_TIME_CONF_KEY), env), (Abortable)env.getRegionServerServices(), parent, env);
        this.kvBuilder = KeyValueBuilder.get(env.getHBaseVersion());
    }

    void setup(HTableFactory factory, ExecutorService pool, Abortable abortable, Stoppable stop, RegionCoprocessorEnvironment env) {
        this.factory = factory;
        this.pool = new QuickFailingTaskRunner(pool);
        this.stopped = stop;
    }

    @Override
    public void write(Multimap<HTableInterfaceReference, Mutation> toWrite, final boolean allowLocalUpdates) throws SingleIndexWriteFailureException {
        Set entries = toWrite.asMap().entrySet();
        TaskBatch<Void> tasks = new TaskBatch<Void>(entries.size());
        for (Map.Entry entry : entries) {
            final List<Mutation> mutations = this.kvBuilder.cloneIfNecessary((List)entry.getValue());
            final HTableInterfaceReference tableReference = (HTableInterfaceReference)entry.getKey();
            if (this.env != null && !allowLocalUpdates && tableReference.getTableName().equals(this.env.getRegion().getTableDesc().getNameAsString())) continue;
            tasks.add(new Task<Void>(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public Void call() throws Exception {
                    this.throwFailureIfDone();
                    if (ParallelWriterIndexCommitter.access$000().isTraceEnabled()) {
                        ParallelWriterIndexCommitter.access$000().trace((Object)("Writing index update:" + mutations + " to table: " + tableReference));
                    }
                    table = null;
                    try {
                        if (!allowLocalUpdates || ParallelWriterIndexCommitter.access$100(ParallelWriterIndexCommitter.this) == null || !tableReference.getTableName().equals(ParallelWriterIndexCommitter.access$100(ParallelWriterIndexCommitter.this).getRegion().getTableDesc().getNameAsString())) ** GOTO lbl16
                        try {
                            this.throwFailureIfDone();
                            IndexUtil.writeLocalUpdates(ParallelWriterIndexCommitter.access$100(ParallelWriterIndexCommitter.this).getRegion(), mutations, true);
                            var2_2 = null;
                            return var2_2;
                        }
                        catch (IOException ignord) {
                            try {
                                if (ParallelWriterIndexCommitter.access$000().isDebugEnabled()) {
                                    ParallelWriterIndexCommitter.access$000().debug((Object)("indexRegion.batchMutate failed and fall back to HTable.batch(). Got error=" + ignord));
                                }
lbl16:
                                // 4 sources

                                table = ParallelWriterIndexCommitter.access$200(ParallelWriterIndexCommitter.this).getTable(tableReference.get());
                                this.throwFailureIfDone();
                                table.batch(mutations);
                            }
                            catch (SingleIndexWriteFailureException e) {
                                throw e;
                            }
                            catch (IOException e) {
                                throw new SingleIndexWriteFailureException(tableReference.toString(), mutations, e);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new SingleIndexWriteFailureException(tableReference.toString(), mutations, e);
                            }
                            catch (Throwable var3_7) {
                                throw var3_7;
                            }
                        }
                    }
                    finally {
                        if (table != null) {
                            table.close();
                        }
                    }
                    return null;
                }

                private void throwFailureIfDone() throws SingleIndexWriteFailureException {
                    if (this.isBatchFailed() || Thread.currentThread().isInterrupted()) {
                        throw new SingleIndexWriteFailureException("Pool closed, not attempting to write to the index!", null);
                    }
                }
            });
        }
        try {
            this.pool.submitUninterruptible(tasks);
        }
        catch (EarlyExitFailure e) {
            this.propagateFailure(e);
        }
        catch (ExecutionException e) {
            LOG.error((Object)"Found a failed index update!");
            this.propagateFailure(e.getCause());
        }
    }

    private void propagateFailure(Throwable throwable) throws SingleIndexWriteFailureException {
        try {
            throw throwable;
        }
        catch (SingleIndexWriteFailureException e1) {
            throw e1;
        }
        catch (Throwable e1) {
            throw new SingleIndexWriteFailureException("Got an abort notification while writing to the index!", e1);
        }
    }

    public void stop(String why) {
        LOG.info((Object)("Shutting down " + this.getClass().getSimpleName() + " because " + why));
        this.pool.stop(why);
        this.factory.shutdown();
    }

    public boolean isStopped() {
        return this.stopped.isStopped();
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ RegionCoprocessorEnvironment access$100(ParallelWriterIndexCommitter x0) {
        return x0.env;
    }

    static /* synthetic */ HTableFactory access$200(ParallelWriterIndexCommitter x0) {
        return x0.factory;
    }
}

