/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.ScanUtil;

public class DefaultParallelScanGrouper
implements ParallelScanGrouper {
    private static DefaultParallelScanGrouper INSTANCE = new DefaultParallelScanGrouper();

    public static DefaultParallelScanGrouper getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean shouldStartNewScan(QueryPlan plan, List<Scan> scans, byte[] startKey, boolean crossedRegionBoundary) {
        PTable table = plan.getTableRef().getTable();
        boolean startNewScanGroup = false;
        if (!plan.isRowKeyOrdered()) {
            startNewScanGroup = true;
        } else if (crossedRegionBoundary) {
            if (table.getIndexType() == PTable.IndexType.LOCAL) {
                startNewScanGroup = true;
            } else if (table.getBucketNum() != null) {
                startNewScanGroup = scans.isEmpty() || ScanUtil.crossesPrefixBoundary(startKey, ScanUtil.getPrefix(scans.get(scans.size() - 1).getStartRow(), 1), 1);
            }
        }
        return startNewScanGroup;
    }

    @Override
    public List<HRegionLocation> getRegionBoundaries(StatementContext context, byte[] tableName) throws SQLException {
        return context.getConnection().getQueryServices().getAllTableRegions(tableName);
    }
}

