/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.schema.tuple.Tuple;

public class MaterializedResultIterator
implements PeekingResultIterator {
    private final PeekingCollectionIterator iterator;

    public MaterializedResultIterator(Collection<Tuple> results) {
        this.iterator = new PeekingCollectionIterator(results);
    }

    @Override
    public void close() {
    }

    @Override
    public Tuple next() throws SQLException {
        return this.iterator.nextOrNull();
    }

    @Override
    public Tuple peek() throws SQLException {
        return this.iterator.peek();
    }

    @Override
    public void explain(List<String> planSteps) {
    }

    private static class PeekingCollectionIterator
    implements Iterator<Tuple> {
        private final Iterator<Tuple> iterator;
        private Tuple current;

        private PeekingCollectionIterator(Collection<Tuple> results) {
            this.iterator = results.iterator();
            this.advance();
        }

        private Tuple advance() {
            this.current = this.iterator.hasNext() ? this.iterator.next() : null;
            return this.current;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Tuple next() {
            Tuple next = this.nextOrNull();
            if (next == null) {
                throw new NoSuchElementException();
            }
            return next;
        }

        public Tuple nextOrNull() {
            if (this.current == null) {
                return null;
            }
            Tuple next = this.current;
            this.advance();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Tuple peek() {
            return this.current;
        }
    }
}

