/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.phoenix.jdbc.PhoenixDriver;

public class PhoenixConnectionPool {
    private static final Log LOG = LogFactory.getLog(PhoenixConnectionPool.class);
    private PoolConfig cfg;
    private ConcurrentLinkedQueue<Connection> pool = new ConcurrentLinkedQueue();

    public PhoenixConnectionPool(String connectionString) {
        this(new PoolConfig(connectionString));
    }

    public PhoenixConnectionPool(String connectionString, Properties props) {
        this(new PoolConfig(connectionString, props));
    }

    public PhoenixConnectionPool(PoolConfig cfg) {
        cfg.validateConfig();
        this.cfg = cfg;
        try {
            if (cfg.classLoader != null) {
                Class.forName(PhoenixDriver.class.getName(), true, cfg.classLoader);
            } else {
                Class.forName(PhoenixDriver.class.getName());
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed loading Phoenix JDBC driver", t);
            throw new RuntimeException("Failed loading Phoenix JDBC driver", t);
        }
        LOG.info((Object)("PhoenixConnectionPool created. config [" + cfg.toString() + "]"));
    }

    public void close() throws SQLException {
        PDelegateConnection conn;
        while ((conn = (PDelegateConnection)this.pool.poll()) != null) {
            conn.getDelegate().close();
        }
    }

    public Connection getConnection() throws SQLException {
        Connection conn = this.pool.poll();
        if (conn != null) {
            return conn;
        }
        if (this.cfg.props != null) {
            return new PDelegateConnection(DriverManager.getConnection(this.cfg.connectionString, this.cfg.props));
        }
        return new PDelegateConnection(DriverManager.getConnection(this.cfg.connectionString));
    }

    private void putConnection(Connection conn) throws SQLException {
        PDelegateConnection dc = (PDelegateConnection)conn;
        if (this.pool.size() > this.cfg.maxConnectionsToKeepAlive) {
            dc.getDelegate().close();
        } else {
            this.pool.add(conn);
        }
    }

    private class PDelegateConnection
    implements Connection {
        private Connection delegate;

        public PDelegateConnection(Connection delegate) {
            this.delegate = delegate;
        }

        public Connection getDelegate() {
            return this.delegate;
        }

        @Override
        public void close() throws SQLException {
            PhoenixConnectionPool.this.putConnection(this);
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.delegate.createStatement();
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.delegate.prepareStatement(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return this.delegate.prepareCall(sql);
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this.delegate.nativeSQL(sql);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.delegate.setAutoCommit(autoCommit);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.delegate.getAutoCommit();
        }

        @Override
        public void commit() throws SQLException {
            this.delegate.commit();
        }

        @Override
        public void rollback() throws SQLException {
            this.delegate.rollback();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.delegate.isClosed();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.delegate.getMetaData();
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.delegate.setReadOnly(readOnly);
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.delegate.isReadOnly();
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.delegate.setCatalog(catalog);
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.delegate.getCatalog();
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.delegate.setTransactionIsolation(level);
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.delegate.getTransactionIsolation();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.delegate.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.delegate.clearWarnings();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.delegate.createStatement(resultSetType, resultSetConcurrency);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.delegate.getTypeMap();
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.delegate.setTypeMap(map);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.delegate.setHoldability(holdability);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.delegate.getHoldability();
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.delegate.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this.delegate.setSavepoint(name);
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.delegate.rollback(savepoint);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.delegate.releaseSavepoint(savepoint);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return this.delegate.prepareStatement(sql, autoGeneratedKeys);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return this.delegate.prepareStatement(sql, columnIndexes);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return this.delegate.prepareStatement(sql, columnNames);
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.delegate.createClob();
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.delegate.createBlob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.delegate.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.delegate.createSQLXML();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return this.delegate.isValid(timeout);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            this.delegate.setClientInfo(name, value);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.delegate.setClientInfo(properties);
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return this.delegate.getClientInfo(name);
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.delegate.getClientInfo();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return this.delegate.createArrayOf(typeName, elements);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return this.delegate.createStruct(typeName, attributes);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            this.delegate.setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            return this.delegate.getSchema();
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            this.delegate.abort(executor);
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            this.delegate.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return this.delegate.getNetworkTimeout();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.delegate.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.delegate.isWrapperFor(iface);
        }
    }

    public static class PoolConfig {
        public String name = "HSQLPool";
        public String connectionString = null;
        public Properties props = null;
        public int maxConnectionsToKeepAlive = 64;
        public ClassLoader classLoader = null;

        public PoolConfig(String connectionString) {
            this.connectionString = connectionString;
        }

        public PoolConfig(String connectionString, Properties props) {
            this.connectionString = connectionString;
            this.props = props;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("name = [");
            str.append(this.name);
            str.append("], connString = [");
            str.append(this.connectionString);
            str.append("], maxConnectionsToKeepAlive = ");
            str.append(this.maxConnectionsToKeepAlive);
            str.append(", props = [");
            str.append(this.props);
            str.append("], classLoader = [");
            str.append(this.classLoader);
            str.append("]");
            return str.toString();
        }

        private void validateConfig() {
            if (this.connectionString == null || this.connectionString.isEmpty()) {
                throw new IllegalArgumentException("Invalid PhoenixConnectionPool config: connectionString must not be null or empty");
            }
            if (this.maxConnectionsToKeepAlive < 1) {
                throw new IllegalArgumentException("Invalid PhoenixConnectionPool config: maxConnectionsToKeepAlive must >= 1");
            }
        }
    }
}

