/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import com.aliyun.odps.Column;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.type.TypeInfo;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.mapreduce.AbstractBulkLoadTool;
import org.apache.phoenix.mapreduce.ODPSInputFormat;
import org.apache.phoenix.mapreduce.ODPSMapper;
import org.apache.phoenix.mapreduce.util.PhoenixMapReduceUtil;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;
import org.apache.phoenix.schema.types.PTime;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ColumnInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODPSBulkLoadTool
extends AbstractBulkLoadTool {
    protected static final Logger LOG = LoggerFactory.getLogger(ODPSBulkLoadTool.class);
    static final String ODSP_IGNORED_DATA_DIRECTORY = "/tmp/odps_ignored_data";
    static final Option ACCESS_ID_OPT = new Option("access_id", true, "your access id");
    static final Option ACCESS_KEY_OPT = new Option("access_key", true, "your access key");
    static final Option ODPS_URL_OPT = new Option("odps_url", true, "ODPS URL");
    static final Option TUNNEL_OPT = new Option("odps_tunnel_url", true, "tunnel URL");
    static final Option PROJECT_OPT = new Option("odps_project", true, "project name");
    static final Option TABLE_OPT = new Option("odps_table", true, "table name");
    static final Option PARTITION_SPEC_OPT = new Option("odps_partition_spec", true, "your partition specific(Optional)");
    static final Option PARTITION_NUMBER_OPT = new Option("odps_partition_number", true, "split number((Optional))");
    static final Option ODPS_COLUMNS_OPT = new Option("odps_column_names", true, "Comma-separated list of columns(Optional)");
    static final Option ERROR_DATA_PATH_OPT = new Option("error_data_path", true, "hdfs path(Optional), default path: hdfs:///tmp/odps_ignored_data");

    @Override
    protected void configureOptions(CommandLine cmdLine, List<ColumnInfo> importColumns, Configuration conf) throws SQLException {
        block15: {
            ArrayList sourceColumnNames = null;
            if (cmdLine.hasOption(ODPS_COLUMNS_OPT.getOpt())) {
                sourceColumnNames = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)cmdLine.getOptionValue(ODPS_COLUMNS_OPT.getOpt())));
                conf.set("odps.mapreduce.import.columninfos", Joiner.on((String)"|").useForNull("").join((Iterable)sourceColumnNames));
                List<ColumnInfo> mappedColumns = importColumns.subList(0, sourceColumnNames.size());
                LOG.info("Columns " + mappedColumns.toString() + " of Phoenix table are mapped!");
                conf.set("phoenix.mapped.import.columninfos", Joiner.on((String)"|").useForNull("").join(mappedColumns));
            }
            List targetColumnNames = null;
            if (cmdLine.hasOption(IMPORT_COLUMNS_OPT.getOpt())) {
                targetColumnNames = Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)cmdLine.getOptionValue(IMPORT_COLUMNS_OPT.getOpt())));
                if (sourceColumnNames != null && sourceColumnNames.size() != targetColumnNames.size()) {
                    throw new IllegalStateException("ODPS table columns size is not equal Phoenix table columns size!");
                }
            }
            if (sourceColumnNames != null && sourceColumnNames.size() > targetColumnNames.size()) {
                throw new IllegalStateException("ODPS table columns size should not bigger than Phoenix table columns size!");
            }
            conf.set("odps.access.key.id", cmdLine.getOptionValue(ACCESS_ID_OPT.getOpt()));
            conf.set("odps.access.key.secret", cmdLine.getOptionValue(ACCESS_KEY_OPT.getOpt()));
            conf.set("odps.url", cmdLine.getOptionValue(ODPS_URL_OPT.getOpt()));
            conf.set("odps.tunnel.url", cmdLine.getOptionValue(TUNNEL_OPT.getOpt()));
            conf.set("odps.project.name", cmdLine.getOptionValue(PROJECT_OPT.getOpt()));
            conf.set("odps.table.name", cmdLine.getOptionValue(TABLE_OPT.getOpt()));
            String path = cmdLine.hasOption(ERROR_DATA_PATH_OPT.getOpt()) ? cmdLine.getOptionValue(ERROR_DATA_PATH_OPT.getOpt()) : ODSP_IGNORED_DATA_DIRECTORY;
            conf.set("odps.error.data.path", path);
            if (cmdLine.hasOption(PARTITION_SPEC_OPT.getOpt())) {
                conf.set("odps.table.partition.spec", cmdLine.getOptionValue(PARTITION_SPEC_OPT.getOpt()));
            }
            if (cmdLine.hasOption(PARTITION_NUMBER_OPT.getOpt())) {
                conf.setInt("odps.table.split.number", Integer.valueOf(cmdLine.getOptionValue(PARTITION_NUMBER_OPT.getOpt())).intValue());
            }
            try {
                TableTunnel.DownloadSession downloadSession = PhoenixMapReduceUtil.getDownloadSession(conf);
                TableSchema sourceSchema = downloadSession.getSchema();
                if (sourceColumnNames != null) {
                    int i = 0;
                    for (String sc : sourceColumnNames) {
                        try {
                            Column column = sourceSchema.getColumn(sc);
                            this.isCastableTo(column, importColumns.get(i));
                        }
                        catch (IllegalArgumentException e) {
                            LOG.error("Column:" + sc + " does not exists in table:" + cmdLine.getOptionValue(TABLE_OPT.getOpt()));
                            throw e;
                        }
                        ++i;
                    }
                    break block15;
                }
                if (sourceSchema.getColumns().size() > importColumns.size()) {
                    List defaultSourceColumns = Lists.transform((List)sourceSchema.getColumns(), (Function)new Function<Column, String>(){

                        @Nullable
                        public String apply(@Nullable Column input) {
                            return input.getTypeInfo().getTypeName() + ":" + input.getName();
                        }
                    });
                    LOG.info("All columns of ODPS table: " + defaultSourceColumns);
                    LOG.info("All columns of Phoenix table: " + importColumns);
                    throw new IllegalStateException("ODPS table columns size should not bigger than Phoenix table columns size!");
                }
                conf.set("odps.mapreduce.import.columninfos", Joiner.on((String)"|").useForNull("").join((Iterable)Lists.transform((List)sourceSchema.getColumns(), (Function)new Function<Column, String>(){

                    @Nullable
                    public String apply(@Nullable Column input) {
                        return input.getName();
                    }
                })));
                List<ColumnInfo> mappedColumns = importColumns.subList(0, sourceSchema.getColumns().size());
                LOG.info("Columns " + mappedColumns.toString() + " of Phoenix table are mapped!");
                conf.set("phoenix.mapped.import.columninfos", Joiner.on((String)"|").useForNull("").join(mappedColumns));
            }
            catch (TunnelException e) {
                throw new IllegalStateException(e.getCause());
            }
        }
        conf.setClass("odps.input.class", MapWritable.class, Writable.class);
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path dirPath = new Path(conf.get("odps.error.data.path"));
            LOG.info("Ignored data directory :" + dirPath.toString() + " will be recreated!");
            fs.delete(dirPath, true);
            fs.mkdirs(dirPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void isCastableTo(Column sourceColumn, ColumnInfo targetColumn) {
        boolean isCastable;
        TypeInfo typeInfo = sourceColumn.getTypeInfo();
        if (targetColumn.getPDataType().getSqlType() == 12 || targetColumn.getPDataType().getSqlType() == 1) {
            return;
        }
        switch (typeInfo.getOdpsType()) {
            case BIGINT: {
                isCastable = PLong.INSTANCE.isCastableTo(targetColumn.getPDataType());
                break;
            }
            case DOUBLE: {
                isCastable = PDouble.INSTANCE.isCastableTo(targetColumn.getPDataType());
                break;
            }
            case BOOLEAN: {
                isCastable = PBoolean.INSTANCE.isCastableTo(targetColumn.getPDataType());
                break;
            }
            case STRING: {
                isCastable = PVarchar.INSTANCE.isCastableTo(targetColumn.getPDataType());
                break;
            }
            case DECIMAL: {
                isCastable = PDecimal.INSTANCE.isCastableTo(targetColumn.getPDataType());
                break;
            }
            case TINYINT: {
                isCastable = PTinyint.INSTANCE.isCastableTo(targetColumn.getPDataType());
                break;
            }
            case SMALLINT: {
                isCastable = PSmallint.INSTANCE.isCastableTo(targetColumn.getPDataType());
                break;
            }
            case INT: {
                isCastable = PInteger.INSTANCE.isCastableTo(targetColumn.getPDataType());
                break;
            }
            case FLOAT: {
                isCastable = PFloat.INSTANCE.isCastableTo(targetColumn.getPDataType());
                break;
            }
            case CHAR: {
                isCastable = PChar.INSTANCE.isCastableTo(targetColumn.getPDataType());
                break;
            }
            case VARCHAR: {
                isCastable = PChar.INSTANCE.isCastableTo(targetColumn.getPDataType());
                break;
            }
            case DATETIME: {
                isCastable = PTime.INSTANCE.isCastableTo(targetColumn.getPDataType());
                break;
            }
            case DATE: {
                isCastable = PDate.INSTANCE.isCastableTo(targetColumn.getPDataType());
                break;
            }
            case TIMESTAMP: {
                isCastable = PTimestamp.INSTANCE.isCastableTo(targetColumn.getPDataType());
                break;
            }
            default: {
                throw new IllegalStateException("UnSupported data type: " + typeInfo.getTypeName() + " as source data type");
            }
        }
        if (!isCastable) {
            throw new IllegalStateException("Unsupported data type: " + sourceColumn.getTypeInfo().getTypeName() + " of ODPS table  " + " cast to data type:" + targetColumn.getPDataType().getSqlTypeName() + " of Phoenix table");
        }
    }

    @Override
    protected void setupJob(Job job) {
        job.setInputFormatClass(ODPSInputFormat.class);
        job.setMapperClass(ODPSMapper.class);
        if (job.getJar() == null) {
            job.setJarByClass(ODPSMapper.class);
        }
    }

    @Override
    protected Options getOptions() {
        Options options = super.getOptions();
        ACCESS_ID_OPT.setRequired(true);
        options.addOption(ACCESS_ID_OPT);
        ACCESS_KEY_OPT.setRequired(true);
        options.addOption(ACCESS_KEY_OPT);
        ODPS_URL_OPT.setRequired(true);
        options.addOption(ODPS_URL_OPT);
        TUNNEL_OPT.setRequired(true);
        options.addOption(TUNNEL_OPT);
        PROJECT_OPT.setRequired(true);
        options.addOption(PROJECT_OPT);
        TABLE_OPT.setRequired(true);
        options.addOption(TABLE_OPT);
        options.addOption(PARTITION_SPEC_OPT);
        options.addOption(PARTITION_NUMBER_OPT);
        options.addOption(ERROR_DATA_PATH_OPT);
        options.addOption(ODPS_COLUMNS_OPT);
        return options;
    }

    public static void main(String[] args) throws Exception {
        int exitStatus = ToolRunner.run((Tool)new ODPSBulkLoadTool(), (String[])args);
        System.exit(exitStatus);
    }
}

