/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.schema.PIndexState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexToolUtil {
    private static final String ALTER_INDEX_QUERY_TEMPLATE = "ALTER INDEX IF EXISTS %s ON %s %s";
    private static final Logger LOG = LoggerFactory.getLogger(IndexToolUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateIndexState(Configuration configuration, PIndexState state2) throws SQLException {
        String masterTable = PhoenixConfigurationUtil.getInputTableName(configuration);
        String[] indexTables = PhoenixConfigurationUtil.getDisableIndexes(configuration).split(",");
        Properties overrideProps = new Properties();
        try (Connection connection = ConnectionUtil.getOutputConnection(configuration, overrideProps);){
            for (String indexTable : indexTables) {
                IndexToolUtil.updateIndexState(connection, masterTable, indexTable, state2);
            }
        }
    }

    public static void updateIndexState(Connection connection, String masterTable, String indexTable, PIndexState state2) throws SQLException {
        Preconditions.checkNotNull((Object)connection);
        String alterQuery = String.format(ALTER_INDEX_QUERY_TEMPLATE, indexTable, masterTable, state2.name());
        connection.createStatement().execute(alterQuery);
        LOG.info(" Updated the status of the index {} to {} ", (Object)indexTable, (Object)state2.name());
    }
}

