/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.PhoenixJobCounters;
import org.apache.phoenix.mapreduce.index.DirectHTableWriter;
import org.apache.phoenix.mapreduce.index.PhoenixIndexDBWritable;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.util.ColumnInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixIndexImportDirectMapper
extends Mapper<NullWritable, PhoenixIndexDBWritable, ImmutableBytesWritable, IntWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixIndexImportDirectMapper.class);
    private final PhoenixIndexDBWritable indxWritable = new PhoenixIndexDBWritable();
    private List<ColumnInfo> indxTblColumnMetadata;
    private Connection connection;
    private PreparedStatement pStatement;
    private DirectHTableWriter writer;
    private int batchSize;
    private long batchSizeBytes;
    private MutationState mutationState;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration configuration = context.getConfiguration();
        this.writer = new DirectHTableWriter(configuration);
        try {
            this.indxTblColumnMetadata = PhoenixConfigurationUtil.getUpsertColumnMetadataList(configuration);
            this.indxWritable.setColumnMetadata(this.indxTblColumnMetadata);
            Properties overrideProps = new Properties();
            String scn = configuration.get("phoenix.mr.currentscn.value");
            String txScnValue = configuration.get("phoenix.mr.txscn.value");
            if (txScnValue == null) {
                overrideProps.put("BuildIndexAt", scn);
            }
            this.connection = ConnectionUtil.getOutputConnection(configuration, overrideProps);
            this.connection.setAutoCommit(false);
            ConnectionQueryServices services = ((PhoenixConnection)this.connection).getQueryServices();
            int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 35000);
            this.batchSize = Math.min(((PhoenixConnection)this.connection).getMutateBatchSize(), maxSize);
            this.batchSizeBytes = ((PhoenixConnection)this.connection).getMutateBatchSizeBytes();
            LOG.info("Mutation Batch Size = " + this.batchSize);
            String upsertQuery = PhoenixConfigurationUtil.getUpsertStatement(configuration);
            this.pStatement = this.connection.prepareStatement(upsertQuery);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void map(NullWritable key, PhoenixIndexDBWritable record, Mapper.Context context) throws IOException, InterruptedException {
        try {
            List<Object> values = record.getValues();
            this.indxWritable.setValues(values);
            this.indxWritable.write(this.pStatement);
            this.pStatement.execute();
            PhoenixConnection pconn = this.connection.unwrap(PhoenixConnection.class);
            MutationState currentMutationState = pconn.getMutationState();
            if (this.mutationState == null) {
                this.mutationState = currentMutationState;
            }
            this.mutationState.join(currentMutationState);
            if (context.getCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue() % (long)this.batchSize == 0L) {
                this.writeBatch(this.mutationState, context);
                this.mutationState = null;
            }
            context.progress();
        }
        catch (SQLException e) {
            LOG.error(" Error {}  while read/write of a record ", (Object)e.getMessage());
            context.getCounter((Enum)PhoenixJobCounters.FAILED_RECORDS).increment(1L);
            throw new RuntimeException(e);
        }
        context.getCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).increment(1L);
    }

    private void writeBatch(MutationState mutationState, Mapper.Context context) throws IOException, SQLException, InterruptedException {
        Iterator<Pair<byte[], List<Mutation>>> iterator = mutationState.toMutations(true, null);
        while (iterator.hasNext()) {
            Pair<byte[], List<Mutation>> mutationPair = iterator.next();
            List batchMutations = (List)mutationPair.getSecond();
            List<List<Mutation>> batchOfBatchMutations = MutationState.getMutationBatchList(this.batchSize, this.batchSizeBytes, batchMutations);
            for (List<Mutation> mutationList : batchOfBatchMutations) {
                this.writer.write(mutationList);
            }
            context.getCounter((Enum)PhoenixJobCounters.OUTPUT_RECORDS).increment((long)((List)mutationPair.getSecond()).size());
        }
        this.connection.rollback();
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        try {
            if (this.mutationState != null) {
                this.writeBatch(this.mutationState, context);
            }
            context.write((Object)new ImmutableBytesWritable(UUID.randomUUID().toString().getBytes()), (Object)new IntWritable(0));
            super.cleanup(context);
        }
        catch (SQLException e) {
            LOG.error(" Error {}  while read/write of a record ", (Object)e.getMessage());
            context.getCounter((Enum)PhoenixJobCounters.FAILED_RECORDS).increment(1L);
            throw new RuntimeException(e);
        }
        finally {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException e) {
                    LOG.error("Error {} while closing connection in the PhoenixIndexMapper class ", (Object)e.getMessage());
                }
            }
            if (this.writer != null) {
                this.writer.close();
            }
        }
    }
}

