/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index.automation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.phoenix.mapreduce.index.automation.PhoenixAsyncIndex;
import org.apache.phoenix.mapreduce.index.automation.PhoenixMRJobCallable;
import org.apache.phoenix.mapreduce.index.automation.YarnApplication;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.util.PhoenixMRJobUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.apache.phoenix.util.ZKBasedMasterElectionUtil;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class PhoenixMRJobSubmitter {
    private static final String PHOENIX_LOCKS_PARENT = "/phoenix/automated-mr-index-build-leader-election";
    private static final String AUTO_INDEX_BUILD_LOCK_NAME = "ActiveStandbyElectorLock";
    public static final String CANDIDATE_INDEX_INFO_QUERY = "SELECT INDEX_TYPE,DATA_TABLE_NAME, TABLE_SCHEM, TABLE_NAME, ASYNC_CREATED_DATE FROM SYSTEM.\"CATALOG\" (ASYNC_CREATED_DATE " + PDate.INSTANCE.getSqlTypeName() + ") " + " WHERE " + "COLUMN_NAME" + " IS NULL and " + "COLUMN_FAMILY" + " IS NULL  and " + "ASYNC_CREATED_DATE" + " IS NOT NULL and " + "TABLE_TYPE" + " = '" + PTableType.INDEX.getSerializedValue() + "' and " + "INDEX_STATE" + " = '" + PIndexState.BUILDING.getSerializedValue() + "'";
    private static final int JOB_SUBMIT_POOL_TIMEOUT = 5;
    private Configuration conf;
    private String zkQuorum;
    private static final Log LOG = LogFactory.getLog(PhoenixMRJobSubmitter.class);

    public PhoenixMRJobSubmitter() throws IOException {
        this(null);
    }

    public PhoenixMRJobSubmitter(Configuration conf) throws IOException {
        if (conf == null) {
            conf = HBaseConfiguration.create();
        }
        this.conf = conf;
        PhoenixMRJobUtil.updateTimeoutsToFailFast(conf);
        String schedulerType = conf.get("phoenix.index.mr.scheduler.type", PhoenixMRJobUtil.MR_SCHEDULER_TYPE.NONE.toString());
        PhoenixMRJobUtil.MR_SCHEDULER_TYPE type = PhoenixMRJobUtil.MR_SCHEDULER_TYPE.valueOf(schedulerType);
        switch (type) {
            case CAPACITY: {
                LOG.info((Object)"Applying the Capacity Scheduler Queue Configurations");
                PhoenixMRJobUtil.updateCapacityQueueInfo(conf);
                break;
            }
            case FAIR: {
                LOG.warn((Object)"Fair Scheduler type is not yet supported");
                throw new IOException("Fair Scheduler is not yet supported");
            }
        }
        this.zkQuorum = conf.get("hbase.zookeeper.quorum");
        this.enableKeyTabSecurity();
    }

    private void enableKeyTabSecurity() throws IOException {
        String PRINCIPAL = "principal";
        String KEYTAB = "keyTab";
        String principal = null;
        String keyTabPath = null;
        AppConfigurationEntry[] entries = javax.security.auth.login.Configuration.getConfiguration().getAppConfigurationEntry("Client");
        LOG.info((Object)"Security - Fetched App Login Configuration Entries");
        if (entries != null) {
            for (AppConfigurationEntry entry : entries) {
                if (entry.getOptions().get("principal") != null) {
                    principal = (String)entry.getOptions().get("principal");
                }
                if (entry.getOptions().get("keyTab") == null) continue;
                keyTabPath = (String)entry.getOptions().get("keyTab");
            }
            LOG.info((Object)("Security - Got Principal = " + principal + ""));
            if (principal != null && keyTabPath != null) {
                LOG.info((Object)("Security - Retreiving the TGT with principal:" + principal + " and keytab:" + keyTabPath));
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)keyTabPath);
                LOG.info((Object)("Security - Retrieved TGT with principal:" + principal + " and keytab:" + keyTabPath));
            }
        }
    }

    public Map<String, PhoenixAsyncIndex> getCandidateJobs() throws SQLException {
        Properties props = new Properties();
        UpgradeUtil.doNotUpgradeOnFirstConnection(props);
        Connection con = DriverManager.getConnection("jdbc:phoenix:" + this.zkQuorum);
        Statement s = con.createStatement();
        ResultSet rs = s.executeQuery(CANDIDATE_INDEX_INFO_QUERY);
        HashMap<String, PhoenixAsyncIndex> candidateIndexes = new HashMap<String, PhoenixAsyncIndex>();
        while (rs.next()) {
            PhoenixAsyncIndex indexInfo = new PhoenixAsyncIndex();
            indexInfo.setIndexType(PTable.IndexType.fromSerializedValue(rs.getByte("INDEX_TYPE")));
            indexInfo.setDataTableName(rs.getString("DATA_TABLE_NAME"));
            indexInfo.setTableSchem(rs.getString("TABLE_SCHEM"));
            indexInfo.setTableName(rs.getString("TABLE_NAME"));
            candidateIndexes.put(String.format("PHOENIX_%s_INDX_%s", indexInfo.getDataTableName(), indexInfo.getTableName()), indexInfo);
        }
        return candidateIndexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scheduleIndexBuilds() throws Exception {
        ZooKeeperWatcher zookeeperWatcher = new ZooKeeperWatcher(this.conf, "phoenixAutomatedMRIndexBuild", null);
        if (!ZKBasedMasterElectionUtil.acquireLock(zookeeperWatcher, PHOENIX_LOCKS_PARENT, AUTO_INDEX_BUILD_LOCK_NAME)) {
            LOG.info((Object)"Some other node is already running Automated Index Build. Skipping execution!");
            return -1;
        }
        Map<String, PhoenixAsyncIndex> candidateJobs = this.getCandidateJobs();
        LOG.info((Object)("Candidate Indexes to be built as seen from SYSTEM.CATALOG - " + candidateJobs));
        Set<String> submittedJobs = this.getSubmittedYarnApps();
        LOG.info((Object)("Already Submitted/Running MR index build jobs - " + submittedJobs));
        Set<PhoenixAsyncIndex> jobsToSchedule = this.getJobsToSubmit(candidateJobs, submittedJobs);
        LOG.info((Object)("Final indexes to be built - " + jobsToSchedule));
        ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>(jobsToSchedule.size());
        int failedJobSubmissionCount = 0;
        int timedoutJobSubmissionCount = 0;
        ExecutorService jobSubmitPool = Executors.newFixedThreadPool(10);
        LOG.info((Object)("Attempt to submit MR index build jobs for - " + jobsToSchedule));
        try {
            for (PhoenixAsyncIndex phoenixAsyncIndex : jobsToSchedule) {
                PhoenixMRJobCallable task = new PhoenixMRJobCallable(HBaseConfiguration.create((Configuration)this.conf), phoenixAsyncIndex, "/");
                results.add(jobSubmitPool.submit(task));
            }
            for (Future future : results) {
                try {
                    future.get(5L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    ++failedJobSubmissionCount;
                }
                catch (ExecutionException e) {
                    ++failedJobSubmissionCount;
                }
                catch (TimeoutException e) {
                    ++timedoutJobSubmissionCount;
                }
            }
        }
        finally {
            PhoenixMRJobUtil.shutdown(jobSubmitPool);
        }
        LOG.info((Object)("Result of Attempt to Submit MR index build Jobs - Jobs attempted = " + jobsToSchedule.size() + " ; Failed to Submit = " + failedJobSubmissionCount + " ; Timed out = " + timedoutJobSubmissionCount));
        return failedJobSubmissionCount;
    }

    public Set<PhoenixAsyncIndex> getJobsToSubmit(Map<String, PhoenixAsyncIndex> candidateJobs, Set<String> submittedJobs) {
        HashSet<PhoenixAsyncIndex> toScheduleJobs = new HashSet<PhoenixAsyncIndex>(candidateJobs.values());
        for (String jobId : submittedJobs) {
            if (!candidateJobs.containsKey(jobId)) continue;
            toScheduleJobs.remove(candidateJobs.get(jobId));
        }
        toScheduleJobs.removeAll(submittedJobs);
        return toScheduleJobs;
    }

    public Set<String> getSubmittedYarnApps() throws Exception {
        String rmHost = PhoenixMRJobUtil.getActiveResourceManagerHost(this.conf, this.zkQuorum);
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("states", YarnApplication.state.NEW.toString() + "," + (Object)((Object)YarnApplication.state.ACCEPTED) + "," + (Object)((Object)YarnApplication.state.SUBMITTED) + "," + (Object)((Object)YarnApplication.state.RUNNING));
        int rmPort = PhoenixMRJobUtil.getRMPort(this.conf);
        String response = PhoenixMRJobUtil.getJobsInformationFromRM(rmHost, rmPort, urlParams);
        LOG.debug((Object)("Already Submitted/Running Apps = " + response));
        JSONObject jobsJson = new JSONObject(response);
        JSONObject appsJson = jobsJson.optJSONObject("apps");
        HashSet<String> yarnApplicationSet = new HashSet<String>();
        if (appsJson == null) {
            return yarnApplicationSet;
        }
        JSONArray appJson = appsJson.optJSONArray("app");
        if (appJson == null) {
            return yarnApplicationSet;
        }
        for (int i = 0; i < appJson.length(); ++i) {
            Gson gson = new GsonBuilder().create();
            YarnApplication yarnApplication = (YarnApplication)gson.fromJson(appJson.getJSONObject(i).toString(), new TypeToken<YarnApplication>(){}.getType());
            yarnApplicationSet.add(yarnApplication.getName());
        }
        return yarnApplicationSet;
    }

    public static void main(String[] args) throws Exception {
        PhoenixMRJobSubmitter t = new PhoenixMRJobSubmitter();
        t.scheduleIndexBuilds();
    }
}

