/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import com.google.common.base.Preconditions;
import org.apache.phoenix.monitoring.CombinableMetric;
import org.apache.phoenix.monitoring.Metric;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.NonAtomicMetric;

public class CombinableMetricImpl
implements CombinableMetric {
    private final Metric metric;

    public CombinableMetricImpl(MetricType type) {
        this.metric = new NonAtomicMetric(type);
    }

    @Override
    public MetricType getMetricType() {
        return this.metric.getMetricType();
    }

    @Override
    public long getValue() {
        return this.metric.getValue();
    }

    @Override
    public void change(long delta) {
        this.metric.change(delta);
    }

    @Override
    public void increment() {
        this.metric.increment();
    }

    @Override
    public String getCurrentMetricState() {
        return this.metric.getCurrentMetricState();
    }

    @Override
    public void reset() {
        this.metric.reset();
    }

    @Override
    public String getPublishString() {
        return this.getCurrentMetricState();
    }

    @Override
    public CombinableMetric combine(CombinableMetric metric) {
        Preconditions.checkArgument((boolean)this.getClass().equals(metric.getClass()));
        this.metric.change(metric.getValue());
        return this;
    }

    @Override
    public void decrement() {
        this.metric.decrement();
    }
}

