/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import org.apache.phoenix.util.PhoenixStopWatch;

final class MetricsStopWatch {
    private final boolean isMetricsEnabled;
    private final PhoenixStopWatch stopwatch;

    MetricsStopWatch(boolean isMetricsEnabled) {
        this.isMetricsEnabled = isMetricsEnabled;
        this.stopwatch = new PhoenixStopWatch();
    }

    void start() {
        if (this.isMetricsEnabled) {
            this.stopwatch.start();
        }
    }

    void stop() {
        if (this.isMetricsEnabled && this.stopwatch.isRunning()) {
            this.stopwatch.stop();
        }
    }

    long getElapsedTimeInMs() {
        if (this.isMetricsEnabled) {
            return this.stopwatch.elapsedMillis();
        }
        return 0L;
    }
}

