/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.HashMap;
import java.util.Map;
import org.apache.phoenix.monitoring.CombinableMetric;
import org.apache.phoenix.monitoring.CombinableMetricImpl;
import org.apache.phoenix.monitoring.MetricType;
import org.apache.phoenix.monitoring.MetricsStopWatch;

public class OverAllQueryMetrics {
    private final MetricsStopWatch queryWatch;
    private final MetricsStopWatch resultSetWatch;
    private final CombinableMetric numParallelScans;
    private final CombinableMetric wallClockTimeMS;
    private final CombinableMetric resultSetTimeMS;
    private final CombinableMetric queryTimedOut;
    private final CombinableMetric queryFailed;
    private final CombinableMetric cacheRefreshedDueToSplits;

    public OverAllQueryMetrics(boolean isMetricsEnabled) {
        this.queryWatch = new MetricsStopWatch(isMetricsEnabled);
        this.resultSetWatch = new MetricsStopWatch(isMetricsEnabled);
        this.numParallelScans = isMetricsEnabled ? new CombinableMetricImpl(MetricType.NUM_PARALLEL_SCANS) : CombinableMetric.NoOpRequestMetric.INSTANCE;
        this.wallClockTimeMS = isMetricsEnabled ? new CombinableMetricImpl(MetricType.WALL_CLOCK_TIME_MS) : CombinableMetric.NoOpRequestMetric.INSTANCE;
        this.resultSetTimeMS = isMetricsEnabled ? new CombinableMetricImpl(MetricType.RESULT_SET_TIME_MS) : CombinableMetric.NoOpRequestMetric.INSTANCE;
        this.queryTimedOut = isMetricsEnabled ? new CombinableMetricImpl(MetricType.QUERY_TIMEOUT_COUNTER) : CombinableMetric.NoOpRequestMetric.INSTANCE;
        this.queryFailed = isMetricsEnabled ? new CombinableMetricImpl(MetricType.QUERY_FAILED_COUNTER) : CombinableMetric.NoOpRequestMetric.INSTANCE;
        this.cacheRefreshedDueToSplits = isMetricsEnabled ? new CombinableMetricImpl(MetricType.CACHE_REFRESH_SPLITS_COUNTER) : CombinableMetric.NoOpRequestMetric.INSTANCE;
    }

    public void updateNumParallelScans(long numParallelScans) {
        this.numParallelScans.change(numParallelScans);
    }

    public void queryTimedOut() {
        this.queryTimedOut.increment();
    }

    public void queryFailed() {
        this.queryFailed.increment();
    }

    public void cacheRefreshedDueToSplits() {
        this.cacheRefreshedDueToSplits.increment();
    }

    public void startQuery() {
        this.queryWatch.start();
    }

    public void endQuery() {
        this.queryWatch.stop();
        this.wallClockTimeMS.change(this.queryWatch.getElapsedTimeInMs());
    }

    public void startResultSetWatch() {
        this.resultSetWatch.start();
    }

    public void stopResultSetWatch() {
        this.resultSetWatch.stop();
        this.resultSetTimeMS.change(this.resultSetWatch.getElapsedTimeInMs());
    }

    public Map<MetricType, Long> publish() {
        HashMap<MetricType, Long> metricsForPublish = new HashMap<MetricType, Long>();
        metricsForPublish.put(this.numParallelScans.getMetricType(), this.numParallelScans.getValue());
        metricsForPublish.put(this.wallClockTimeMS.getMetricType(), this.wallClockTimeMS.getValue());
        metricsForPublish.put(this.resultSetTimeMS.getMetricType(), this.resultSetTimeMS.getValue());
        metricsForPublish.put(this.queryTimedOut.getMetricType(), this.queryTimedOut.getValue());
        metricsForPublish.put(this.queryFailed.getMetricType(), this.queryFailed.getValue());
        metricsForPublish.put(this.cacheRefreshedDueToSplits.getMetricType(), this.cacheRefreshedDueToSplits.getValue());
        return metricsForPublish;
    }

    public void reset() {
        this.numParallelScans.reset();
        this.wallClockTimeMS.reset();
        this.resultSetTimeMS.reset();
        this.queryTimedOut.reset();
        this.queryFailed.reset();
        this.cacheRefreshedDueToSplits.reset();
        this.queryWatch.stop();
        this.resultSetWatch.stop();
    }

    public OverAllQueryMetrics combine(OverAllQueryMetrics metric) {
        this.cacheRefreshedDueToSplits.combine(metric.cacheRefreshedDueToSplits);
        this.queryFailed.combine(metric.queryFailed);
        this.queryTimedOut.combine(metric.queryTimedOut);
        this.numParallelScans.combine(metric.numParallelScans);
        return this;
    }
}

