/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.IndexKeyConstraint;
import org.apache.phoenix.parse.NamedNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SingleTableStatement;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.UDFParseNode;
import org.apache.phoenix.schema.PTable;

public class CreateIndexStatement
extends SingleTableStatement {
    private final TableName indexTableName;
    private final IndexKeyConstraint indexKeyConstraint;
    private final List<ColumnName> includeColumns;
    private final List<ParseNode> splitNodes;
    private final ListMultimap<String, Pair<String, Object>> props;
    private final boolean ifNotExists;
    private final PTable.IndexType indexType;
    private final boolean async;
    private final Map<String, UDFParseNode> udfParseNodes;

    public CreateIndexStatement(NamedNode indexTableName, NamedTableNode dataTable, IndexKeyConstraint indexKeyConstraint, List<ColumnName> includeColumns, List<ParseNode> splits, ListMultimap<String, Pair<String, Object>> props, boolean ifNotExists, PTable.IndexType indexType, boolean async, int bindCount, Map<String, UDFParseNode> udfParseNodes) {
        super(dataTable, bindCount);
        this.indexTableName = TableName.create(dataTable.getName().getSchemaName(), indexTableName.getName());
        this.indexKeyConstraint = indexKeyConstraint == null ? IndexKeyConstraint.EMPTY : indexKeyConstraint;
        this.includeColumns = includeColumns == null ? Collections.emptyList() : includeColumns;
        this.splitNodes = splits == null ? Collections.emptyList() : splits;
        this.props = props == null ? ArrayListMultimap.create() : props;
        this.ifNotExists = ifNotExists;
        this.indexType = indexType;
        this.async = async;
        this.udfParseNodes = udfParseNodes;
    }

    public IndexKeyConstraint getIndexConstraint() {
        return this.indexKeyConstraint;
    }

    public List<ColumnName> getIncludeColumns() {
        return this.includeColumns;
    }

    public TableName getIndexTableName() {
        return this.indexTableName;
    }

    public List<ParseNode> getSplitNodes() {
        return this.splitNodes;
    }

    public ListMultimap<String, Pair<String, Object>> getProps() {
        return this.props;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    public PTable.IndexType getIndexType() {
        return this.indexType;
    }

    public boolean isAsync() {
        return this.async;
    }

    public Map<String, UDFParseNode> getUdfParseNodes() {
        return this.udfParseNodes;
    }
}

