/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.SchemaUtil;

public class PColumnImpl
implements PColumn {
    private PName name;
    private PName familyName;
    private PDataType dataType;
    private Integer maxLength;
    private Integer scale;
    private boolean nullable;
    private int position;
    private SortOrder sortOrder;
    private Integer arraySize;
    private byte[] viewConstant;
    private boolean isViewReferenced;
    private String expressionStr;
    private boolean isRowTimestamp;
    private boolean isDynamic;
    private byte[] columnQualifierBytes;

    public PColumnImpl() {
    }

    public PColumnImpl(PName name, PName familyName, PDataType dataType, Integer maxLength, Integer scale, boolean nullable, int position, SortOrder sortOrder, Integer arrSize, byte[] viewConstant, boolean isViewReferenced, String expressionStr, boolean isRowTimestamp, boolean isDynamic, byte[] columnQualifierBytes) {
        this.init(name, familyName, dataType, maxLength, scale, nullable, position, sortOrder, arrSize, viewConstant, isViewReferenced, expressionStr, isRowTimestamp, isDynamic, columnQualifierBytes);
    }

    public PColumnImpl(PColumn column, int position) {
        this(column.getName(), column.getFamilyName(), column.getDataType(), column.getMaxLength(), column.getScale(), column.isNullable(), position, column.getSortOrder(), column.getArraySize(), column.getViewConstant(), column.isViewReferenced(), column.getExpressionStr(), column.isRowTimestamp(), column.isDynamic(), column.getColumnQualifierBytes());
    }

    private void init(PName name, PName familyName, PDataType dataType, Integer maxLength, Integer scale, boolean nullable, int position, SortOrder sortOrder, Integer arrSize, byte[] viewConstant, boolean isViewReferenced, String expressionStr, boolean isRowTimestamp, boolean isDynamic, byte[] columnQualifierBytes) {
        Preconditions.checkNotNull((Object)((Object)sortOrder));
        this.dataType = dataType;
        if (familyName == null) {
            Preconditions.checkArgument((!nullable || !dataType.isFixedWidth() ? 1 : 0) != 0, (Object)("PK columns may not be both fixed width and nullable: " + name.getString()));
        }
        this.name = name;
        this.familyName = familyName == null ? null : familyName;
        this.maxLength = maxLength;
        this.scale = scale;
        this.nullable = nullable;
        this.position = position;
        this.sortOrder = sortOrder;
        this.arraySize = arrSize;
        this.viewConstant = viewConstant;
        this.isViewReferenced = isViewReferenced;
        this.expressionStr = expressionStr;
        this.isRowTimestamp = isRowTimestamp;
        this.isDynamic = isDynamic;
        this.columnQualifierBytes = columnQualifierBytes;
    }

    @Override
    public int getEstimatedSize() {
        return 144 + this.name.getEstimatedSize() + (this.familyName == null ? 0 : this.familyName.getEstimatedSize()) + (this.viewConstant == null ? 0 : 24 + this.viewConstant.length);
    }

    @Override
    public PName getName() {
        return this.name;
    }

    @Override
    public PName getFamilyName() {
        return this.familyName;
    }

    @Override
    public PDataType getDataType() {
        return this.dataType;
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public String getExpressionStr() {
        return this.expressionStr;
    }

    @Override
    public boolean isNullable() {
        return this.nullable || this.familyName != null;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String toString() {
        return (this.familyName == null ? "" : this.familyName.toString() + ".") + this.name.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.familyName == null ? 0 : this.familyName.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PColumn)) {
            return false;
        }
        PColumn other = (PColumn)obj;
        if (this.familyName == null ? other.getFamilyName() != null : !this.familyName.equals(other.getFamilyName())) {
            return false;
        }
        return !(this.name == null ? other.getName() != null : !this.name.equals(other.getName()));
    }

    @Override
    public Integer getArraySize() {
        return this.arraySize;
    }

    @Override
    public byte[] getViewConstant() {
        return this.viewConstant;
    }

    @Override
    public boolean isViewReferenced() {
        return this.isViewReferenced;
    }

    @Override
    public boolean isRowTimestamp() {
        return this.isRowTimestamp;
    }

    @Override
    public boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    public byte[] getColumnQualifierBytes() {
        if (!SchemaUtil.isPKColumn(this) && this.columnQualifierBytes == null) {
            return this.name.getBytes();
        }
        return this.columnQualifierBytes;
    }

    public static PColumn createFromProto(PTableProtos.PColumn column) {
        byte[] columnNameBytes = column.getColumnNameBytes().toByteArray();
        PName columnName = PNameFactory.newName(columnNameBytes);
        PName familyName = null;
        if (column.hasFamilyNameBytes()) {
            familyName = PNameFactory.newName(column.getFamilyNameBytes().toByteArray());
        }
        PDataType dataType = PDataType.fromSqlTypeName(column.getDataType());
        Integer maxLength = null;
        if (column.hasMaxLength()) {
            maxLength = column.getMaxLength();
        }
        Integer scale = null;
        if (column.hasScale()) {
            scale = column.getScale();
        }
        boolean nullable = column.getNullable();
        int position = column.getPosition();
        SortOrder sortOrder = SortOrder.fromSystemValue(column.getSortOrder());
        Integer arraySize = null;
        if (column.hasArraySize()) {
            arraySize = column.getArraySize();
        }
        byte[] viewConstant = null;
        if (column.hasViewConstant()) {
            viewConstant = column.getViewConstant().toByteArray();
        }
        boolean isViewReferenced = false;
        if (column.hasViewReferenced()) {
            isViewReferenced = column.getViewReferenced();
        }
        String expressionStr = null;
        if (column.hasExpression()) {
            expressionStr = column.getExpression();
        }
        boolean isRowTimestamp = column.getIsRowTimestamp();
        boolean isDynamic = false;
        if (column.hasIsDynamic()) {
            isDynamic = column.getIsDynamic();
        }
        byte[] columnQualifierBytes = null;
        if (column.hasColumnQualifierBytes()) {
            columnQualifierBytes = column.getColumnQualifierBytes().toByteArray();
        }
        return new PColumnImpl(columnName, familyName, dataType, maxLength, scale, nullable, position, sortOrder, arraySize, viewConstant, isViewReferenced, expressionStr, isRowTimestamp, isDynamic, columnQualifierBytes);
    }

    public static PTableProtos.PColumn toProto(PColumn column) {
        PTableProtos.PColumn.Builder builder = PTableProtos.PColumn.newBuilder();
        builder.setColumnNameBytes(ByteStringer.wrap((byte[])column.getName().getBytes()));
        if (column.getFamilyName() != null) {
            builder.setFamilyNameBytes(ByteStringer.wrap((byte[])column.getFamilyName().getBytes()));
        }
        builder.setDataType(column.getDataType().getSqlTypeName());
        if (column.getMaxLength() != null) {
            builder.setMaxLength(column.getMaxLength());
        }
        if (column.getScale() != null) {
            builder.setScale(column.getScale());
        }
        builder.setNullable(column.isNullable());
        builder.setPosition(column.getPosition());
        builder.setSortOrder(column.getSortOrder().getSystemValue());
        if (column.getArraySize() != null) {
            builder.setArraySize(column.getArraySize());
        }
        if (column.getViewConstant() != null) {
            builder.setViewConstant(ByteStringer.wrap((byte[])column.getViewConstant()));
        }
        builder.setViewReferenced(column.isViewReferenced());
        if (column.getExpressionStr() != null) {
            builder.setExpression(column.getExpressionStr());
        }
        builder.setIsRowTimestamp(column.isRowTimestamp());
        if (column.getColumnQualifierBytes() != null) {
            builder.setColumnQualifierBytes(ByteStringer.wrap((byte[])column.getColumnQualifierBytes()));
        }
        return builder.build();
    }
}

