/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import javax.annotation.Nonnull;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.exception.DataExceedsCapacityException;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.SingleCellConstructorExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ConstraintViolationException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PColumnFamilyImpl;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDouble;
import org.apache.phoenix.schema.types.PFloat;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.SizedUtil;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class PTableImpl
implements PTable {
    private static final Integer NO_SALTING = -1;
    private PTableKey key;
    private PName name;
    private PName schemaName = PName.EMPTY_NAME;
    private PName tableName = PName.EMPTY_NAME;
    private PName tenantId;
    private PTableType type;
    private PIndexState state;
    private long sequenceNumber;
    private long timeStamp;
    private long indexDisableTimestamp;
    private List<PColumn> pkColumns;
    private List<PColumn> allColumns;
    private List<PColumnFamily> families;
    private Map<byte[], PColumnFamily> familyByBytes;
    private Map<String, PColumnFamily> familyByString;
    private ListMultimap<String, PColumn> columnsByName;
    private Map<KVColumnFamilyQualifier, PColumn> kvColumnsByQualifiers;
    private PName pkName;
    private Integer bucketNum;
    private RowKeySchema rowKeySchema;
    private List<PTable> indexes;
    private PName parentName;
    private PName parentSchemaName;
    private PName parentTableName;
    private List<PName> physicalNames;
    private boolean isImmutableRows;
    private IndexMaintainer indexMaintainer;
    private ImmutableBytesWritable indexMaintainersPtr;
    private PName defaultFamilyName;
    private String viewStatement;
    private boolean disableWAL;
    private boolean multiTenant;
    private boolean storeNulls;
    private boolean isTransactional;
    private PTable.ViewType viewType;
    private Short viewIndexId;
    private int estimatedSize;
    private PTable.IndexType indexType;
    private int baseColumnCount;
    private boolean rowKeyOrderOptimizable;
    private boolean hasColumnsRequiringUpgrade;
    private int rowTimestampColPos;
    private long updateCacheFrequency;
    private boolean isNamespaceMapped;
    private String autoPartitionSeqName;
    private boolean isAppendOnlySchema;
    private PTable.ImmutableStorageScheme immutableStorageScheme;
    private PTable.QualifierEncodingScheme qualifierEncodingScheme;
    private PTable.EncodedCQCounter encodedCQCounter;
    private boolean useStatsForParallelization;

    public PTableImpl() {
        this.indexes = Collections.emptyList();
        this.physicalNames = Collections.emptyList();
        this.rowKeySchema = RowKeySchema.EMPTY_SCHEMA;
    }

    public PTableImpl(PName tenantId, String schemaName, String tableName, long timestamp, List<PColumnFamily> families, boolean isNamespaceMapped) {
        Preconditions.checkArgument((tenantId == null || tenantId.getBytes().length > 0 ? 1 : 0) != 0);
        this.tenantId = tenantId;
        this.name = PNameFactory.newName(SchemaUtil.getTableName(schemaName, tableName));
        this.key = new PTableKey(tenantId, this.name.getString());
        this.schemaName = PNameFactory.newName(schemaName);
        this.tableName = PNameFactory.newName(tableName);
        this.type = PTableType.VIEW;
        this.viewType = PTable.ViewType.MAPPED;
        this.timeStamp = timestamp;
        this.allColumns = Collections.emptyList();
        this.pkColumns = this.allColumns;
        this.rowKeySchema = RowKeySchema.EMPTY_SCHEMA;
        this.indexes = Collections.emptyList();
        this.familyByBytes = Maps.newHashMapWithExpectedSize((int)families.size());
        this.familyByString = Maps.newHashMapWithExpectedSize((int)families.size());
        for (PColumnFamily family : families) {
            this.familyByBytes.put(family.getName().getBytes(), family);
            this.familyByString.put(family.getName().getString(), family);
        }
        this.families = families;
        this.physicalNames = Collections.emptyList();
        this.isNamespaceMapped = isNamespaceMapped;
    }

    public PTableImpl(PName tenantId, String schemaName, String tableName, long timestamp, List<PColumnFamily> families, boolean isNamespaceMapped, PTable.ImmutableStorageScheme storageScheme, PTable.QualifierEncodingScheme encodingScheme, boolean useStatsForParallelization) {
        Preconditions.checkArgument((tenantId == null || tenantId.getBytes().length > 0 ? 1 : 0) != 0);
        this.tenantId = tenantId;
        this.name = PNameFactory.newName(SchemaUtil.getTableName(schemaName, tableName));
        this.key = new PTableKey(tenantId, this.name.getString());
        this.schemaName = PNameFactory.newName(schemaName);
        this.tableName = PNameFactory.newName(tableName);
        this.type = PTableType.VIEW;
        this.viewType = PTable.ViewType.MAPPED;
        this.timeStamp = timestamp;
        this.allColumns = Collections.emptyList();
        this.pkColumns = this.allColumns;
        this.rowKeySchema = RowKeySchema.EMPTY_SCHEMA;
        this.indexes = Collections.emptyList();
        this.familyByBytes = Maps.newHashMapWithExpectedSize((int)families.size());
        this.familyByString = Maps.newHashMapWithExpectedSize((int)families.size());
        for (PColumnFamily family : families) {
            this.familyByBytes.put(family.getName().getBytes(), family);
            this.familyByString.put(family.getName().getString(), family);
        }
        this.families = families;
        this.physicalNames = Collections.emptyList();
        this.isNamespaceMapped = isNamespaceMapped;
        this.immutableStorageScheme = storageScheme;
        this.qualifierEncodingScheme = encodingScheme;
        this.useStatsForParallelization = useStatsForParallelization;
    }

    public PTableImpl(PName tenantId, PName schemaName, PName tableName, long timestamp, List<PColumnFamily> families, List<PColumn> columns, List<PName> physicalNames, Short viewIndexId, boolean multiTenant, boolean isNamespaceMpped, PTable.ImmutableStorageScheme storageScheme, PTable.QualifierEncodingScheme qualifierEncodingScheme, PTable.EncodedCQCounter encodedCQCounter, boolean useStatsForParallelization) throws SQLException {
        this.allColumns = Collections.emptyList();
        this.pkColumns = this.allColumns;
        this.rowKeySchema = RowKeySchema.EMPTY_SCHEMA;
        this.indexes = Collections.emptyList();
        this.familyByBytes = Maps.newHashMapWithExpectedSize((int)families.size());
        this.familyByString = Maps.newHashMapWithExpectedSize((int)families.size());
        for (PColumnFamily family : families) {
            this.familyByBytes.put(family.getName().getBytes(), family);
            this.familyByString.put(family.getName().getString(), family);
        }
        this.families = families;
        this.init(tenantId, this.schemaName, this.tableName, PTableType.INDEX, this.state, this.timeStamp, this.sequenceNumber, this.pkName, this.bucketNum, columns, this.schemaName, this.parentTableName, this.indexes, this.isImmutableRows, physicalNames, this.defaultFamilyName, null, this.disableWAL, multiTenant, this.storeNulls, this.viewType, viewIndexId, this.indexType, this.baseColumnCount, this.rowKeyOrderOptimizable, this.isTransactional, this.updateCacheFrequency, this.indexDisableTimestamp, isNamespaceMpped, null, false, storageScheme, qualifierEncodingScheme, encodedCQCounter, useStatsForParallelization);
    }

    public PTableImpl(long timeStamp) {
        this(timeStamp, false);
    }

    public PTableImpl(long timeStamp, boolean isIndex) {
        if (isIndex) {
            this.type = PTableType.INDEX;
            this.state = PIndexState.INACTIVE;
        } else {
            this.type = PTableType.TABLE;
        }
        this.timeStamp = timeStamp;
        this.allColumns = Collections.emptyList();
        this.pkColumns = this.allColumns;
        this.families = Collections.emptyList();
        this.familyByBytes = Collections.emptyMap();
        this.familyByString = Collections.emptyMap();
        this.rowKeySchema = RowKeySchema.EMPTY_SCHEMA;
        this.indexes = Collections.emptyList();
        this.physicalNames = Collections.emptyList();
    }

    public static List<PColumn> getColumnsToClone(PTable table) {
        return table.getBucketNum() == null ? table.getColumns() : table.getColumns().subList(1, table.getColumns().size());
    }

    public static PTableImpl makePTable(PTable table, long timeStamp, List<PTable> indexes) throws SQLException {
        return PTableImpl.makePTable(table, timeStamp, indexes, table.getParentSchemaName(), table.getViewStatement());
    }

    public static PTable makePTable(PTable index, PName indexName, String viewStatement, long updateCacheFrequency, PName tenantId) throws SQLException {
        return Objects.equal((Object)viewStatement, (Object)index.getViewStatement()) ? index : PTableImpl.makePTable(index, indexName, index.getTimeStamp(), Lists.newArrayList((Object[])new PName[]{index.getPhysicalName()}), index.getIndexes(), viewStatement, updateCacheFrequency, tenantId);
    }

    public static PTableImpl makePTable(PTable table, PName tableName, long timeStamp, List<PName> physicalNames, List<PTable> indexes, String viewStatement, long updateCacheFrequency, PName tenantId) throws SQLException {
        return new PTableImpl(tenantId, table.getSchemaName(), tableName, table.getType(), table.getIndexState(), timeStamp, table.getSequenceNumber(), table.getPKName(), table.getBucketNum(), PTableImpl.getColumnsToClone(table), table.getParentSchemaName(), table.getParentTableName(), indexes, table.isImmutableRows(), physicalNames, table.getDefaultFamilyName(), viewStatement, table.isWALDisabled(), table.isMultiTenant(), table.getStoreNulls(), table.getViewType(), table.getViewIndexId(), table.getIndexType(), table.getBaseColumnCount(), table.rowKeyOrderOptimizable(), table.isTransactional(), updateCacheFrequency, table.getIndexDisableTimestamp(), table.isNamespaceMapped(), table.getAutoPartitionSeqName(), table.isAppendOnlySchema(), table.getImmutableStorageScheme(), table.getEncodingScheme(), table.getEncodedCQCounter(), table.useStatsForParallelization());
    }

    public static PTableImpl makePTable(PTable table, long timeStamp, List<PTable> indexes, PName parentSchemaName, String viewStatement) throws SQLException {
        return new PTableImpl(table.getTenantId(), table.getSchemaName(), table.getTableName(), table.getType(), table.getIndexState(), timeStamp, table.getSequenceNumber(), table.getPKName(), table.getBucketNum(), PTableImpl.getColumnsToClone(table), parentSchemaName, table.getParentTableName(), indexes, table.isImmutableRows(), table.getPhysicalNames(), table.getDefaultFamilyName(), viewStatement, table.isWALDisabled(), table.isMultiTenant(), table.getStoreNulls(), table.getViewType(), table.getViewIndexId(), table.getIndexType(), table.getBaseColumnCount(), table.rowKeyOrderOptimizable(), table.isTransactional(), table.getUpdateCacheFrequency(), table.getIndexDisableTimestamp(), table.isNamespaceMapped(), table.getAutoPartitionSeqName(), table.isAppendOnlySchema(), table.getImmutableStorageScheme(), table.getEncodingScheme(), table.getEncodedCQCounter(), table.useStatsForParallelization());
    }

    public static PTableImpl makePTable(PTable table, Collection<PColumn> columns) throws SQLException {
        return new PTableImpl(table.getTenantId(), table.getSchemaName(), table.getTableName(), table.getType(), table.getIndexState(), table.getTimeStamp(), table.getSequenceNumber(), table.getPKName(), table.getBucketNum(), columns, table.getParentSchemaName(), table.getParentTableName(), table.getIndexes(), table.isImmutableRows(), table.getPhysicalNames(), table.getDefaultFamilyName(), table.getViewStatement(), table.isWALDisabled(), table.isMultiTenant(), table.getStoreNulls(), table.getViewType(), table.getViewIndexId(), table.getIndexType(), table.getBaseColumnCount(), table.rowKeyOrderOptimizable(), table.isTransactional(), table.getUpdateCacheFrequency(), table.getIndexDisableTimestamp(), table.isNamespaceMapped(), table.getAutoPartitionSeqName(), table.isAppendOnlySchema(), table.getImmutableStorageScheme(), table.getEncodingScheme(), table.getEncodedCQCounter(), table.useStatsForParallelization());
    }

    public static PTableImpl makePTable(PTable table, Collection<PColumn> columns, PName defaultFamily) throws SQLException {
        return new PTableImpl(table.getTenantId(), table.getSchemaName(), table.getTableName(), table.getType(), table.getIndexState(), table.getTimeStamp(), table.getSequenceNumber(), table.getPKName(), table.getBucketNum(), columns, table.getParentSchemaName(), table.getParentTableName(), table.getIndexes(), table.isImmutableRows(), table.getPhysicalNames(), defaultFamily, table.getViewStatement(), table.isWALDisabled(), table.isMultiTenant(), table.getStoreNulls(), table.getViewType(), table.getViewIndexId(), table.getIndexType(), table.getBaseColumnCount(), table.rowKeyOrderOptimizable(), table.isTransactional(), table.getUpdateCacheFrequency(), table.getIndexDisableTimestamp(), table.isNamespaceMapped(), table.getAutoPartitionSeqName(), table.isAppendOnlySchema(), table.getImmutableStorageScheme(), table.getEncodingScheme(), table.getEncodedCQCounter(), table.useStatsForParallelization());
    }

    public static PTableImpl makePTable(PTable table, long timeStamp, long sequenceNumber, Collection<PColumn> columns) throws SQLException {
        return new PTableImpl(table.getTenantId(), table.getSchemaName(), table.getTableName(), table.getType(), table.getIndexState(), timeStamp, sequenceNumber, table.getPKName(), table.getBucketNum(), columns, table.getParentSchemaName(), table.getParentTableName(), table.getIndexes(), table.isImmutableRows(), table.getPhysicalNames(), table.getDefaultFamilyName(), table.getViewStatement(), table.isWALDisabled(), table.isMultiTenant(), table.getStoreNulls(), table.getViewType(), table.getViewIndexId(), table.getIndexType(), table.getBaseColumnCount(), table.rowKeyOrderOptimizable(), table.isTransactional(), table.getUpdateCacheFrequency(), table.getIndexDisableTimestamp(), table.isNamespaceMapped(), table.getAutoPartitionSeqName(), table.isAppendOnlySchema(), table.getImmutableStorageScheme(), table.getEncodingScheme(), table.getEncodedCQCounter(), table.useStatsForParallelization());
    }

    public static PTableImpl makePTable(PTable table, long timeStamp, long sequenceNumber, Collection<PColumn> columns, boolean isImmutableRows) throws SQLException {
        return new PTableImpl(table.getTenantId(), table.getSchemaName(), table.getTableName(), table.getType(), table.getIndexState(), timeStamp, sequenceNumber, table.getPKName(), table.getBucketNum(), columns, table.getParentSchemaName(), table.getParentTableName(), table.getIndexes(), isImmutableRows, table.getPhysicalNames(), table.getDefaultFamilyName(), table.getViewStatement(), table.isWALDisabled(), table.isMultiTenant(), table.getStoreNulls(), table.getViewType(), table.getViewIndexId(), table.getIndexType(), table.getBaseColumnCount(), table.rowKeyOrderOptimizable(), table.isTransactional(), table.getUpdateCacheFrequency(), table.getIndexDisableTimestamp(), table.isNamespaceMapped(), table.getAutoPartitionSeqName(), table.isAppendOnlySchema(), table.getImmutableStorageScheme(), table.getEncodingScheme(), table.getEncodedCQCounter(), table.useStatsForParallelization());
    }

    public static PTableImpl makePTable(PTable table, long timeStamp, long sequenceNumber, Collection<PColumn> columns, boolean isImmutableRows, boolean isWalDisabled, boolean isMultitenant, boolean storeNulls, boolean isTransactional, long updateCacheFrequency, boolean isNamespaceMapped) throws SQLException {
        return new PTableImpl(table.getTenantId(), table.getSchemaName(), table.getTableName(), table.getType(), table.getIndexState(), timeStamp, sequenceNumber, table.getPKName(), table.getBucketNum(), columns, table.getParentSchemaName(), table.getParentTableName(), table.getIndexes(), isImmutableRows, table.getPhysicalNames(), table.getDefaultFamilyName(), table.getViewStatement(), isWalDisabled, isMultitenant, storeNulls, table.getViewType(), table.getViewIndexId(), table.getIndexType(), table.getBaseColumnCount(), table.rowKeyOrderOptimizable(), isTransactional, updateCacheFrequency, table.getIndexDisableTimestamp(), isNamespaceMapped, table.getAutoPartitionSeqName(), table.isAppendOnlySchema(), table.getImmutableStorageScheme(), table.getEncodingScheme(), table.getEncodedCQCounter(), table.useStatsForParallelization());
    }

    public static PTableImpl makePTable(PTable table, PIndexState state2) throws SQLException {
        return new PTableImpl(table.getTenantId(), table.getSchemaName(), table.getTableName(), table.getType(), state2, table.getTimeStamp(), table.getSequenceNumber(), table.getPKName(), table.getBucketNum(), PTableImpl.getColumnsToClone(table), table.getParentSchemaName(), table.getParentTableName(), table.getIndexes(), table.isImmutableRows(), table.getPhysicalNames(), table.getDefaultFamilyName(), table.getViewStatement(), table.isWALDisabled(), table.isMultiTenant(), table.getStoreNulls(), table.getViewType(), table.getViewIndexId(), table.getIndexType(), table.getBaseColumnCount(), table.rowKeyOrderOptimizable(), table.isTransactional(), table.getUpdateCacheFrequency(), table.getIndexDisableTimestamp(), table.isNamespaceMapped(), table.getAutoPartitionSeqName(), table.isAppendOnlySchema(), table.getImmutableStorageScheme(), table.getEncodingScheme(), table.getEncodedCQCounter(), table.useStatsForParallelization());
    }

    public static PTableImpl makePTable(PTable table, boolean rowKeyOrderOptimizable) throws SQLException {
        return new PTableImpl(table.getTenantId(), table.getSchemaName(), table.getTableName(), table.getType(), table.getIndexState(), table.getTimeStamp(), table.getSequenceNumber(), table.getPKName(), table.getBucketNum(), PTableImpl.getColumnsToClone(table), table.getParentSchemaName(), table.getParentTableName(), table.getIndexes(), table.isImmutableRows(), table.getPhysicalNames(), table.getDefaultFamilyName(), table.getViewStatement(), table.isWALDisabled(), table.isMultiTenant(), table.getStoreNulls(), table.getViewType(), table.getViewIndexId(), table.getIndexType(), table.getBaseColumnCount(), rowKeyOrderOptimizable, table.isTransactional(), table.getUpdateCacheFrequency(), table.getIndexDisableTimestamp(), table.isNamespaceMapped(), table.getAutoPartitionSeqName(), table.isAppendOnlySchema(), table.getImmutableStorageScheme(), table.getEncodingScheme(), table.getEncodedCQCounter(), table.useStatsForParallelization());
    }

    public static PTableImpl makePTable(PTable table) throws SQLException {
        return new PTableImpl(table.getTenantId(), table.getSchemaName(), table.getTableName(), table.getType(), table.getIndexState(), table.getTimeStamp(), table.getSequenceNumber(), table.getPKName(), table.getBucketNum(), PTableImpl.getColumnsToClone(table), table.getParentSchemaName(), table.getParentTableName(), table.getIndexes(), table.isImmutableRows(), table.getPhysicalNames(), table.getDefaultFamilyName(), table.getViewStatement(), table.isWALDisabled(), table.isMultiTenant(), table.getStoreNulls(), table.getViewType(), table.getViewIndexId(), table.getIndexType(), table.getBaseColumnCount(), table.rowKeyOrderOptimizable(), table.isTransactional(), table.getUpdateCacheFrequency(), table.getIndexDisableTimestamp(), table.isNamespaceMapped(), table.getAutoPartitionSeqName(), table.isAppendOnlySchema(), table.getImmutableStorageScheme(), table.getEncodingScheme(), table.getEncodedCQCounter(), table.useStatsForParallelization());
    }

    public static PTableImpl makePTable(PName tenantId, PName schemaName, PName tableName, PTableType type, PIndexState state2, long timeStamp, long sequenceNumber, PName pkName, Integer bucketNum, Collection<PColumn> columns, PName dataSchemaName, PName dataTableName, List<PTable> indexes, boolean isImmutableRows, List<PName> physicalNames, PName defaultFamilyName, String viewExpression, boolean disableWAL, boolean multiTenant, boolean storeNulls, PTable.ViewType viewType, Short viewIndexId, PTable.IndexType indexType, boolean rowKeyOrderOptimizable, boolean isTransactional, long updateCacheFrequency, long indexDisableTimestamp, boolean isNamespaceMapped, String autoPartitionSeqName, boolean isAppendOnlySchema, PTable.ImmutableStorageScheme storageScheme, PTable.QualifierEncodingScheme qualifierEncodingScheme, PTable.EncodedCQCounter encodedCQCounter, boolean useStatsForParallelization) throws SQLException {
        return new PTableImpl(tenantId, schemaName, tableName, type, state2, timeStamp, sequenceNumber, pkName, bucketNum, columns, dataSchemaName, dataTableName, indexes, isImmutableRows, physicalNames, defaultFamilyName, viewExpression, disableWAL, multiTenant, storeNulls, viewType, viewIndexId, indexType, -1, rowKeyOrderOptimizable, isTransactional, updateCacheFrequency, indexDisableTimestamp, isNamespaceMapped, autoPartitionSeqName, isAppendOnlySchema, storageScheme, qualifierEncodingScheme, encodedCQCounter, useStatsForParallelization);
    }

    public static PTableImpl makePTable(PName tenantId, PName schemaName, PName tableName, PTableType type, PIndexState state2, long timeStamp, long sequenceNumber, PName pkName, Integer bucketNum, Collection<PColumn> columns, PName dataSchemaName, PName dataTableName, List<PTable> indexes, boolean isImmutableRows, List<PName> physicalNames, PName defaultFamilyName, String viewExpression, boolean disableWAL, boolean multiTenant, boolean storeNulls, PTable.ViewType viewType, Short viewIndexId, PTable.IndexType indexType, boolean rowKeyOrderOptimizable, boolean isTransactional, long updateCacheFrequency, int baseColumnCount, long indexDisableTimestamp, boolean isNamespaceMapped, String autoPartitionSeqName, boolean isAppendOnlySchema, PTable.ImmutableStorageScheme storageScheme, PTable.QualifierEncodingScheme qualifierEncodingScheme, PTable.EncodedCQCounter encodedCQCounter, boolean useStatsForParallelization) throws SQLException {
        return new PTableImpl(tenantId, schemaName, tableName, type, state2, timeStamp, sequenceNumber, pkName, bucketNum, columns, dataSchemaName, dataTableName, indexes, isImmutableRows, physicalNames, defaultFamilyName, viewExpression, disableWAL, multiTenant, storeNulls, viewType, viewIndexId, indexType, baseColumnCount, rowKeyOrderOptimizable, isTransactional, updateCacheFrequency, indexDisableTimestamp, isNamespaceMapped, autoPartitionSeqName, isAppendOnlySchema, storageScheme, qualifierEncodingScheme, encodedCQCounter, useStatsForParallelization);
    }

    private PTableImpl(PName tenantId, PName schemaName, PName tableName, PTableType type, PIndexState state2, long timeStamp, long sequenceNumber, PName pkName, Integer bucketNum, Collection<PColumn> columns, PName parentSchemaName, PName parentTableName, List<PTable> indexes, boolean isImmutableRows, List<PName> physicalNames, PName defaultFamilyName, String viewExpression, boolean disableWAL, boolean multiTenant, boolean storeNulls, PTable.ViewType viewType, Short viewIndexId, PTable.IndexType indexType, int baseColumnCount, boolean rowKeyOrderOptimizable, boolean isTransactional, long updateCacheFrequency, long indexDisableTimestamp, boolean isNamespaceMapped, String autoPartitionSeqName, boolean isAppendOnlySchema, PTable.ImmutableStorageScheme storageScheme, PTable.QualifierEncodingScheme qualifierEncodingScheme, PTable.EncodedCQCounter encodedCQCounter, boolean useStatsForParallelization) throws SQLException {
        this.init(tenantId, schemaName, tableName, type, state2, timeStamp, sequenceNumber, pkName, bucketNum, columns, parentSchemaName, parentTableName, indexes, isImmutableRows, physicalNames, defaultFamilyName, viewExpression, disableWAL, multiTenant, storeNulls, viewType, viewIndexId, indexType, baseColumnCount, rowKeyOrderOptimizable, isTransactional, updateCacheFrequency, indexDisableTimestamp, isNamespaceMapped, autoPartitionSeqName, isAppendOnlySchema, storageScheme, qualifierEncodingScheme, encodedCQCounter, useStatsForParallelization);
    }

    @Override
    public long getUpdateCacheFrequency() {
        return this.updateCacheFrequency;
    }

    @Override
    public boolean isMultiTenant() {
        return this.multiTenant;
    }

    @Override
    public boolean getStoreNulls() {
        return this.storeNulls;
    }

    @Override
    public PTable.ViewType getViewType() {
        return this.viewType;
    }

    @Override
    public int getEstimatedSize() {
        return this.estimatedSize;
    }

    private void init(PName tenantId, PName schemaName, PName tableName, PTableType type, PIndexState state2, long timeStamp, long sequenceNumber, PName pkName, Integer bucketNum, Collection<PColumn> columns, PName parentSchemaName, PName parentTableName, List<PTable> indexes, boolean isImmutableRows, List<PName> physicalNames, PName defaultFamilyName, String viewExpression, boolean disableWAL, boolean multiTenant, boolean storeNulls, PTable.ViewType viewType, Short viewIndexId, PTable.IndexType indexType, int baseColumnCount, boolean rowKeyOrderOptimizable, boolean isTransactional, long updateCacheFrequency, long indexDisableTimestamp, boolean isNamespaceMapped, String autoPartitionSeqName, boolean isAppendOnlySchema, PTable.ImmutableStorageScheme storageScheme, PTable.QualifierEncodingScheme qualifierEncodingScheme, PTable.EncodedCQCounter encodedCQCounter, boolean useStatsForParallelization) throws SQLException {
        ArrayList pkColumns;
        Object[] allColumns;
        Preconditions.checkNotNull((Object)schemaName);
        Preconditions.checkArgument((tenantId == null || tenantId.getBytes().length > 0 ? 1 : 0) != 0);
        int estimatedSize = 288 + PNameFactory.getEstimatedSize(tenantId) + PNameFactory.getEstimatedSize(schemaName) + PNameFactory.getEstimatedSize(tableName) + PNameFactory.getEstimatedSize(pkName) + PNameFactory.getEstimatedSize(parentTableName) + PNameFactory.getEstimatedSize(defaultFamilyName);
        this.tenantId = tenantId;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.name = PNameFactory.newName(SchemaUtil.getTableName(schemaName.getString(), tableName.getString()));
        this.key = new PTableKey(tenantId, this.name.getString());
        this.type = type;
        this.state = state2;
        this.timeStamp = timeStamp;
        this.indexDisableTimestamp = indexDisableTimestamp;
        this.sequenceNumber = sequenceNumber;
        this.pkName = pkName;
        this.isImmutableRows = isImmutableRows;
        this.defaultFamilyName = defaultFamilyName;
        this.viewStatement = viewExpression;
        this.disableWAL = disableWAL;
        this.multiTenant = multiTenant;
        this.storeNulls = storeNulls;
        this.viewType = viewType;
        this.viewIndexId = viewIndexId;
        this.indexType = indexType;
        this.isTransactional = isTransactional;
        this.rowKeyOrderOptimizable = rowKeyOrderOptimizable;
        this.updateCacheFrequency = updateCacheFrequency;
        this.isNamespaceMapped = isNamespaceMapped;
        this.autoPartitionSeqName = autoPartitionSeqName;
        this.isAppendOnlySchema = isAppendOnlySchema;
        this.immutableStorageScheme = storageScheme == null ? PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : storageScheme;
        this.qualifierEncodingScheme = qualifierEncodingScheme == null ? PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS : qualifierEncodingScheme;
        this.columnsByName = ArrayListMultimap.create((int)columns.size(), (int)1);
        this.kvColumnsByQualifiers = Maps.newHashMapWithExpectedSize((int)columns.size());
        int numPKColumns = 0;
        if (bucketNum != null) {
            allColumns = new PColumn[columns.size() + 1];
            allColumns[SaltingUtil.SALTING_COLUMN.getPosition()] = SaltingUtil.SALTING_COLUMN;
            pkColumns = Lists.newArrayListWithExpectedSize((int)(columns.size() + 1));
            ++numPKColumns;
        } else {
            allColumns = new PColumn[columns.size()];
            pkColumns = Lists.newArrayListWithExpectedSize((int)columns.size());
        }
        Iterator<PColumn> i$ = columns.iterator();
        while (i$.hasNext()) {
            String columnName;
            PColumn column;
            allColumns[column.getPosition()] = column = i$.next();
            PName familyName = column.getFamilyName();
            if (familyName == null) {
                ++numPKColumns;
            }
            if (this.columnsByName.put((Object)(columnName = column.getName().getString()), (Object)column)) {
                int count = 0;
                for (PColumn dupColumn : this.columnsByName.get((Object)columnName)) {
                    if (!Objects.equal((Object)familyName, (Object)dupColumn.getFamilyName()) || ++count <= 1) continue;
                    throw new ColumnAlreadyExistsException(schemaName.getString(), this.name.getString(), columnName);
                }
            }
            byte[] cq = column.getColumnQualifierBytes();
            String cf = column.getFamilyName() != null ? column.getFamilyName().getString() : null;
            if (cf == null || cq == null) continue;
            KVColumnFamilyQualifier info = new KVColumnFamilyQualifier(cf, cq);
            if (this.kvColumnsByQualifiers.get(info) != null) {
                throw new ColumnAlreadyExistsException(schemaName.getString(), this.name.getString(), columnName);
            }
            this.kvColumnsByQualifiers.put(info, column);
        }
        estimatedSize = (int)((long)estimatedSize + SizedUtil.sizeOfMap(allColumns.length, 8, SizedUtil.sizeOfArrayList(1)));
        this.bucketNum = bucketNum;
        this.allColumns = ImmutableList.copyOf((Object[])allColumns);
        estimatedSize = (int)((long)estimatedSize + (SizedUtil.sizeOfMap(numPKColumns) + SizedUtil.sizeOfMap(allColumns.length)));
        RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(numPKColumns);
        int maxExpectedSize = allColumns.length - numPKColumns;
        LinkedHashMap familyMap = Maps.newLinkedHashMap();
        Object rowTimestampCol = null;
        for (Object column : allColumns) {
            PName familyName = column.getFamilyName();
            if (familyName == null) {
                this.hasColumnsRequiringUpgrade |= column.getSortOrder() == SortOrder.DESC && (!column.getDataType().isFixedWidth() || column.getDataType() == PChar.INSTANCE || column.getDataType() == PFloat.INSTANCE || column.getDataType() == PDouble.INSTANCE || column.getDataType() == PBinary.INSTANCE) || column.getSortOrder() == SortOrder.ASC && column.getDataType() == PBinary.INSTANCE && column.getMaxLength() != null && column.getMaxLength() > 1;
                pkColumns.add(column);
                if (column.isRowTimestamp()) {
                    rowTimestampCol = column;
                }
            }
            if (familyName == null) {
                estimatedSize += column.getEstimatedSize();
                builder.addField((PDatum)column, column.isNullable(), column.getSortOrder());
                continue;
            }
            List columnsInFamily = (List)familyMap.get(familyName);
            if (columnsInFamily == null) {
                columnsInFamily = Lists.newArrayListWithExpectedSize((int)maxExpectedSize);
                familyMap.put(familyName, columnsInFamily);
            }
            columnsInFamily.add(column);
        }
        this.pkColumns = ImmutableList.copyOf((Collection)pkColumns);
        this.rowTimestampColPos = rowTimestampCol != null ? this.pkColumns.indexOf(rowTimestampCol) : -1;
        builder.rowKeyOrderOptimizable(this.rowKeyOrderOptimizable());
        this.rowKeySchema = builder.build();
        estimatedSize += this.rowKeySchema.getEstimatedSize();
        Iterator iterator = familyMap.entrySet().iterator();
        Object[] families = new PColumnFamily[familyMap.size()];
        ImmutableMap.Builder familyByString = ImmutableMap.builder();
        ImmutableSortedMap.Builder familyByBytes = ImmutableSortedMap.orderedBy((Comparator)Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < families.length; ++i) {
            Map.Entry entry = iterator.next();
            PColumnFamilyImpl family = new PColumnFamilyImpl((PName)entry.getKey(), (List)entry.getValue());
            families[i] = family;
            familyByString.put((Object)family.getName().getString(), (Object)family);
            familyByBytes.put((Object)family.getName().getBytes(), (Object)family);
            estimatedSize += family.getEstimatedSize();
        }
        this.families = ImmutableList.copyOf((Object[])families);
        this.familyByBytes = familyByBytes.build();
        this.familyByString = familyByString.build();
        estimatedSize += SizedUtil.sizeOfArrayList(families.length);
        estimatedSize = (int)((long)estimatedSize + SizedUtil.sizeOfMap(families.length) * 2L);
        this.indexes = indexes == null ? Collections.emptyList() : indexes;
        for (PTable index : this.indexes) {
            estimatedSize += index.getEstimatedSize();
        }
        this.parentSchemaName = parentSchemaName;
        this.parentTableName = parentTableName;
        this.parentName = parentTableName == null ? null : PNameFactory.newName(SchemaUtil.getTableName(parentSchemaName != null ? parentSchemaName.getString() : null, parentTableName.getString()));
        estimatedSize += PNameFactory.getEstimatedSize(this.parentName);
        this.physicalNames = physicalNames == null ? ImmutableList.of() : ImmutableList.copyOf(physicalNames);
        for (PName name : this.physicalNames) {
            estimatedSize += name.getEstimatedSize();
        }
        this.estimatedSize = estimatedSize;
        this.baseColumnCount = baseColumnCount;
        this.encodedCQCounter = encodedCQCounter;
        this.useStatsForParallelization = useStatsForParallelization;
    }

    @Override
    public boolean isImmutableRows() {
        return this.isImmutableRows;
    }

    public String toString() {
        return this.name.getString();
    }

    @Override
    public List<PColumn> getPKColumns() {
        return this.pkColumns;
    }

    @Override
    public final PName getName() {
        return this.name;
    }

    @Override
    public final PName getSchemaName() {
        return this.schemaName;
    }

    @Override
    public final PName getTableName() {
        return this.tableName;
    }

    @Override
    public final PTableType getType() {
        return this.type;
    }

    @Override
    public final List<PColumnFamily> getColumnFamilies() {
        return this.families;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int newKey(ImmutableBytesWritable key, byte[][] values) {
        int nValues;
        List<PColumn> columns = this.getPKColumns();
        for (nValues = values.length; nValues > 0 && (values[nValues - 1] == null || values[nValues - 1].length == 0); --nValues) {
        }
        for (PColumn column : columns) {
            if (column.getExpressionStr() == null) continue;
            ++nValues;
        }
        int i = 0;
        TrustedByteArrayOutputStream os = new TrustedByteArrayOutputStream(SchemaUtil.estimateKeyLength(this));
        try {
            PColumn column;
            Integer bucketNum = this.getBucketNum();
            if (bucketNum != null) {
                ++i;
                os.write(QueryConstants.SEPARATOR_BYTE_ARRAY);
            }
            int nColumns = columns.size();
            PDataType type = null;
            SortOrder sortOrder = null;
            boolean wasNull = false;
            while (i < nValues && i < nColumns) {
                byte[] byteValue;
                if (type != null && !type.isFixedWidth()) {
                    os.write(SchemaUtil.getSeparatorByte(this.rowKeyOrderOptimizable(), wasNull, sortOrder));
                }
                column = columns.get(i);
                sortOrder = column.getSortOrder();
                type = column.getDataType();
                if ((byteValue = values[i++]) == null) {
                    if (column.getExpressionStr() != null) {
                        try {
                            String url = "jdbc:phoenix:none";
                            PhoenixConnection conn = DriverManager.getConnection(url).unwrap(PhoenixConnection.class);
                            StatementContext context = new StatementContext(new PhoenixStatement(conn));
                            ExpressionCompiler compiler = new ExpressionCompiler(context);
                            ParseNode defaultParseNode = new SQLParser(column.getExpressionStr()).parseExpression();
                            Expression defaultExpression = defaultParseNode.accept(compiler);
                            defaultExpression.evaluate(null, key);
                            column.getDataType().coerceBytes(key, null, defaultExpression.getDataType(), defaultExpression.getMaxLength(), defaultExpression.getScale(), defaultExpression.getSortOrder(), column.getMaxLength(), column.getScale(), column.getSortOrder());
                            byteValue = ByteUtil.copyKeyBytesIfNecessary(key);
                        }
                        catch (SQLException e) {
                            throw new ConstraintViolationException(this.name.getString() + "." + column.getName().getString() + " failed to compile default value expression of " + column.getExpressionStr());
                        }
                    } else {
                        byteValue = ByteUtil.EMPTY_BYTE_ARRAY;
                    }
                }
                boolean bl = wasNull = byteValue.length == 0;
                if (byteValue.length == 0 && !column.isNullable()) {
                    throw new ConstraintViolationException(this.name.getString() + "." + column.getName().getString() + " may not be null");
                }
                Integer maxLength = column.getMaxLength();
                Integer scale = column.getScale();
                key.set(byteValue);
                if (!type.isSizeCompatible(key, null, type, sortOrder, null, null, maxLength, scale)) {
                    throw new DataExceedsCapacityException(this.name.getString() + "." + column.getName().getString() + " may not exceed " + maxLength + " (" + SchemaUtil.toString(type, byteValue) + ")");
                }
                key.set(byteValue);
                type.pad(key, maxLength, sortOrder);
                byteValue = ByteUtil.copyKeyBytesIfNecessary(key);
                os.write(byteValue, 0, byteValue.length);
            }
            if (type != null && !type.isFixedWidth() && SchemaUtil.getSeparatorByte(this.rowKeyOrderOptimizable(), wasNull, sortOrder) == QueryConstants.DESC_SEPARATOR_BYTE) {
                os.write(QueryConstants.DESC_SEPARATOR_BYTE);
            }
            if (i < nColumns && ((column = columns.get(i)).getDataType().isFixedWidth() || !column.isNullable())) {
                throw new ConstraintViolationException(this.name.getString() + "." + column.getName().getString() + " may not be null");
            }
            if (nValues == 0) {
                throw new ConstraintViolationException("Primary key may not be null (" + this.name.getString() + ")");
            }
            byte[] buf = os.getBuffer();
            int size = os.size();
            if (bucketNum != null) {
                buf[0] = SaltingUtil.getSaltingByte(buf, 1, size - 1, bucketNum);
            }
            key.set(buf, 0, size);
            int n = i;
            return n;
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private PRow newRow(KeyValueBuilder builder, long ts, ImmutableBytesWritable key, int i, boolean hasOnDupKey, byte[] ... values) {
        PRowImpl row = new PRowImpl(builder, key, ts, this.getBucketNum(), hasOnDupKey);
        if (i < values.length) {
            for (PColumnFamily family : this.getColumnFamilies()) {
                for (PColumn column : family.getColumns()) {
                    row.setValue(column, values[i++]);
                    if (i != values.length) continue;
                    return row;
                }
            }
        }
        return row;
    }

    @Override
    public PRow newRow(KeyValueBuilder builder, long ts, ImmutableBytesWritable key, boolean hasOnDupKey, byte[] ... values) {
        return this.newRow(builder, ts, key, 0, hasOnDupKey, values);
    }

    @Override
    public PRow newRow(KeyValueBuilder builder, ImmutableBytesWritable key, boolean hasOnDupKey, byte[] ... values) {
        return this.newRow(builder, Long.MAX_VALUE, key, hasOnDupKey, values);
    }

    @Override
    public PColumn getColumnForColumnName(String name) throws ColumnNotFoundException, AmbiguousColumnException {
        List columns = this.columnsByName.get((Object)name);
        int size = columns.size();
        if (size == 0) {
            String schemaNameStr = this.schemaName == null ? null : this.schemaName.getString();
            String tableNameStr = this.tableName == null ? null : this.tableName.getString();
            throw new ColumnNotFoundException(schemaNameStr, tableNameStr, null, name);
        }
        if (size > 1) {
            for (PColumn column : columns) {
                if (column.getFamilyName() != null && !"0".equals(column.getFamilyName().getString())) continue;
                return column;
            }
            throw new AmbiguousColumnException(name);
        }
        return (PColumn)columns.get(0);
    }

    @Override
    public PColumn getColumnForColumnQualifier(byte[] cf, byte[] cq) throws ColumnNotFoundException, AmbiguousColumnException {
        Preconditions.checkNotNull((Object)cq);
        if (!EncodedColumnsUtil.usesEncodedColumnNames(this) || cf == null) {
            String columnName = (String)PVarchar.INSTANCE.toObject(cq);
            return this.getColumnForColumnName(columnName);
        }
        String family = (String)PVarchar.INSTANCE.toObject(cf);
        PColumn col = this.kvColumnsByQualifiers.get(new KVColumnFamilyQualifier(family, cq));
        if (col == null) {
            String schemaNameStr = this.schemaName == null ? null : this.schemaName.getString();
            String tableNameStr = this.tableName == null ? null : this.tableName.getString();
            throw new ColumnNotFoundException(schemaNameStr, tableNameStr, null, "No column found for column qualifier " + this.qualifierEncodingScheme.decode(cq));
        }
        return col;
    }

    @Override
    public PColumnFamily getColumnFamily(String familyName) throws ColumnFamilyNotFoundException {
        PColumnFamily family = this.familyByString.get(familyName);
        if (family == null) {
            String schemaNameStr = this.schemaName == null ? null : this.schemaName.getString();
            String tableNameStr = this.tableName == null ? null : this.tableName.getString();
            throw new ColumnFamilyNotFoundException(schemaNameStr, tableNameStr, familyName);
        }
        return family;
    }

    @Override
    public PColumnFamily getColumnFamily(byte[] familyBytes) throws ColumnFamilyNotFoundException {
        PColumnFamily family = this.familyByBytes.get(familyBytes);
        if (family == null) {
            String familyName = Bytes.toString((byte[])familyBytes);
            String schemaNameStr = this.schemaName == null ? null : this.schemaName.getString();
            String tableNameStr = this.tableName == null ? null : this.tableName.getString();
            throw new ColumnFamilyNotFoundException(schemaNameStr, tableNameStr, familyName);
        }
        return family;
    }

    @Override
    public List<PColumn> getColumns() {
        return this.allColumns;
    }

    @Override
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public long getIndexDisableTimestamp() {
        return this.indexDisableTimestamp;
    }

    @Override
    public PColumn getPKColumn(String name) throws ColumnNotFoundException {
        List columns = this.columnsByName.get((Object)name);
        int size = columns.size();
        if (size == 0) {
            String schemaNameStr = this.schemaName == null ? null : this.schemaName.getString();
            String tableNameStr = this.tableName == null ? null : this.tableName.getString();
            throw new ColumnNotFoundException(schemaNameStr, tableNameStr, null, name);
        }
        if (size > 1) {
            do {
                PColumn column;
                if ((column = (PColumn)columns.get(--size)).getFamilyName() != null) continue;
                return column;
            } while (size > 0);
            String schemaNameStr = this.schemaName == null ? null : this.schemaName.getString();
            String tableNameStr = this.tableName == null ? null : this.tableName.getString();
            throw new ColumnNotFoundException(schemaNameStr, tableNameStr, null, name);
        }
        return (PColumn)columns.get(0);
    }

    @Override
    public PName getPKName() {
        return this.pkName;
    }

    @Override
    public RowKeySchema getRowKeySchema() {
        return this.rowKeySchema;
    }

    @Override
    public Integer getBucketNum() {
        return this.bucketNum;
    }

    @Override
    public List<PTable> getIndexes() {
        return this.indexes;
    }

    @Override
    public PIndexState getIndexState() {
        return this.state;
    }

    @Override
    public PName getParentTableName() {
        return this.type != PTableType.VIEW || this.parentName != null ? this.parentTableName : PNameFactory.newName(SchemaUtil.getTableNameFromFullName(this.getPhysicalName().getBytes()));
    }

    @Override
    public PName getParentName() {
        return this.type != PTableType.VIEW || this.parentName != null ? this.parentName : this.getPhysicalName();
    }

    @Override
    public synchronized IndexMaintainer getIndexMaintainer(PTable dataTable, PhoenixConnection connection) {
        if (this.indexMaintainer == null) {
            this.indexMaintainer = IndexMaintainer.create(dataTable, this, connection);
        }
        return this.indexMaintainer;
    }

    @Override
    public synchronized boolean getIndexMaintainers(ImmutableBytesWritable ptr, PhoenixConnection connection) {
        if (this.indexMaintainersPtr == null || this.indexMaintainersPtr.getLength() == 0) {
            this.indexMaintainersPtr = new ImmutableBytesWritable();
            if (this.indexes.isEmpty()) {
                this.indexMaintainersPtr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            } else {
                IndexMaintainer.serialize(this, this.indexMaintainersPtr, connection);
            }
        }
        ptr.set(this.indexMaintainersPtr.get(), this.indexMaintainersPtr.getOffset(), this.indexMaintainersPtr.getLength());
        return this.indexMaintainersPtr.getLength() > 0;
    }

    @Override
    public PName getPhysicalName() {
        if (this.physicalNames.isEmpty()) {
            return SchemaUtil.getPhysicalHBaseTableName(this.schemaName, this.tableName, this.isNamespaceMapped);
        }
        return PNameFactory.newName(this.physicalNames.get(0).getBytes());
    }

    @Override
    public List<PName> getPhysicalNames() {
        return this.physicalNames;
    }

    @Override
    public PName getDefaultFamilyName() {
        return this.defaultFamilyName;
    }

    @Override
    public String getViewStatement() {
        return this.viewStatement;
    }

    @Override
    public boolean isWALDisabled() {
        return this.disableWAL;
    }

    @Override
    public Short getViewIndexId() {
        return this.viewIndexId;
    }

    @Override
    public PName getTenantId() {
        return this.tenantId;
    }

    @Override
    public PTable.IndexType getIndexType() {
        return this.indexType;
    }

    public static PTable createFromProto(PTableProtos.PTable table) {
        PName tenantId = null;
        if (table.hasTenantId()) {
            tenantId = PNameFactory.newName(table.getTenantId().toByteArray());
        }
        PName schemaName = PNameFactory.newName(table.getSchemaNameBytes().toByteArray());
        PName tableName = PNameFactory.newName(table.getTableNameBytes().toByteArray());
        PTableType tableType = PTableType.values()[table.getTableType().ordinal()];
        PIndexState indexState = null;
        if (table.hasIndexState()) {
            indexState = PIndexState.fromSerializedValue(table.getIndexState());
        }
        Short viewIndexId = null;
        if (table.hasViewIndexId()) {
            viewIndexId = (short)table.getViewIndexId();
        }
        PTable.IndexType indexType = PTable.IndexType.getDefault();
        if (table.hasIndexType()) {
            indexType = PTable.IndexType.fromSerializedValue(table.getIndexType().toByteArray()[0]);
        }
        long sequenceNumber = table.getSequenceNumber();
        long timeStamp = table.getTimeStamp();
        long indexDisableTimestamp = table.getIndexDisableTimestamp();
        PName pkName = null;
        if (table.hasPkNameBytes()) {
            pkName = PNameFactory.newName(table.getPkNameBytes().toByteArray());
        }
        int bucketNum = table.getBucketNum();
        ArrayList columns = Lists.newArrayListWithExpectedSize((int)table.getColumnsCount());
        for (PTableProtos.PColumn curPColumnProto : table.getColumnsList()) {
            columns.add(PColumnImpl.createFromProto(curPColumnProto));
        }
        ArrayList indexes = Lists.newArrayListWithExpectedSize((int)table.getIndexesCount());
        for (PTableProtos.PTable curPTableProto : table.getIndexesList()) {
            indexes.add(PTableImpl.createFromProto(curPTableProto));
        }
        boolean isImmutableRows = table.getIsImmutableRows();
        PName parentSchemaName = null;
        PName parentTableName = null;
        if (table.hasParentNameBytes()) {
            parentSchemaName = PNameFactory.newName(SchemaUtil.getSchemaNameFromFullName(table.getParentNameBytes().toByteArray()));
            parentTableName = PNameFactory.newName(SchemaUtil.getTableNameFromFullName(table.getParentNameBytes().toByteArray()));
        }
        PName defaultFamilyName = null;
        if (table.hasDefaultFamilyName()) {
            defaultFamilyName = PNameFactory.newName(table.getDefaultFamilyName().toByteArray());
        }
        boolean disableWAL = table.getDisableWAL();
        boolean multiTenant = table.getMultiTenant();
        boolean storeNulls = table.getStoreNulls();
        boolean isTransactional = table.getTransactional();
        PTable.ViewType viewType = null;
        String viewStatement = null;
        ArrayList physicalNames = Collections.emptyList();
        if (tableType == PTableType.VIEW) {
            viewType = PTable.ViewType.fromSerializedValue(table.getViewType().toByteArray()[0]);
        }
        if (table.hasViewStatement()) {
            viewStatement = (String)PVarchar.INSTANCE.toObject(table.getViewStatement().toByteArray());
        }
        if (tableType == PTableType.VIEW || viewIndexId != null) {
            physicalNames = Lists.newArrayListWithExpectedSize((int)table.getPhysicalNamesCount());
            for (int i = 0; i < table.getPhysicalNamesCount(); ++i) {
                physicalNames.add(PNameFactory.newName(table.getPhysicalNames(i).toByteArray()));
            }
        }
        int baseColumnCount = -1;
        if (table.hasBaseColumnCount()) {
            baseColumnCount = table.getBaseColumnCount();
        }
        boolean rowKeyOrderOptimizable = false;
        if (table.hasRowKeyOrderOptimizable()) {
            rowKeyOrderOptimizable = table.getRowKeyOrderOptimizable();
        }
        long updateCacheFrequency = 0L;
        if (table.hasUpdateCacheFrequency()) {
            updateCacheFrequency = table.getUpdateCacheFrequency();
        }
        boolean isNamespaceMapped = false;
        if (table.hasIsNamespaceMapped()) {
            isNamespaceMapped = table.getIsNamespaceMapped();
        }
        String autoParititonSeqName = null;
        if (table.hasAutoParititonSeqName()) {
            autoParititonSeqName = table.getAutoParititonSeqName();
        }
        boolean isAppendOnlySchema = false;
        if (table.hasIsAppendOnlySchema()) {
            isAppendOnlySchema = table.getIsAppendOnlySchema();
        }
        PTable.ImmutableStorageScheme storageScheme = PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN;
        if (table.hasStorageScheme()) {
            storageScheme = PTable.ImmutableStorageScheme.fromSerializedValue(table.getStorageScheme().toByteArray()[0]);
        }
        PTable.QualifierEncodingScheme qualifierEncodingScheme = PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS;
        if (table.hasEncodingScheme()) {
            qualifierEncodingScheme = PTable.QualifierEncodingScheme.fromSerializedValue(table.getEncodingScheme().toByteArray()[0]);
        }
        PTable.EncodedCQCounter encodedColumnQualifierCounter = null;
        if (!EncodedColumnsUtil.usesEncodedColumnNames(qualifierEncodingScheme) || tableType == PTableType.VIEW) {
            encodedColumnQualifierCounter = PTable.EncodedCQCounter.NULL_COUNTER;
        } else {
            encodedColumnQualifierCounter = new PTable.EncodedCQCounter();
            if (table.getEncodedCQCountersList() != null) {
                for (PTableProtos.EncodedCQCounter cqCounterFromProto : table.getEncodedCQCountersList()) {
                    encodedColumnQualifierCounter.setValue(cqCounterFromProto.getColFamily(), cqCounterFromProto.getCounter());
                }
            }
        }
        boolean useStatsForParallelization = true;
        if (table.hasUseStatsForParallelization()) {
            useStatsForParallelization = table.getUseStatsForParallelization();
        }
        try {
            PTableImpl result = new PTableImpl();
            result.init(tenantId, schemaName, tableName, tableType, indexState, timeStamp, sequenceNumber, pkName, bucketNum == NO_SALTING ? null : Integer.valueOf(bucketNum), columns, parentSchemaName, parentTableName, indexes, isImmutableRows, physicalNames, defaultFamilyName, viewStatement, disableWAL, multiTenant, storeNulls, viewType, viewIndexId, indexType, baseColumnCount, rowKeyOrderOptimizable, isTransactional, updateCacheFrequency, indexDisableTimestamp, isNamespaceMapped, autoParititonSeqName, isAppendOnlySchema, storageScheme, qualifierEncodingScheme, encodedColumnQualifierCounter, useStatsForParallelization);
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static PTableProtos.PTable toProto(PTable table) {
        PTableProtos.PTable.Builder builder = PTableProtos.PTable.newBuilder();
        if (table.getTenantId() != null) {
            builder.setTenantId(ByteStringer.wrap((byte[])table.getTenantId().getBytes()));
        }
        builder.setSchemaNameBytes(ByteStringer.wrap((byte[])table.getSchemaName().getBytes()));
        builder.setTableNameBytes(ByteStringer.wrap((byte[])table.getTableName().getBytes()));
        builder.setTableType(ProtobufUtil.toPTableTypeProto(table.getType()));
        if (table.getType() == PTableType.INDEX) {
            if (table.getIndexState() != null) {
                builder.setIndexState(table.getIndexState().getSerializedValue());
            }
            if (table.getViewIndexId() != null) {
                builder.setViewIndexId(table.getViewIndexId().shortValue());
            }
            if (table.getIndexType() != null) {
                builder.setIndexType(ByteStringer.wrap((byte[])new byte[]{table.getIndexType().getSerializedValue()}));
            }
        }
        builder.setSequenceNumber(table.getSequenceNumber());
        builder.setTimeStamp(table.getTimeStamp());
        PName tmp = table.getPKName();
        if (tmp != null) {
            builder.setPkNameBytes(ByteStringer.wrap((byte[])tmp.getBytes()));
        }
        Integer bucketNum = table.getBucketNum();
        int offset = 0;
        if (bucketNum == null) {
            builder.setBucketNum(NO_SALTING);
        } else {
            offset = 1;
            builder.setBucketNum(bucketNum);
        }
        List<PColumn> columns = table.getColumns();
        int columnSize = columns.size();
        for (int i = offset; i < columnSize; ++i) {
            PColumn column = columns.get(i);
            builder.addColumns(PColumnImpl.toProto(column));
        }
        List<PTable> indexes = table.getIndexes();
        for (PTable curIndex : indexes) {
            builder.addIndexes(PTableImpl.toProto(curIndex));
        }
        builder.setIsImmutableRows(table.isImmutableRows());
        if (table.getParentName() != null) {
            builder.setDataTableNameBytes(ByteStringer.wrap((byte[])table.getParentTableName().getBytes()));
        }
        if (table.getParentName() != null) {
            builder.setParentNameBytes(ByteStringer.wrap((byte[])table.getParentName().getBytes()));
        }
        if (table.getDefaultFamilyName() != null) {
            builder.setDefaultFamilyName(ByteStringer.wrap((byte[])table.getDefaultFamilyName().getBytes()));
        }
        builder.setDisableWAL(table.isWALDisabled());
        builder.setMultiTenant(table.isMultiTenant());
        builder.setStoreNulls(table.getStoreNulls());
        builder.setTransactional(table.isTransactional());
        if (table.getType() == PTableType.VIEW) {
            builder.setViewType(ByteStringer.wrap((byte[])new byte[]{table.getViewType().getSerializedValue()}));
        }
        if (table.getViewStatement() != null) {
            builder.setViewStatement(ByteStringer.wrap((byte[])PVarchar.INSTANCE.toBytes(table.getViewStatement())));
        }
        if (table.getType() == PTableType.VIEW || table.getViewIndexId() != null) {
            for (int i = 0; i < table.getPhysicalNames().size(); ++i) {
                builder.addPhysicalNames(ByteStringer.wrap((byte[])table.getPhysicalNames().get(i).getBytes()));
            }
        }
        builder.setBaseColumnCount(table.getBaseColumnCount());
        builder.setRowKeyOrderOptimizable(table.rowKeyOrderOptimizable());
        builder.setUpdateCacheFrequency(table.getUpdateCacheFrequency());
        builder.setIndexDisableTimestamp(table.getIndexDisableTimestamp());
        builder.setIsNamespaceMapped(table.isNamespaceMapped());
        if (table.getAutoPartitionSeqName() != null) {
            builder.setAutoParititonSeqName(table.getAutoPartitionSeqName());
        }
        builder.setIsAppendOnlySchema(table.isAppendOnlySchema());
        if (table.getImmutableStorageScheme() != null) {
            builder.setStorageScheme(ByteStringer.wrap((byte[])new byte[]{table.getImmutableStorageScheme().getSerializedMetadataValue()}));
        }
        if (table.getEncodedCQCounter() != null) {
            Map<String, Integer> values = table.getEncodedCQCounter().values();
            for (Map.Entry<String, Integer> cqCounter : values.entrySet()) {
                PTableProtos.EncodedCQCounter.Builder cqBuilder = PTableProtos.EncodedCQCounter.newBuilder();
                cqBuilder.setColFamily(cqCounter.getKey());
                cqBuilder.setCounter(cqCounter.getValue());
                builder.addEncodedCQCounters(cqBuilder.build());
            }
        }
        if (table.getEncodingScheme() != null) {
            builder.setEncodingScheme(ByteStringer.wrap((byte[])new byte[]{table.getEncodingScheme().getSerializedMetadataValue()}));
        }
        builder.setUseStatsForParallelization(table.useStatsForParallelization());
        return builder.build();
    }

    @Override
    public PTableKey getKey() {
        return this.key;
    }

    @Override
    public PName getParentSchemaName() {
        return this.type != PTableType.VIEW || this.parentName != null ? this.parentSchemaName : PNameFactory.newName(SchemaUtil.getSchemaNameFromFullName(this.getPhysicalName().getBytes()));
    }

    @Override
    public boolean isTransactional() {
        return this.isTransactional;
    }

    @Override
    public int getBaseColumnCount() {
        return this.baseColumnCount;
    }

    @Override
    public boolean rowKeyOrderOptimizable() {
        return this.rowKeyOrderOptimizable || !this.hasColumnsRequiringUpgrade;
    }

    @Override
    public int getRowTimestampColPos() {
        return this.rowTimestampColPos;
    }

    @Override
    public boolean isNamespaceMapped() {
        return this.isNamespaceMapped;
    }

    @Override
    public String getAutoPartitionSeqName() {
        return this.autoPartitionSeqName;
    }

    @Override
    public boolean isAppendOnlySchema() {
        return this.isAppendOnlySchema;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PTable)) {
            return false;
        }
        PTable other = (PTable)obj;
        return !(this.key == null ? other.getKey() != null : !this.key.equals(other.getKey()));
    }

    @Override
    public PTable.ImmutableStorageScheme getImmutableStorageScheme() {
        return this.immutableStorageScheme;
    }

    @Override
    public PTable.EncodedCQCounter getEncodedCQCounter() {
        return this.encodedCQCounter;
    }

    @Override
    public PTable.QualifierEncodingScheme getEncodingScheme() {
        return this.qualifierEncodingScheme;
    }

    @Override
    public boolean useStatsForParallelization() {
        return this.useStatsForParallelization;
    }

    private static final class KVColumnFamilyQualifier {
        @Nonnull
        private final String colFamilyName;
        @Nonnull
        private final byte[] colQualifier;

        public KVColumnFamilyQualifier(String colFamilyName, byte[] colQualifier) {
            Preconditions.checkArgument((colFamilyName != null && colQualifier != null ? 1 : 0) != 0, (Object)"None of the arguments, column family name or column qualifier can be null");
            this.colFamilyName = colFamilyName;
            this.colQualifier = colQualifier;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.colFamilyName.hashCode();
            result = 31 * result + Arrays.hashCode(this.colQualifier);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KVColumnFamilyQualifier other = (KVColumnFamilyQualifier)obj;
            if (!this.colFamilyName.equals(other.colFamilyName)) {
                return false;
            }
            return Arrays.equals(this.colQualifier, other.colQualifier);
        }
    }

    private class PRowImpl
    implements PRow {
        private final byte[] key;
        private final ImmutableBytesWritable keyPtr;
        private final KeyValueBuilder kvBuilder;
        private Mutation setValues;
        private Delete unsetValues;
        private Mutation deleteRow;
        private final long ts;
        private final boolean hasOnDupKey;
        private Map<PColumn, byte[]> columnToValueMap;

        public PRowImpl(KeyValueBuilder kvBuilder, ImmutableBytesWritable key, long ts, Integer bucketNum, boolean hasOnDupKey) {
            this.kvBuilder = kvBuilder;
            this.ts = ts;
            this.hasOnDupKey = hasOnDupKey;
            if (bucketNum != null) {
                this.key = SaltingUtil.getSaltedKey(key, bucketNum);
                this.keyPtr = new ImmutableBytesPtr(this.key);
            } else {
                this.keyPtr = new ImmutableBytesPtr(key);
                this.key = ByteUtil.copyKeyBytesIfNecessary(key);
            }
            this.columnToValueMap = Maps.newHashMapWithExpectedSize((int)1);
            this.newMutations();
        }

        private void newMutations() {
            Increment put = this.hasOnDupKey ? new Increment(this.key) : new Put(this.key);
            Delete delete = new Delete(this.key);
            if (PTableImpl.this.isWALDisabled()) {
                put.setDurability(Durability.SKIP_WAL);
                delete.setDurability(Durability.SKIP_WAL);
            }
            this.setValues = put;
            this.unsetValues = delete;
        }

        @Override
        public List<Mutation> toRowMutations() {
            ArrayList<Mutation> mutations = new ArrayList<Mutation>(3);
            if (this.deleteRow != null) {
                mutations.add(this.deleteRow);
            } else {
                if (PTableImpl.this.immutableStorageScheme != null && PTableImpl.this.immutableStorageScheme != PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN) {
                    Put put = new Put(this.key);
                    if (PTableImpl.this.isWALDisabled()) {
                        put.setDurability(Durability.SKIP_WAL);
                    }
                    for (PColumnFamily family : PTableImpl.this.families) {
                        byte[] columnFamily = family.getName().getBytes();
                        Collection<PColumn> columns = family.getColumns();
                        int maxEncodedColumnQualifier = Integer.MIN_VALUE;
                        for (PColumn column : columns) {
                            int qualifier = PTableImpl.this.qualifierEncodingScheme.decode(column.getColumnQualifierBytes());
                            maxEncodedColumnQualifier = Math.max(maxEncodedColumnQualifier, qualifier);
                        }
                        Expression[] colValues = EncodedColumnsUtil.createColumnExpressionArray(maxEncodedColumnQualifier);
                        for (PColumn column : columns) {
                            if (!this.columnToValueMap.containsKey(column)) continue;
                            int colIndex = PTableImpl.this.qualifierEncodingScheme.decode(column.getColumnQualifierBytes()) - 11 + 1;
                            colValues[colIndex] = new LiteralExpression(this.columnToValueMap.get(column));
                        }
                        List<Expression> children = Arrays.asList(colValues);
                        SingleCellConstructorExpression singleCellConstructorExpression = new SingleCellConstructorExpression(PTableImpl.this.immutableStorageScheme, children);
                        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                        singleCellConstructorExpression.evaluate(null, ptr);
                        ImmutableBytesPtr colFamilyPtr = new ImmutableBytesPtr(columnFamily);
                        KeyValueBuilder.addQuietly((Mutation)put, this.kvBuilder, this.kvBuilder.buildPut(this.keyPtr, colFamilyPtr, QueryConstants.SINGLE_KEYVALUE_COLUMN_QUALIFIER_BYTES_PTR, this.ts, ptr));
                    }
                    this.setValues = put;
                }
                Pair<byte[], byte[]> emptyKvInfo = EncodedColumnsUtil.getEmptyKeyValueInfo(PTableImpl.this);
                KeyValueBuilder.addQuietly(this.setValues, this.kvBuilder, this.kvBuilder.buildPut(this.keyPtr, SchemaUtil.getEmptyColumnFamilyPtr(PTableImpl.this), new ImmutableBytesPtr((byte[])emptyKvInfo.getFirst()), this.ts, new ImmutableBytesPtr((byte[])emptyKvInfo.getSecond())));
                mutations.add(this.setValues);
                if (!this.unsetValues.isEmpty()) {
                    mutations.add((Mutation)this.unsetValues);
                }
            }
            return mutations;
        }

        private void removeIfPresent(Mutation m, byte[] family, byte[] qualifier) {
            NavigableMap familyMap = m.getFamilyCellMap();
            List kvs = (List)familyMap.get(family);
            if (kvs != null) {
                Iterator iterator = kvs.iterator();
                while (iterator.hasNext()) {
                    Cell kv = (Cell)iterator.next();
                    if (Bytes.compareTo((byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength(), (byte[])qualifier, (int)0, (int)qualifier.length) != 0) continue;
                    iterator.remove();
                    break;
                }
            }
        }

        @Override
        public void setValue(PColumn column, byte[] byteValue) {
            boolean isNull;
            this.deleteRow = null;
            byte[] family = column.getFamilyName().getBytes();
            byte[] qualifier = column.getColumnQualifierBytes();
            ImmutableBytesPtr qualifierPtr = new ImmutableBytesPtr(qualifier);
            PDataType type = column.getDataType();
            if (byteValue == null) {
                byteValue = ByteUtil.EMPTY_BYTE_ARRAY;
            }
            if ((isNull = type.isNull(byteValue)) && !column.isNullable()) {
                throw new ConstraintViolationException(PTableImpl.this.name.getString() + "." + column.getName().getString() + " may not be null");
            }
            if (isNull && PTableImpl.this.isImmutableRows() && column.getExpressionStr() == null) {
                this.removeIfPresent(this.setValues, family, qualifier);
                this.removeIfPresent((Mutation)this.unsetValues, family, qualifier);
            } else if (isNull && !PTableImpl.this.getStoreNulls() && !this.hasOnDupKey && column.getExpressionStr() == null) {
                this.removeIfPresent(this.setValues, family, qualifier);
                KeyValueBuilder.deleteQuietly(this.unsetValues, this.kvBuilder, this.kvBuilder.buildDeleteColumns(this.keyPtr, column.getFamilyName().getBytesPtr(), qualifierPtr, this.ts));
            } else {
                ImmutableBytesWritable ptr = new ImmutableBytesWritable(byteValue);
                Integer maxLength = column.getMaxLength();
                Integer scale = column.getScale();
                SortOrder sortOrder = column.getSortOrder();
                if (!type.isSizeCompatible(ptr, null, type, sortOrder, null, null, maxLength, scale)) {
                    throw new DataExceedsCapacityException(PTableImpl.this.name.getString() + "." + column.getName().getString() + " may not exceed " + maxLength + " (" + SchemaUtil.toString(type, byteValue) + ")");
                }
                ptr.set(byteValue);
                type.pad(ptr, maxLength, sortOrder);
                this.removeIfPresent((Mutation)this.unsetValues, family, qualifier);
                if (PTableImpl.this.immutableStorageScheme == PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS) {
                    this.columnToValueMap.put(column, ptr.get());
                } else {
                    this.removeIfPresent((Mutation)this.unsetValues, family, qualifier);
                    KeyValueBuilder.addQuietly(this.setValues, this.kvBuilder, this.kvBuilder.buildPut(this.keyPtr, column.getFamilyName().getBytesPtr(), qualifierPtr, this.ts, ptr));
                }
            }
        }

        @Override
        public void delete() {
            this.newMutations();
            if (PTableImpl.this.isTransactional()) {
                Put put = new Put(this.key);
                if (PTableImpl.this.families.isEmpty()) {
                    put.add(SchemaUtil.getEmptyColumnFamily(PTableImpl.this), TransactionFactory.getTransactionFactory().getTransactionContext().getFamilyDeleteMarker(), this.ts, HConstants.EMPTY_BYTE_ARRAY);
                } else {
                    for (PColumnFamily colFamily : PTableImpl.this.families) {
                        put.add(colFamily.getName().getBytes(), TransactionFactory.getTransactionFactory().getTransactionContext().getFamilyDeleteMarker(), this.ts, HConstants.EMPTY_BYTE_ARRAY);
                    }
                }
                this.deleteRow = put;
            } else {
                Delete delete = new Delete(this.key);
                for (PColumnFamily colFamily : PTableImpl.this.families) {
                    delete.deleteFamily(colFamily.getName().getBytes(), this.ts);
                }
                this.deleteRow = delete;
            }
            if (PTableImpl.this.isWALDisabled()) {
                this.deleteRow.setDurability(Durability.SKIP_WAL);
            }
        }
    }
}

