/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.util.SchemaUtil;

public class RowKeySchema
extends ValueSchema {
    public static final RowKeySchema EMPTY_SCHEMA = new RowKeySchema(0, Collections.emptyList(), true);

    public RowKeySchema() {
    }

    protected RowKeySchema(int minNullable, List<ValueSchema.Field> fields, boolean rowKeyOrderOptimizable) {
        super(minNullable, fields, rowKeyOrderOptimizable);
    }

    public boolean rowKeyOrderOptimizable() {
        return this.rowKeyOrderOptimizable;
    }

    public int getMaxFields() {
        return this.getMinNullable();
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Designed to return null.")
    public Boolean iterator(byte[] src, int srcOffset, int srcLength, ImmutableBytesWritable ptr, int position, int extraColumnSpan) {
        Boolean hasValue = null;
        ptr.set(src, srcOffset, 0);
        int maxOffset = srcOffset + srcLength;
        for (int i = 0; i < position; ++i) {
            hasValue = this.next(ptr, i, maxOffset);
        }
        if (extraColumnSpan > 0) {
            this.readExtraFields(ptr, position, maxOffset, extraColumnSpan);
        }
        return hasValue;
    }

    public Boolean iterator(byte[] src, int srcOffset, int srcLength, ImmutableBytesWritable ptr, int position) {
        return this.iterator(src, srcOffset, srcLength, ptr, position, 0);
    }

    public Boolean iterator(ImmutableBytesWritable srcPtr, ImmutableBytesWritable ptr, int position) {
        return this.iterator(srcPtr.get(), srcPtr.getOffset(), srcPtr.getLength(), ptr, position);
    }

    public Boolean iterator(byte[] src, ImmutableBytesWritable ptr, int position) {
        return this.iterator(src, 0, src.length, ptr, position);
    }

    public int iterator(byte[] src, int srcOffset, int srcLength, ImmutableBytesWritable ptr) {
        int maxOffset = srcOffset + srcLength;
        this.iterator(src, srcOffset, srcLength, ptr, 0);
        return maxOffset;
    }

    public int iterator(byte[] src, ImmutableBytesWritable ptr) {
        return this.iterator(src, 0, src.length, ptr);
    }

    public int iterator(ImmutableBytesWritable ptr) {
        return this.iterator(ptr.get(), ptr.getOffset(), ptr.getLength(), ptr);
    }

    public Boolean next(ImmutableBytesWritable ptr, int position, int maxOffset) {
        return this.next(ptr, position, maxOffset, false);
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Designed to return null.")
    private Boolean next(ImmutableBytesWritable ptr, int position, int maxOffset, boolean isFirst) {
        ValueSchema.Field field;
        if (ptr.getOffset() + ptr.getLength() >= maxOffset) {
            ptr.set(ptr.get(), maxOffset, 0);
            return null;
        }
        if (position >= this.getFieldCount()) {
            return null;
        }
        ptr.set(ptr.get(), ptr.getOffset() + ptr.getLength(), 0);
        if (position > 0 && !isFirst && !this.getField(position - 1).getDataType().isFixedWidth()) {
            ptr.set(ptr.get(), ptr.getOffset() + ptr.getLength() + 1, 0);
        }
        if ((field = this.getField(position)).getDataType().isFixedWidth()) {
            ptr.set(ptr.get(), ptr.getOffset(), Math.min(maxOffset - ptr.getOffset(), field.getByteSize()));
        } else if (position + 1 == this.getFieldCount()) {
            int len = maxOffset - ptr.getOffset();
            ptr.set(ptr.get(), ptr.getOffset(), maxOffset - ptr.getOffset() - (SchemaUtil.getSeparatorByte(this.rowKeyOrderOptimizable, len == 0, field) == QueryConstants.DESC_SEPARATOR_BYTE ? 1 : 0));
        } else {
            byte[] buf = ptr.get();
            int offset = ptr.getOffset();
            if (offset < maxOffset && buf[offset] != 0) {
                byte sepByte = SchemaUtil.getSeparatorByte(this.rowKeyOrderOptimizable, false, field);
                while (++offset < maxOffset && buf[offset] != sepByte) {
                }
            }
            ptr.set(buf, ptr.getOffset(), offset - ptr.getOffset());
        }
        return ptr.getLength() > 0;
    }

    public Boolean next(ImmutableBytesWritable ptr, int position, int maxOffset, int extraSpan) {
        Boolean returnValue = this.next(ptr, position, maxOffset);
        this.readExtraFields(ptr, position + 1, maxOffset, extraSpan);
        return returnValue;
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Designed to return null.")
    public Boolean previous(ImmutableBytesWritable ptr, int position, int minOffset) {
        int i;
        int offsetAdjustment;
        if (position < 0) {
            return null;
        }
        ValueSchema.Field field = this.getField(position);
        if (field.getDataType().isFixedWidth()) {
            ptr.set(ptr.get(), ptr.getOffset() - field.getByteSize(), field.getByteSize());
            return true;
        }
        int n = offsetAdjustment = position + 1 == this.getFieldCount() || ptr.getLength() == 0 ? 0 : 1;
        if (position == 0) {
            ptr.set(ptr.get(), minOffset, ptr.getOffset() - minOffset - offsetAdjustment);
            return true;
        }
        field = this.getField(position - 1);
        if (!field.getDataType().isFixedWidth()) {
            byte[] buf = ptr.get();
            int offset = ptr.getOffset() - 1 - offsetAdjustment;
            if (offset > minOffset && buf[offset] != 0) {
                byte sepByte = SchemaUtil.getSeparatorByte(this.rowKeyOrderOptimizable, false, field);
                while (--offset > minOffset && buf[offset] != sepByte) {
                }
            }
            if (offset == minOffset) {
                ptr.set(buf, minOffset, ptr.getOffset() - minOffset - 1);
            } else {
                ptr.set(buf, offset + 1, ptr.getOffset() - 1 - offsetAdjustment - offset);
            }
            return true;
        }
        int fixedOffset = field.getByteSize();
        for (i = position - 2; i >= 0 && this.getField(i).getDataType().isFixedWidth(); --i) {
            fixedOffset += this.getField(i).getByteSize();
        }
        if (i < 0) {
            int length = ptr.getOffset() - fixedOffset - minOffset - offsetAdjustment;
            ptr.set(ptr.get(), minOffset + fixedOffset, length);
            return true;
        }
        return this.iterator(ptr.get(), minOffset, ptr.getOffset() - minOffset - offsetAdjustment, ptr, position + 1);
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Designed to return null.")
    public Boolean reposition(ImmutableBytesWritable ptr, int oldPosition, int newPosition, int minOffset, int maxOffset) {
        if (newPosition == oldPosition) {
            return ptr.getLength() > 0;
        }
        Boolean hasValue = null;
        if (newPosition > oldPosition) {
            while ((hasValue = this.next(ptr, ++oldPosition, maxOffset)) != null && oldPosition < newPosition) {
            }
        } else {
            int nVarLengthFromBeginning = 0;
            for (int i = 0; i <= newPosition; ++i) {
                if (this.getField(i).getDataType().isFixedWidth()) continue;
                ++nVarLengthFromBeginning;
            }
            int nVarLengthBetween = 0;
            for (int i = oldPosition - 1; i >= newPosition; --i) {
                if (this.getField(i).getDataType().isFixedWidth()) continue;
                ++nVarLengthBetween;
            }
            if (nVarLengthBetween > nVarLengthFromBeginning) {
                return this.iterator(ptr.get(), minOffset, maxOffset - minOffset, ptr, newPosition + 1);
            }
            while ((hasValue = this.previous(ptr, --oldPosition, minOffset)) != null && oldPosition > newPosition) {
            }
        }
        return hasValue;
    }

    public Boolean reposition(ImmutableBytesWritable ptr, int oldPosition, int newPosition, int minOffset, int maxOffset, int extraSpan) {
        Boolean returnValue = this.reposition(ptr, oldPosition, newPosition, minOffset, maxOffset);
        this.readExtraFields(ptr, newPosition + 1, maxOffset, extraSpan);
        return returnValue;
    }

    public boolean position(ImmutableBytesWritable ptr, int position, int endPosition) {
        int maxOffset = ptr.getLength();
        this.iterator(ptr);
        boolean isFirst = true;
        while (position <= endPosition) {
            if (this.next(ptr, position++, maxOffset, isFirst) == null) {
                return false;
            }
            isFirst = false;
        }
        return true;
    }

    private void readExtraFields(ImmutableBytesWritable ptr, int position, int maxOffset, int extraSpan) {
        Boolean returnValue;
        int initialOffset = ptr.getOffset();
        for (int i = 0; i < extraSpan && (returnValue = this.next(ptr, position + i, maxOffset)) != null; ++i) {
        }
        int finalLength = ptr.getOffset() - initialOffset + ptr.getLength();
        ptr.set(ptr.get(), initialOffset, finalLength);
    }

    public static class RowKeySchemaBuilder
    extends ValueSchema.ValueSchemaBuilder {
        private boolean rowKeyOrderOptimizable = false;

        public RowKeySchemaBuilder(int maxFields) {
            super(maxFields);
            this.setMaxFields(maxFields);
        }

        @Override
        public RowKeySchemaBuilder addField(PDatum datum, boolean isNullable, SortOrder sortOrder) {
            super.addField(datum, isNullable, sortOrder);
            return this;
        }

        public RowKeySchemaBuilder rowKeyOrderOptimizable(boolean rowKeyOrderOptimizable) {
            this.rowKeyOrderOptimizable = rowKeyOrderOptimizable;
            return this;
        }

        @Override
        public RowKeySchema build() {
            List<ValueSchema.Field> condensedFields = this.buildFields();
            return new RowKeySchema(this.minNullable, condensedFields, this.rowKeyOrderOptimizable);
        }
    }
}

