/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.util.ByteUtil;

public class RowKeyValueAccessor
implements Writable {
    private int index = -1;
    private int[] offsets;
    private boolean isFixedLength;
    private boolean hasSeparator;

    public RowKeyValueAccessor() {
    }

    public RowKeyValueAccessor(List<? extends PDatum> data, int index) {
        this.index = index;
        int[] offsets = new int[data.size()];
        int nOffsets = 0;
        Iterator<? extends PDatum> iterator = data.iterator();
        PDatum datum = iterator.next();
        int pos = 0;
        while (pos < index) {
            int offset = 0;
            if (datum.getDataType().isFixedWidth()) {
                do {
                    Integer maxLength;
                    offset += ((maxLength = datum.getDataType().getByteSize()) == null ? datum.getMaxLength() : maxLength).intValue();
                    datum = iterator.next();
                } while (++pos < index && datum.getDataType().isFixedWidth());
                offsets[nOffsets++] = offset;
                continue;
            }
            do {
                ++offset;
                datum = iterator.next();
            } while (++pos < index && !datum.getDataType().isFixedWidth());
            offsets[nOffsets++] = -offset;
        }
        this.offsets = nOffsets < offsets.length ? Arrays.copyOf(offsets, nOffsets) : offsets;
        this.isFixedLength = datum.getDataType().isFixedWidth();
        this.hasSeparator = !this.isFixedLength && datum != data.get(data.size() - 1);
    }

    RowKeyValueAccessor(int[] offsets, boolean isFixedLength, boolean hasSeparator) {
        this.offsets = offsets;
        this.isFixedLength = isFixedLength;
        this.hasSeparator = hasSeparator;
    }

    public int getIndex() {
        return this.index;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hasSeparator ? 1231 : 1237);
        result = 31 * result + (this.isFixedLength ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.offsets);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RowKeyValueAccessor other = (RowKeyValueAccessor)obj;
        if (this.hasSeparator != other.hasSeparator) {
            return false;
        }
        if (this.isFixedLength != other.isFixedLength) {
            return false;
        }
        return Arrays.equals(this.offsets, other.offsets);
    }

    public String toString() {
        return "RowKeyValueAccessor [offsets=" + Arrays.toString(this.offsets) + ", isFixedLength=" + this.isFixedLength + ", hasSeparator=" + this.hasSeparator + "]";
    }

    public void readFields(DataInput input) throws IOException {
        int length = WritableUtils.readVInt((DataInput)input);
        this.hasSeparator = (length & 2) != 0;
        this.isFixedLength = (length & 1) != 0;
        this.offsets = ByteUtil.deserializeVIntArray(input, length >>= 2);
    }

    public void write(DataOutput output) throws IOException {
        int length = this.offsets.length << 2;
        ByteUtil.serializeVIntArray(output, this.offsets, length |= (this.hasSeparator ? 2 : 0) | (this.isFixedLength ? 1 : 0));
    }

    private static boolean isSeparatorByte(byte b) {
        return b == 0 || b == QueryConstants.DESC_SEPARATOR_BYTE;
    }

    public int getOffset(byte[] keyBuffer, int keyOffset) {
        for (int offset : this.offsets) {
            if (offset >= 0) {
                keyOffset += offset;
                continue;
            }
            while (offset++ < 0) {
                while (keyOffset < keyBuffer.length && !RowKeyValueAccessor.isSeparatorByte(keyBuffer[keyOffset++])) {
                }
            }
        }
        return keyOffset;
    }

    public int getLength(byte[] keyBuffer, int keyOffset, int maxOffset) {
        int offset;
        if (!this.hasSeparator) {
            return maxOffset - keyOffset - (keyBuffer[maxOffset - 1] == QueryConstants.DESC_SEPARATOR_BYTE ? 1 : 0);
        }
        for (offset = keyOffset; offset < maxOffset && !RowKeyValueAccessor.isSeparatorByte(keyBuffer[offset]); ++offset) {
        }
        return offset - keyOffset;
    }
}

