/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ServiceException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.StatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PrefixByteDecoder;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;

public class StatisticsWriter
implements Closeable {
    private final HTableInterface statsWriterTable;
    private final HTableInterface statsReaderTable;
    private final byte[] tableName;
    private final long clientTimeStamp;
    private final long guidePostDepth;

    public static StatisticsWriter newWriter(RegionCoprocessorEnvironment env, String tableName, long clientTimeStamp, long guidePostDepth) throws IOException {
        if (clientTimeStamp == Long.MAX_VALUE) {
            clientTimeStamp = EnvironmentEdgeManager.currentTimeMillis();
        }
        HTableInterface statsWriterTable = env.getTable(SchemaUtil.getPhysicalTableName(PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES, env.getConfiguration()));
        HTableInterface statsReaderTable = ServerUtil.getHTableForCoprocessorScan(env, statsWriterTable);
        StatisticsWriter statsTable = new StatisticsWriter(statsReaderTable, statsWriterTable, tableName, clientTimeStamp, guidePostDepth);
        return statsTable;
    }

    private StatisticsWriter(HTableInterface statsReaderTable, HTableInterface statsWriterTable, String tableName, long clientTimeStamp, long guidePostDepth) {
        this.statsReaderTable = statsReaderTable;
        this.statsWriterTable = statsWriterTable;
        this.tableName = Bytes.toBytes((String)tableName);
        this.clientTimeStamp = clientTimeStamp;
        this.guidePostDepth = guidePostDepth;
    }

    @Override
    public void close() throws IOException {
        this.statsWriterTable.close();
        this.statsReaderTable.close();
    }

    public void addStats(StatisticsCollector tracker, ImmutableBytesPtr cfKey, List<Mutation> mutations) throws IOException {
        GuidePostsInfo gps;
        if (tracker == null) {
            return;
        }
        boolean useMaxTimeStamp = this.clientTimeStamp == -1L;
        long timeStamp = this.clientTimeStamp;
        if (useMaxTimeStamp) {
            timeStamp = tracker.getMaxTimeStamp();
            mutations.add((Mutation)this.getLastStatsUpdatedTimePut(timeStamp));
        }
        if ((gps = tracker.getGuidePosts(cfKey)) != null) {
            boolean hasGuidePosts;
            long[] byteCounts = gps.getByteCounts();
            long[] rowCounts = gps.getRowCounts();
            ImmutableBytesWritable keys = gps.getGuidePosts();
            boolean bl = hasGuidePosts = keys.getLength() > 0;
            if (hasGuidePosts) {
                int guidePostCount = 0;
                try (ByteArrayInputStream stream2 = new ByteArrayInputStream(keys.get(), keys.getOffset(), keys.getLength());){
                    DataInputStream input = new DataInputStream(stream2);
                    PrefixByteDecoder decoder = new PrefixByteDecoder(gps.getMaxLength());
                    do {
                        ImmutableBytesWritable ptr = decoder.decode(input);
                        this.addGuidepost(cfKey, mutations, ptr, byteCounts[guidePostCount], rowCounts[guidePostCount], timeStamp);
                        ++guidePostCount;
                    } while (decoder != null);
                }
                catch (EOFException stream2) {
                    // empty catch block
                }
                byte[] rowKey = StatisticsUtil.getRowKey(this.tableName, (ImmutableBytesWritable)cfKey, ByteUtil.EMPTY_IMMUTABLE_BYTE_ARRAY);
                Delete delete = new Delete(rowKey, timeStamp);
                mutations.add((Mutation)delete);
            } else {
                this.addGuidepost(cfKey, mutations, ByteUtil.EMPTY_IMMUTABLE_BYTE_ARRAY, this.guidePostDepth, 0L, timeStamp);
            }
        }
    }

    private void addGuidepost(ImmutableBytesPtr cfKey, List<Mutation> mutations, ImmutableBytesWritable ptr, long byteCount, long rowCount, long timeStamp) {
        byte[] prefix = StatisticsUtil.getRowKey(this.tableName, (ImmutableBytesWritable)cfKey, ptr);
        Put put = new Put(prefix);
        put.add(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_WIDTH_BYTES, timeStamp, PLong.INSTANCE.toBytes(byteCount));
        put.add(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_ROW_COUNT_BYTES, timeStamp, PLong.INSTANCE.toBytes(rowCount));
        put.add(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, timeStamp, ByteUtil.EMPTY_BYTE_ARRAY);
        mutations.add((Mutation)put);
    }

    private static ClientProtos.MutationProto.MutationType getMutationType(Mutation m) throws IOException {
        if (m instanceof Put) {
            return ClientProtos.MutationProto.MutationType.PUT;
        }
        if (m instanceof Delete) {
            return ClientProtos.MutationProto.MutationType.DELETE;
        }
        throw new DoNotRetryIOException("Unsupported mutation type in stats commit" + m.getClass().getName());
    }

    public void commitStats(List<Mutation> mutations, StatisticsCollector statsCollector) throws IOException {
        this.commitLastStatsUpdatedTime(statsCollector);
        if (mutations.size() > 0) {
            byte[] row = mutations.get(0).getRow();
            MultiRowMutationProtos.MutateRowsRequest.Builder mrmBuilder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
            for (Mutation m : mutations) {
                mrmBuilder.addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)StatisticsWriter.getMutationType(m), (Mutation)m));
            }
            MultiRowMutationProtos.MutateRowsRequest mrm = mrmBuilder.build();
            CoprocessorRpcChannel channel = this.statsWriterTable.coprocessorService(row);
            MultiRowMutationProtos.MultiRowMutationService.BlockingInterface service = MultiRowMutationProtos.MultiRowMutationService.newBlockingStub((BlockingRpcChannel)channel);
            try {
                service.mutateRows(null, mrm);
            }
            catch (ServiceException ex) {
                ProtobufUtil.toIOException((ServiceException)ex);
            }
        }
    }

    private Put getLastStatsUpdatedTimePut(long timeStamp) {
        long currentTime = EnvironmentEdgeManager.currentTimeMillis();
        byte[] prefix = this.tableName;
        Put put = new Put(prefix);
        put.add(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.LAST_STATS_UPDATE_TIME_BYTES, timeStamp, PDate.INSTANCE.toBytes(new Date(currentTime)));
        return put;
    }

    private void commitLastStatsUpdatedTime(StatisticsCollector statsCollector) throws IOException {
        long timeStamp = this.clientTimeStamp == -1L ? statsCollector.getMaxTimeStamp() : this.clientTimeStamp;
        Put put = this.getLastStatsUpdatedTimePut(timeStamp);
        this.statsWriterTable.put(put);
    }

    public void deleteStatsForRegion(Region region, StatisticsCollector tracker, ImmutableBytesPtr fam, List<Mutation> mutations) throws IOException {
        long timeStamp = this.clientTimeStamp == -1L ? tracker.getMaxTimeStamp() : this.clientTimeStamp;
        byte[] startKey = region.getRegionInfo().getStartKey();
        byte[] stopKey = region.getRegionInfo().getEndKey();
        ArrayList<Result> statsForRegion = new ArrayList<Result>();
        Scan s = MetaDataUtil.newTableRowsScan(StatisticsUtil.getAdjustedKey(startKey, this.tableName, fam, false), StatisticsUtil.getAdjustedKey(stopKey, this.tableName, fam, true), 0L, this.clientTimeStamp);
        s.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES);
        try (ResultScanner scanner = this.statsWriterTable.getScanner(s);){
            Result result = null;
            while ((result = scanner.next()) != null) {
                statsForRegion.add(result);
            }
        }
        for (Result result : statsForRegion) {
            mutations.add((Mutation)new Delete(result.getRow(), timeStamp - 1L));
        }
    }
}

