/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.tuple;

import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.hbase.Cell;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;

@NotThreadSafe
public class EncodedColumnQualiferCellsList
implements List<Cell> {
    private int minQualifier;
    private int maxQualifier;
    private int nonReservedRangeOffset;
    private final Cell[] array;
    private int numNonNullElements;
    private int firstNonNullElementIdx = -1;
    private static final int RESERVED_RANGE_SIZE = 11 - QueryConstants.ENCODED_EMPTY_COLUMN_NAME;
    private int modCount = 0;
    private final PTable.QualifierEncodingScheme encodingScheme;

    public EncodedColumnQualiferCellsList(int minQ, int maxQ, PTable.QualifierEncodingScheme encodingScheme) {
        Preconditions.checkArgument((minQ <= maxQ ? 1 : 0) != 0, (Object)("Invalid arguments. Min: " + minQ + ". Max: " + maxQ));
        this.minQualifier = minQ;
        this.maxQualifier = maxQ;
        int size = 0;
        size = maxQ < 11 ? RESERVED_RANGE_SIZE : (minQ < 11 ? maxQ - minQ + 1 : RESERVED_RANGE_SIZE + (maxQ - minQ + 1));
        this.array = new Cell[size];
        this.nonReservedRangeOffset = minQ > 11 ? minQ - 11 : 0;
        this.encodingScheme = encodingScheme;
    }

    @Override
    public int size() {
        return this.numNonNullElements;
    }

    @Override
    public boolean isEmpty() {
        return this.numNonNullElements == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Object[] toArray() {
        Object[] toReturn = new Object[this.numNonNullElements];
        int counter = 0;
        if (this.numNonNullElements > 0) {
            for (int i = 0; i < this.array.length; ++i) {
                if (this.array[i] == null) continue;
                toReturn[counter++] = this.array[i];
            }
        }
        return toReturn;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] toReturn = (Object[])Array.newInstance(a.getClass().getComponentType(), this.numNonNullElements);
        int counter = 0;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            toReturn[counter++] = this.array[i];
        }
        return toReturn;
    }

    @Override
    public boolean add(Cell e) {
        if (e == null) {
            throw new NullPointerException();
        }
        int columnQualifier = this.encodingScheme.decode(e.getQualifierArray(), e.getQualifierOffset(), e.getQualifierLength());
        this.checkQualifierRange(columnQualifier);
        int idx = this.getArrayIndex(columnQualifier);
        if (this.array[idx] == null) {
            ++this.numNonNullElements;
        }
        this.array[idx] = e;
        if (this.firstNonNullElementIdx == -1) {
            this.firstNonNullElementIdx = idx;
        } else if (idx < this.firstNonNullElementIdx) {
            this.firstNonNullElementIdx = idx;
        }
        ++this.modCount;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        Cell e = (Cell)o;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null || !this.array[i].equals(e)) continue;
            this.array[i] = null;
            --this.numNonNullElements;
            if (this.numNonNullElements == 0) {
                this.firstNonNullElementIdx = -1;
            } else if (this.firstNonNullElementIdx == i) {
                while (i < this.array.length && this.array[i] == null) {
                    ++i;
                }
                this.firstNonNullElementIdx = i < this.array.length ? i : -1;
            }
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean containsAll = true;
        Iterator<?> itr = c.iterator();
        while (itr.hasNext()) {
            containsAll &= this.indexOf(itr.next()) >= 0;
        }
        return containsAll;
    }

    @Override
    public boolean addAll(Collection<? extends Cell> c) {
        boolean changed = false;
        for (Cell cell : c) {
            if (c == null) {
                throw new NullPointerException();
            }
            changed |= this.add(cell);
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Cell> c) {
        this.throwGenericUnsupportedOperationException();
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Iterator<?> itr = c.iterator();
        boolean changed = false;
        while (itr.hasNext()) {
            changed |= this.remove(itr.next());
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        if (collection instanceof EncodedColumnQualiferCellsList) {
            EncodedColumnQualiferCellsList list = (EncodedColumnQualiferCellsList)collection;
            ListIterator<Cell> listItr = this.listIterator();
            while (listItr.hasNext()) {
                Cell cellInThis = listItr.next();
                int qualifier = this.encodingScheme.decode(cellInThis.getQualifierArray(), cellInThis.getQualifierOffset(), cellInThis.getQualifierLength());
                try {
                    Cell cellInParam = list.getCellForColumnQualifier(qualifier);
                    if (cellInParam != null && cellInParam.equals(cellInThis)) continue;
                    listItr.remove();
                    changed = true;
                }
                catch (IndexOutOfBoundsException expected) {
                    listItr.remove();
                    changed = true;
                }
            }
        } else {
            throw new UnsupportedOperationException("Operation only supported for collections of type EncodedColumnQualiferCellsList");
        }
        return changed;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = null;
        }
        this.firstNonNullElementIdx = -1;
        this.numNonNullElements = 0;
        ++this.modCount;
    }

    @Override
    public Cell get(int index) {
        this.rangeCheck(index);
        int numNonNullElementsFound = 0;
        for (int i = this.firstNonNullElementIdx; i < this.array.length; ++i) {
            if (this.array[i] == null || ++numNonNullElementsFound != index + 1) continue;
            return this.array[i];
        }
        throw new IllegalStateException("There was no element present in the list at index " + index + " even though number of elements in the list are " + this.size());
    }

    @Override
    public Cell set(int index, Cell e) {
        this.throwGenericUnsupportedOperationException();
        return null;
    }

    @Override
    public void add(int index, Cell element) {
        this.throwGenericUnsupportedOperationException();
    }

    @Override
    public Cell remove(int index) {
        this.throwGenericUnsupportedOperationException();
        return null;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null || this.isEmpty()) {
            return -1;
        }
        int numNonNull = -1;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] != null) {
                ++numNonNull;
            }
            if (!o.equals(this.array[i])) continue;
            return numNonNull;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null || this.isEmpty()) {
            return -1;
        }
        int lastIndex = this.numNonNullElements;
        for (int i = this.array.length - 1; i >= 0; --i) {
            if (this.array[i] != null) {
                --lastIndex;
            }
            if (!o.equals(this.array[i])) continue;
            return lastIndex;
        }
        return -1;
    }

    @Override
    public ListIterator<Cell> listIterator() {
        return new ListItr();
    }

    @Override
    public ListIterator<Cell> listIterator(int index) {
        this.throwGenericUnsupportedOperationException();
        return null;
    }

    @Override
    public List<Cell> subList(int fromIndex, int toIndex) {
        this.throwGenericUnsupportedOperationException();
        return null;
    }

    @Override
    public Iterator<Cell> iterator() {
        return new Itr();
    }

    public Cell getCellForColumnQualifier(byte[] qualifierBytes) {
        int columnQualifier = this.encodingScheme.decode(qualifierBytes);
        return this.getCellForColumnQualifier(columnQualifier);
    }

    public Cell getCellForColumnQualifier(byte[] qualifierBytes, int offset, int length) {
        int columnQualifier = this.encodingScheme.decode(qualifierBytes, offset, length);
        return this.getCellForColumnQualifier(columnQualifier);
    }

    private Cell getCellForColumnQualifier(int columnQualifier) {
        this.checkQualifierRange(columnQualifier);
        int idx = this.getArrayIndex(columnQualifier);
        Cell c = this.array[idx];
        return c;
    }

    public Cell getFirstCell() {
        if (this.firstNonNullElementIdx == -1) {
            throw new NoSuchElementException("No elements present in the list");
        }
        return this.array[this.firstNonNullElementIdx];
    }

    private void checkQualifierRange(int qualifier) {
        if (qualifier < 11) {
            return;
        }
        if (qualifier < this.minQualifier || qualifier > this.maxQualifier) {
            throw new IndexOutOfBoundsException("Qualifier " + qualifier + " is out of the valid range - (" + this.minQualifier + ", " + this.maxQualifier + ")");
        }
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private int getArrayIndex(int columnQualifier) {
        Preconditions.checkArgument((columnQualifier >= QueryConstants.ENCODED_EMPTY_COLUMN_NAME ? 1 : 0) != 0);
        if (columnQualifier < 11) {
            return columnQualifier;
        }
        return columnQualifier - this.nonReservedRangeOffset;
    }

    private void throwGenericUnsupportedOperationException() {
        throw new UnsupportedOperationException("Operation cannot be supported because it potentially violates the invariance contract of this list implementation");
    }

    private class ListItr
    extends Itr
    implements ListIterator<Cell> {
        private int previousIndex;

        private ListItr() {
            this.previousIndex = -1;
            this.moveForward(true);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex != -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex != -1;
        }

        @Override
        public Cell previous() {
            if (this.previousIndex == -1) {
                throw new NoSuchElementException();
            }
            this.checkForCoModification();
            this.lastRet = this.previousIndex;
            this.movePointersBackward();
            return EncodedColumnQualiferCellsList.this.array[this.lastRet];
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.previousIndex;
        }

        @Override
        public void remove() {
            if (this.lastRet == this.nextIndex) {
                this.moveNextPointer(this.nextIndex);
            }
            super.remove();
            this.expectedModCount = EncodedColumnQualiferCellsList.this.modCount;
        }

        @Override
        public void set(Cell e) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            int columnQualifier = EncodedColumnQualiferCellsList.this.encodingScheme.decode(e.getQualifierArray(), e.getQualifierOffset(), e.getQualifierLength());
            int idx = EncodedColumnQualiferCellsList.this.getArrayIndex(columnQualifier);
            if (idx != this.lastRet) {
                throw new IllegalArgumentException("Cell " + e + " with column qualifier " + columnQualifier + " belongs at index " + idx + ". It cannot be added at the position " + this.lastRet + " to which the previous next() or previous() was pointing to.");
            }
            EncodedColumnQualiferCellsList.this.add(e);
            this.expectedModCount = EncodedColumnQualiferCellsList.this.modCount;
        }

        @Override
        public void add(Cell e) {
            EncodedColumnQualiferCellsList.this.throwGenericUnsupportedOperationException();
        }

        @Override
        protected void moveForward(boolean init) {
            if (!init) {
                this.previousIndex = this.nextIndex;
            }
            int i = init ? 0 : this.nextIndex + 1;
            this.moveNextPointer(i);
        }

        private void moveNextPointer(int i) {
            while (i < EncodedColumnQualiferCellsList.this.array.length && EncodedColumnQualiferCellsList.this.array[i] == null) {
                ++i;
            }
            this.nextIndex = i < EncodedColumnQualiferCellsList.this.array.length ? i : -1;
        }

        private void movePointersBackward() {
            this.nextIndex = this.previousIndex;
            int i = this.previousIndex - 1;
            this.movePreviousPointer(i);
        }

        private void movePreviousPointer(int i) {
            while (i >= 0) {
                if (EncodedColumnQualiferCellsList.this.array[i] != null) {
                    this.previousIndex = i;
                    break;
                }
                --i;
            }
            if (i < 0) {
                this.previousIndex = -1;
            }
        }
    }

    private class Itr
    implements Iterator<Cell> {
        protected int nextIndex = 0;
        protected int lastRet = -1;
        protected int expectedModCount = EncodedColumnQualiferCellsList.access$200(EncodedColumnQualiferCellsList.this);

        private Itr() {
            this.moveForward(true);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex != -1;
        }

        @Override
        public Cell next() {
            this.checkForCoModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Cell next = EncodedColumnQualiferCellsList.this.array[this.nextIndex];
            this.lastRet = this.nextIndex;
            this.moveForward(false);
            EncodedColumnQualiferCellsList.this.modCount++;
            this.expectedModCount = EncodedColumnQualiferCellsList.this.modCount;
            return next;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForCoModification();
            ((EncodedColumnQualiferCellsList)EncodedColumnQualiferCellsList.this).array[this.lastRet] = null;
            this.lastRet = -1;
            EncodedColumnQualiferCellsList.this.numNonNullElements--;
            EncodedColumnQualiferCellsList.this.modCount++;
            this.expectedModCount = EncodedColumnQualiferCellsList.this.modCount;
        }

        protected void moveForward(boolean init) {
            int i;
            int n = i = init ? 0 : this.nextIndex + 1;
            while (i < EncodedColumnQualiferCellsList.this.array.length && EncodedColumnQualiferCellsList.this.array[i] == null) {
                ++i;
            }
            this.nextIndex = i < EncodedColumnQualiferCellsList.this.array.length ? i : -1;
        }

        protected void checkForCoModification() {
            if (EncodedColumnQualiferCellsList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

