/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.tuple;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.tuple.BaseTuple;

public class SingleKeyValueTuple
extends BaseTuple {
    private static final byte[] UNITIALIZED_KEY_BUFFER = new byte[0];
    private Cell cell;
    private ImmutableBytesWritable keyPtr = new ImmutableBytesWritable(UNITIALIZED_KEY_BUFFER);

    public SingleKeyValueTuple() {
    }

    public SingleKeyValueTuple(Cell cell) {
        if (cell == null) {
            throw new NullPointerException();
        }
        this.setCell(cell);
    }

    public boolean hasKey() {
        return this.keyPtr.get() != UNITIALIZED_KEY_BUFFER;
    }

    public void reset() {
        this.cell = null;
        this.keyPtr.set(UNITIALIZED_KEY_BUFFER);
    }

    public void setCell(Cell cell) {
        if (cell == null) {
            throw new IllegalArgumentException();
        }
        this.cell = cell;
        this.setKey(cell);
    }

    public void setKey(ImmutableBytesWritable ptr) {
        this.keyPtr.set(ptr.get(), ptr.getOffset(), ptr.getLength());
    }

    public void setKey(Cell cell) {
        if (cell == null) {
            throw new IllegalArgumentException();
        }
        this.keyPtr.set(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength());
    }

    @Override
    public void getKey(ImmutableBytesWritable ptr) {
        ptr.set(this.keyPtr.get(), this.keyPtr.getOffset(), this.keyPtr.getLength());
    }

    @Override
    public Cell getValue(byte[] cf, byte[] cq) {
        return this.cell;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    public String toString() {
        return "SingleKeyValueTuple[" + this.cell == null ? (this.keyPtr.get() == UNITIALIZED_KEY_BUFFER ? "null" : Bytes.toStringBinary((byte[])this.keyPtr.get(), (int)this.keyPtr.getOffset(), (int)this.keyPtr.getLength())) : this.cell.toString() + "]";
    }

    @Override
    public int size() {
        return this.cell == null ? 0 : 1;
    }

    @Override
    public Cell getValue(int index) {
        if (index != 0 || this.cell == null) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return this.cell;
    }

    @Override
    public boolean getValue(byte[] family, byte[] qualifier, ImmutableBytesWritable ptr) {
        if (this.cell == null) {
            return false;
        }
        ptr.set(this.cell.getValueArray(), this.cell.getValueOffset(), this.cell.getValueLength());
        return true;
    }
}

