/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ColumnValueDecoder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.util.ByteUtil;

public class PArrayDataTypeDecoder
implements ColumnValueDecoder {
    @Override
    public boolean decode(ImmutableBytesWritable ptr, int index) {
        return PArrayDataTypeDecoder.positionAtArrayElement(ptr, index, PVarbinary.INSTANCE, null);
    }

    public static boolean positionAtArrayElement(Tuple tuple, ImmutableBytesWritable ptr, int index, Expression arrayExpr, PDataType pDataType, Integer maxLen) {
        if (!arrayExpr.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        return PArrayDataTypeDecoder.positionAtArrayElement(ptr, index - 1, pDataType, maxLen);
    }

    public static boolean positionAtArrayElement(ImmutableBytesWritable ptr, int arrayIndex, PDataType baseDataType, Integer byteSize) {
        byte[] bytes = ptr.get();
        int initPos = ptr.getOffset();
        if (!baseDataType.isFixedWidth()) {
            byte serializationVersion = bytes[ptr.getOffset() + ptr.getLength() - 1];
            int noOfElements = Bytes.toInt((byte[])bytes, (int)(ptr.getOffset() + ptr.getLength() - 5), (int)4);
            boolean useShort = true;
            if (noOfElements < 0) {
                noOfElements = -noOfElements;
                useShort = false;
            }
            if (arrayIndex >= noOfElements) {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                return false;
            }
            int indexOffset = Bytes.toInt((byte[])bytes, (int)(ptr.getOffset() + ptr.getLength() - 9)) + ptr.getOffset();
            int currOffset = PArrayDataType.getSerializedOffset(bytes, arrayIndex, useShort, indexOffset, serializationVersion);
            if (currOffset < 0) {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                return false;
            }
            int elementLength = 0;
            if (arrayIndex == noOfElements - 1) {
                int separatorBytes = serializationVersion == 1 ? 3 : 0;
                elementLength = bytes[currOffset + initPos] == 0 || bytes[currOffset + initPos] == QueryConstants.DESC_SEPARATOR_BYTE ? 0 : indexOffset - (currOffset + initPos) - separatorBytes;
            } else {
                int separatorByte = serializationVersion == 1 ? 1 : 0;
                elementLength = bytes[currOffset + initPos] == 0 || bytes[currOffset + initPos] == QueryConstants.DESC_SEPARATOR_BYTE ? 0 : PArrayDataType.getOffset(bytes, arrayIndex + 1, useShort, indexOffset, serializationVersion) - currOffset - separatorByte;
            }
            ptr.set(bytes, currOffset + initPos, elementLength);
        } else {
            int elemByteSize = byteSize == null ? baseDataType.getByteSize() : byteSize;
            int offset = arrayIndex * elemByteSize;
            if (offset >= ptr.getLength()) {
                ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            } else {
                ptr.set(bytes, ptr.getOffset() + offset, elemByteSize);
            }
        }
        return true;
    }
}

