/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PUnsignedLong;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PUnsignedLongArray
extends PArrayDataType<long[]> {
    public static final PUnsignedLongArray INSTANCE = new PUnsignedLongArray();

    private PUnsignedLongArray() {
        super("UNSIGNED_LONG ARRAY", 3000 + PUnsignedLong.INSTANCE.getSqlType(), PhoenixArray.class, null, 42);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return this.compareTo(lhs, rhs);
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public byte[] toBytes(Object object) {
        return this.toBytes(object, SortOrder.ASC);
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        return this.toBytes(object, PUnsignedLong.INSTANCE, sortOrder);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(bytes, offset, length, PUnsignedLong.INSTANCE, sortOrder, maxLength, scale, PUnsignedLong.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.isCoercibleTo(targetType, this);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        long[] longArr;
        if (value == null) {
            return true;
        }
        PhoenixArray.PrimitiveLongPhoenixArray pArr = (PhoenixArray.PrimitiveLongPhoenixArray)value;
        long[] arr$ = longArr = (long[])pArr.array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long i = arr$[i$];
            if (super.isCoercibleTo((PDataType)PUnsignedLong.INSTANCE, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return this.getSampleValue(PUnsignedLong.INSTANCE, arrayLength, maxLength);
    }
}

