/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.trace;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.htrace.Span;
import org.apache.htrace.SpanReceiver;
import org.apache.phoenix.query.QueryServicesOptions;

public class TraceSpanReceiver
implements SpanReceiver {
    private static final Log LOG = LogFactory.getLog(TraceSpanReceiver.class);
    private static final int CAPACITY = QueryServicesOptions.withDefaults().getTracingTraceBufferSize();
    private BlockingQueue<Span> spanQueue = new ArrayBlockingQueue<Span>(CAPACITY);

    public void receiveSpan(Span span) {
        if (span.getTraceId() != 0L && this.spanQueue.offer(span)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Span buffered to queue " + span.toJson()));
            }
        } else if (span.getTraceId() != 0L && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Span NOT buffered due to overflow in queue " + span.toJson()));
        }
    }

    public void close() throws IOException {
    }

    boolean isSpanAvailable() {
        return this.spanQueue.isEmpty();
    }

    Span getSpan() {
        return (Span)this.spanQueue.poll();
    }

    int getNumSpans() {
        return this.spanQueue.size();
    }
}

