/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.trace;

import java.sql.SQLException;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.iterate.DelegateResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.tuple.Tuple;

public class TracingIterator
extends DelegateResultIterator {
    private TraceScope scope;
    private boolean started;

    public TracingIterator(TraceScope scope, ResultIterator iterator) {
        super(iterator);
        this.scope = scope;
    }

    @Override
    public void close() throws SQLException {
        this.scope.close();
        super.close();
    }

    @Override
    public Tuple next() throws SQLException {
        if (!this.started) {
            this.scope.getSpan().addTimelineAnnotation("First request completed");
            this.started = true;
        }
        return super.next();
    }

    public String toString() {
        return "TracingIterator [scope=" + this.scope + ", started=" + this.started + "]";
    }
}

