/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.transaction;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.twill.zookeeper.ZKClientService;
import org.slf4j.Logger;

public interface PhoenixTransactionContext {
    public static final String TX_ROLLBACK_ATTRIBUTE_KEY = "tephra.tx.rollback";
    public static final String PROPERTY_TTL = "dataset.table.ttl";
    public static final String READ_NON_TX_DATA = "data.tx.read.pre.existing";

    public void setInMemoryTransactionClient(Configuration var1);

    public ZKClientService setTransactionClient(Configuration var1, ReadOnlyProps var2, PhoenixEmbeddedDriver.ConnectionInfo var3);

    public void begin() throws SQLException;

    public void commit() throws SQLException;

    public void abort() throws SQLException;

    public void checkpoint(boolean var1) throws SQLException;

    public void commitDDLFence(PTable var1, Logger var2) throws SQLException;

    public void join(PhoenixTransactionContext var1);

    public boolean isTransactionRunning();

    public void reset();

    public long getTransactionId();

    public long getReadPointer();

    public long getWritePointer();

    public void setVisibilityLevel(PhoenixVisibilityLevel var1);

    public PhoenixVisibilityLevel getVisibilityLevel();

    public byte[] encodeTransaction() throws SQLException;

    public long getMaxTransactionsPerSecond();

    public boolean isPreExistingVersion(long var1);

    public BaseRegionObserver getCoProcessor();

    public byte[] getFamilyDeleteMarker();

    public void setTxnConfigs(Configuration var1, String var2, int var3) throws IOException;

    public void setupTxManager(Configuration var1, String var2) throws SQLException;

    public void tearDownTxManager();

    public static enum PhoenixVisibilityLevel {
        SNAPSHOT,
        SNAPSHOT_EXCLUDE_CURRENT,
        SNAPSHOT_ALL;

    }
}

