/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.transaction;

import java.io.IOException;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.transaction.OmidTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionalTable;
import org.apache.phoenix.transaction.TephraTransactionContext;
import org.apache.phoenix.transaction.TephraTransactionTable;

public class TransactionFactory {
    private static TransactionFactory transactionFactory = null;
    private TransactionProcessor tp = TransactionProcessor.Tephra;

    private TransactionFactory(TransactionProcessor tp) {
        this.tp = tp;
    }

    public static void createTransactionFactory(TransactionProcessor tp) {
        if (transactionFactory == null) {
            transactionFactory = new TransactionFactory(tp);
        }
    }

    public static TransactionFactory getTransactionFactory() {
        if (transactionFactory == null) {
            TransactionFactory.createTransactionFactory(TransactionProcessor.Tephra);
        }
        return transactionFactory;
    }

    public PhoenixTransactionContext getTransactionContext() {
        PhoenixTransactionContext ctx = null;
        switch (this.tp) {
            case Tephra: {
                ctx = new TephraTransactionContext();
                break;
            }
            case Omid: {
                ctx = new OmidTransactionContext();
                break;
            }
            default: {
                ctx = null;
            }
        }
        return ctx;
    }

    public PhoenixTransactionContext getTransactionContext(byte[] txnBytes) throws IOException {
        TephraTransactionContext ctx = null;
        switch (this.tp) {
            case Tephra: {
                ctx = new TephraTransactionContext(txnBytes);
                break;
            }
            case Omid: {
                break;
            }
            default: {
                ctx = null;
            }
        }
        return ctx;
    }

    public PhoenixTransactionContext getTransactionContext(PhoenixConnection connection) {
        TephraTransactionContext ctx = null;
        switch (this.tp) {
            case Tephra: {
                ctx = new TephraTransactionContext(connection);
                break;
            }
            case Omid: {
                break;
            }
            default: {
                ctx = null;
            }
        }
        return ctx;
    }

    public PhoenixTransactionContext getTransactionContext(PhoenixTransactionContext contex, PhoenixConnection connection, boolean subTask) {
        TephraTransactionContext ctx = null;
        switch (this.tp) {
            case Tephra: {
                ctx = new TephraTransactionContext(contex, connection, subTask);
                break;
            }
            case Omid: {
                break;
            }
            default: {
                ctx = null;
            }
        }
        return ctx;
    }

    public PhoenixTransactionalTable getTransactionalTable(PhoenixTransactionContext ctx, HTableInterface htable) {
        TephraTransactionTable table = null;
        switch (this.tp) {
            case Tephra: {
                table = new TephraTransactionTable(ctx, htable);
                break;
            }
            case Omid: {
                break;
            }
            default: {
                table = null;
            }
        }
        return table;
    }

    static enum TransactionProcessor {
        Tephra,
        Omid;

    }
}

