/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

public class Base62Encoder {
    public static final char[] digits = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] DigitTens = new char[3844];
    private static final char[] DigitOnes = new char[3844];
    static final long[] pow62;

    static int stringSize(long num) {
        for (int i = 0; i < 10; ++i) {
            if (num >= pow62[i]) continue;
            return i + 1;
        }
        return 11;
    }

    static void getChars(long num, int size, char[] buf) {
        int q2;
        int r;
        int charPos = size;
        int sign = 0;
        if (num < 0L) {
            sign = 45;
            num = -num;
        }
        while (num > Integer.MAX_VALUE) {
            long q = num / 3844L;
            r = (int)(num - q * 3844L);
            num = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        int i2 = (int)num;
        while (i2 >= 65536) {
            q2 = i2 / 3844;
            r = i2 - q2 * 3844;
            i2 = q2;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q2 = (i2 + 1) * 33825 >>> 21;
            r = i2 - q2 * 62;
            buf[--charPos] = digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    public static String toString(long num) {
        if (num == Long.MIN_VALUE) {
            return "-AzL8n0Y58m8";
        }
        int size = num < 0L ? Base62Encoder.stringSize(-num) + 1 : Base62Encoder.stringSize(num);
        char[] buf = new char[size];
        Base62Encoder.getChars(num, size, buf);
        return new String(buf);
    }

    static {
        for (int i = 0; i < 62; i = (int)((byte)(i + 1))) {
            for (int j = 0; j < 62; j = (int)((byte)(j + 1))) {
                Base62Encoder.DigitTens[i * 62 + j] = digits[i];
                Base62Encoder.DigitOnes[i * 62 + j] = digits[j];
            }
        }
        pow62 = new long[]{62L, 3844L, 238328L, 14776336L, 916132832L, 56800235584L, 3521614606208L, 218340105584896L, 13537086546263552L, 839299365868340224L};
    }
}

