/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.schema.TableRef;

public class KeyValueUtil {
    private KeyValueUtil() {
    }

    public static KeyValue newKeyValue(byte[] key, byte[] cf, byte[] cq, long ts, byte[] value, int valueOffset, int valueLength) {
        return new KeyValue(key, 0, key.length, cf, 0, cf.length, cq, 0, cq.length, ts, KeyValue.Type.Put, value, valueOffset, valueLength);
    }

    public static KeyValue newKeyValue(ImmutableBytesWritable key, byte[] cf, byte[] cq, long ts, byte[] value, int valueOffset, int valueLength) {
        return new KeyValue(key.get(), key.getOffset(), key.getLength(), cf, 0, cf.length, cq, 0, cq.length, ts, KeyValue.Type.Put, value, valueOffset, valueLength);
    }

    public static KeyValue newKeyValue(byte[] key, int keyOffset, int keyLength, byte[] cf, byte[] cq, long ts, byte[] value, int valueOffset, int valueLength) {
        return new KeyValue(key, keyOffset, keyLength, cf, 0, cf.length, cq, 0, cq.length, ts, KeyValue.Type.Put, value, valueOffset, valueLength);
    }

    public static KeyValue newKeyValue(byte[] key, int keyOffset, int keyLength, byte[] cf, int cfOffset, int cfLength, byte[] cq, int cqOffset, int cqLength, long ts, byte[] value, int valueOffset, int valueLength) {
        return new KeyValue(key, keyOffset, keyLength, cf, cfOffset, cfLength, cq, cqOffset, cqLength, ts, KeyValue.Type.Put, value, valueOffset, valueLength);
    }

    public static KeyValue newKeyValue(byte[] key, byte[] cf, byte[] cq, long ts, byte[] value) {
        return KeyValueUtil.newKeyValue(key, cf, cq, ts, value, 0, value.length);
    }

    public static Cell getColumnLatest(KeyValueBuilder kvBuilder, List<Cell> kvs, byte[] family, byte[] qualifier) {
        if (kvs.size() == 0) {
            return null;
        }
        assert (CellUtil.matchingRow((Cell)kvs.get(0), (Cell)kvs.get(kvs.size() - 1)));
        SearchComparator comp = new SearchComparator(kvBuilder, family, qualifier);
        int pos = Collections.binarySearch(kvs, null, comp);
        if (pos < 0 || pos == kvs.size()) {
            return null;
        }
        return kvs.get(pos);
    }

    public static Cell getColumnLatest(KeyValueBuilder kvBuilder, Cell[] kvs, byte[] family, byte[] qualifier) {
        if (kvs.length == 0) {
            return null;
        }
        assert (CellUtil.matchingRow((Cell)kvs[0], (Cell)kvs[kvs.length - 1]));
        SearchComparator comp = new SearchComparator(kvBuilder, family, qualifier);
        int pos = Arrays.binarySearch(kvs, null, comp);
        if (pos < 0 || pos == kvs.length) {
            return null;
        }
        return kvs[pos];
    }

    public static long calculateMutationDiskSize(Mutation m) {
        long size = 0L;
        for (Map.Entry entry : m.getFamilyCellMap().entrySet()) {
            for (Cell c : (List)entry.getValue()) {
                size += (long)org.apache.hadoop.hbase.KeyValueUtil.length((Cell)c);
            }
        }
        return size;
    }

    public static long getEstimatedRowMutationSize(Map<TableRef, MutationState.MultiRowMutationState> tableMutationMap) {
        long size = 0L;
        for (Map.Entry<TableRef, MutationState.MultiRowMutationState> tableEntry : tableMutationMap.entrySet()) {
            for (Map.Entry<ImmutableBytesPtr, MutationState.RowMutationState> rowEntry : tableEntry.getValue().entrySet()) {
                size += KeyValueUtil.calculateRowMutationSize(rowEntry);
            }
        }
        return size;
    }

    private static long calculateRowMutationSize(Map.Entry<ImmutableBytesPtr, MutationState.RowMutationState> rowEntry) {
        int rowLength = rowEntry.getKey().getLength();
        long colValuesLength = rowEntry.getValue().calculateEstimatedSize();
        return (long)rowLength + colValuesLength;
    }

    private static class SearchComparator
    implements Comparator<Cell> {
        private final KeyValueBuilder kvBuilder;
        private final byte[] family;
        private final byte[] qualifier;

        public SearchComparator(KeyValueBuilder kvBuilder, byte[] f, byte[] q) {
            this.kvBuilder = kvBuilder;
            this.family = f;
            this.qualifier = q;
        }

        @Override
        public int compare(Cell l, Cell ignored) {
            assert (ignored == null);
            int val = this.kvBuilder.compareFamily(l, this.family, 0, this.family.length);
            if (val != 0) {
                return val;
            }
            return this.kvBuilder.compareQualifier(l, this.qualifier, 0, this.qualifier.length);
        }
    }
}

