/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.concurrent.Callable;
import org.apache.phoenix.call.CallWrapper;

public class PhoenixContextExecutor {
    private static final ClassLoader CACHED_CLASSLOADER = PhoenixContextExecutor.class.getClassLoader();

    public static CallWrapper inContext() {
        return new CurrentContextWrapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T call(Callable<T> target) throws Exception {
        ClassLoader saveCcl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CACHED_CLASSLOADER);
            T t = target.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(saveCcl);
        }
    }

    public static <T> T callWithoutPropagation(Callable<T> target) {
        try {
            return PhoenixContextExecutor.call(target);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class CurrentContextWrapper
    implements CallWrapper {
        private ClassLoader saveCcl;

        private CurrentContextWrapper() {
        }

        @Override
        public void before() {
            this.saveCcl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(CACHED_CLASSLOADER);
        }

        @Override
        public void after() {
            Thread.currentThread().setContextClassLoader(this.saveCcl);
        }
    }
}

