/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.codehaus.jettison.json.JSONException;

public class PhoenixMRJobUtil {
    private static final String YARN_LEADER_ELECTION = "/yarn-leader-election";
    private static final String ACTIVE_STANDBY_ELECTOR_LOCK = "ActiveStandbyElectorLock";
    private static final String RM_APPS_GET_ENDPOINT = "/ws/v1/cluster/apps";
    private static final int CLIENT_RETRIES_NUMBER = 2;
    private static final long CLIENT_PAUSE_TIME = 1000L;
    private static final int ZOOKEEPER_RECOVERY_RETRY_COUNT = 1;
    public static final String PHOENIX_INDEX_MR_QUEUE_NAME_PROPERTY = "phoenix.index.mr.scheduler.capacity.queuename";
    public static final String PHOENIX_INDEX_MR_MAP_MEMORY_PROPERTY = "phoenix.index.mr.scheduler.capacity.mapMemoryMB";
    public static final String DEFAULT_QUEUE_NAME = "default";
    public static final int DEFAULT_MAP_MEMROY_MB = 5120;
    public static final String XMX_OPT = "-Xmx";
    public static final String RM_HTTP_SCHEME = "http";
    public static final int RM_CONNECT_TIMEOUT_MILLIS = 10000;
    public static final int RM_READ_TIMEOUT_MILLIS = 600000;
    private static final Log LOG = LogFactory.getLog(PhoenixMRJobUtil.class);
    public static final String PHOENIX_MR_SCHEDULER_TYPE_NAME = "phoenix.index.mr.scheduler.type";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getActiveResourceManagerHost(Configuration config, String zkQuorum) throws IOException, InterruptedException, JSONException, KeeperException, InvalidProtocolBufferException, ZooKeeperConnectionException {
        ZooKeeperWatcher zkw = null;
        ZooKeeper zk = null;
        String activeRMHost = null;
        try {
            zkw = new ZooKeeperWatcher(config, "get-active-yarnmanager", null);
            zk = new ZooKeeper(zkQuorum, 30000, (Watcher)zkw, false);
            List children = zk.getChildren(YARN_LEADER_ELECTION, (Watcher)zkw);
            for (String subEntry : children) {
                List subChildern = zk.getChildren("/yarn-leader-election/" + subEntry, (Watcher)zkw);
                for (String eachEntry : subChildern) {
                    if (!eachEntry.contains(ACTIVE_STANDBY_ELECTOR_LOCK)) continue;
                    String path = "/yarn-leader-election/" + subEntry + "/" + ACTIVE_STANDBY_ELECTOR_LOCK;
                    byte[] data = zk.getData(path, (Watcher)zkw, new Stat());
                    YarnServerResourceManagerServiceProtos.ActiveRMInfoProto proto = YarnServerResourceManagerServiceProtos.ActiveRMInfoProto.parseFrom((byte[])data);
                    proto.getRmId();
                    LOG.info((Object)("Active RmId : " + proto.getRmId()));
                    activeRMHost = config.get("yarn.resourcemanager.hostname." + proto.getRmId());
                    LOG.info((Object)("activeResourceManagerHostname = " + activeRMHost));
                }
            }
        }
        finally {
            if (zkw != null) {
                zkw.close();
            }
            if (zk != null) {
                zk.close();
            }
        }
        return activeRMHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJobsInformationFromRM(String rmhost, int rmport, Map<String, String> urlParams) throws MalformedURLException, ProtocolException, UnsupportedEncodingException, IOException {
        HttpURLConnection con = null;
        String response = null;
        String url = null;
        try {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append("http://").append(rmhost).append(":").append(rmport).append(RM_APPS_GET_ENDPOINT);
            if (urlParams != null && urlParams.size() != 0) {
                urlBuilder.append("?");
                for (String key : urlParams.keySet()) {
                    urlBuilder.append(key + "=" + urlParams.get(key) + "&");
                }
                urlBuilder.delete(urlBuilder.length() - 1, urlBuilder.length());
            }
            url = urlBuilder.toString();
            LOG.info((Object)("Attempt to get running/submitted jobs information from RM URL = " + url));
            URL obj = new URL(url);
            con = (HttpURLConnection)obj.openConnection();
            con.setInstanceFollowRedirects(true);
            con.setRequestMethod("GET");
            con.setConnectTimeout(10000);
            con.setReadTimeout(600000);
            response = PhoenixMRJobUtil.getTextContent(con.getInputStream());
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        LOG.info((Object)("Result of attempt to get running/submitted jobs from RM - URL=" + url + ",ResponseCode=" + con.getResponseCode() + ",Response=" + response));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTextContent(InputStream is) throws IOException {
        BufferedReader in = null;
        StringBuilder response = null;
        try {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(is));
            response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine).append("\n");
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return response.toString();
    }

    public static void shutdown(ExecutorService pool) throws InterruptedException {
        pool.shutdown();
        LOG.debug((Object)"Shutdown called");
        pool.awaitTermination(200L, TimeUnit.MILLISECONDS);
        LOG.debug((Object)"Await termination called to wait for 200 msec");
        if (!pool.isShutdown()) {
            pool.shutdownNow();
            LOG.debug((Object)"Await termination called to wait for 200 msec");
            pool.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        if (!pool.isShutdown()) {
            LOG.warn((Object)"Pool did not shutdown");
        }
    }

    public static int getRMPort(Configuration conf) throws IOException {
        String rmHostPortStr = conf.get("yarn.resourcemanager.webapp.address");
        String[] rmHostPort = rmHostPortStr.split(":");
        if (rmHostPort == null || rmHostPort.length != 2) {
            throw new IOException("Invalid value for property yarn.resourcemanager.webapp.address = " + rmHostPortStr);
        }
        int rmPort = Integer.parseInt(rmHostPort[1]);
        return rmPort;
    }

    public static void updateTimeoutsToFailFast(Configuration conf) {
        conf.set("hbase.client.retries.number", String.valueOf(2));
        conf.set("zookeeper.recovery.retry", String.valueOf(1));
        conf.set("hbase.client.pause", String.valueOf(1000L));
    }

    public static void updateCapacityQueueInfo(Configuration conf) {
        conf.set("mapreduce.job.queuename", conf.get(PHOENIX_INDEX_MR_QUEUE_NAME_PROPERTY, DEFAULT_QUEUE_NAME));
        int mapMemoryMB = conf.getInt(PHOENIX_INDEX_MR_MAP_MEMORY_PROPERTY, 5120);
        conf.setInt("mapreduce.map.memory.mb", mapMemoryMB);
        conf.set("mapreduce.map.java.opts", XMX_OPT + (int)((double)mapMemoryMB * 0.9) + "m");
        LOG.info((Object)("Queue Name=" + conf.get("mapreduce.job.queuename") + ";" + "Map Meory MB=" + conf.get("mapreduce.map.memory.mb") + ";" + "Map Java Opts=" + conf.get("mapreduce.map.java.opts")));
    }

    public static enum MR_SCHEDULER_TYPE {
        CAPACITY,
        FAIR,
        NONE;

    }
}

